/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;

public abstract class NotificationProcessingApi {
    private final Notification.Type type;
    protected BankSettings bank;
    protected final BLLogger logger;
    protected final EncryptData encryptData;
    private File bankDir = null;

    public NotificationProcessingApi(Notification.Type type, BLLogger logger, EncryptData encryptData) {
        this.type = type;
        this.logger = logger;
        this.encryptData = encryptData;
    }

    protected void setBank(BankSettings bank) {
        this.bank = bank;
        this.bankDir = new File(WorkspaceFileSystem.NOTIFICATION_DIR, bank.getUniqueKey());
    }

    protected File createDataFile() throws IOException {
        if (!this.bankDir.exists()) {
            this.bankDir.mkdirs();
        }
        return File.createTempFile(this.type.getHandlerKey(), "." + this.type.getHandlerKey(), this.bankDir);
    }

    protected Notification createBaseNotification(File dataFile, Date creationDate, String md5Hash, BankSettings bank, String orderType, String fileType) {
        Notification n = new Notification();
        n.setBank(bank);
        if (creationDate != null) {
            n.setFetched(new Timestamp(creationDate.getTime()));
        } else {
            n.setFetched(new Timestamp(System.currentTimeMillis()));
        }
        WorkspaceFile workspaceFile = WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.NOTIFICATIONS, dataFile, dataFile.length(), md5Hash, null);
        n.setFile(workspaceFile);
        if (this.type == null) {
            this.logger.logError("Notification type not set for processing of file '" + dataFile.getName() + "'", null);
            throw new RuntimeException("Notification type not set !");
        }
        n.setType(this.type);
        n.setFileType(fileType);
        n.setOrderType(orderType);
        return n;
    }

    protected Notification.Type getType() {
        return this.type;
    }
}

