/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.NotificationUtil;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.format.iso20022.pain00200103.Hac2Pdf;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.PDFException;
import io.ebean.Query;
import java.io.OutputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NotificationPrinter {
    private final Logger LOGGER = Logger.getLogger(NotificationPrinter.class.getName());
    private BLDocument document;
    protected boolean documentHasPage;
    protected boolean printLogo;
    private final OutputStream outputStream;
    protected final User user;
    protected final Locale locale;

    public NotificationPrinter(OutputStream outputStream, User user, Locale locale) {
        this.outputStream = outputStream;
        this.user = user;
        this.locale = locale;
        this.printLogo = Util.printLogo(user);
    }

    public NotificationPrinter(OutputStream outputStream, User user, Locale locale, boolean printLogo) {
        this.outputStream = outputStream;
        this.user = user;
        this.locale = locale;
        this.printLogo = printLogo;
    }

    public BLDocument createDocumentOrPage(BLDocument.PageLayout pageLayout) throws PDFException {
        if (this.document == null) {
            this.document = Util.createBLDocument(this.outputStream, pageLayout, BankingApiMessages.getString(this.locale, "GeneralMessages.notification", new Object[0]), this.printLogo, this.locale);
        }
        if (this.documentHasPage) {
            this.document.setPageSize(pageLayout);
            this.document.newPage();
        }
        return this.document;
    }

    private void print(PtkEntry ptk) throws PDFException {
        this.createDocumentForPtk(TransferApiMessages.getString(this.locale, "notification.print.ptk.title", new Object[0]));
        this.document.addTextln(ptk.getData(), BLFont.COURIER_SMALL);
        this.documentHasPage = true;
    }

    private void printPtkErrorProtocol(Send send) throws PDFException {
        Query<PtkEntry> ptkEntries = ProtocolUtil.getPtkEntries(send);
        if (ptkEntries.findCount() > 0) {
            this.createDocumentForPtk(NotificationUtil.getErrorProtocolTitle(send, "PTK", this.locale));
            for (PtkEntry ptk : ptkEntries.findList()) {
                this.document.addTextln(ptk.getData(), BLFont.COURIER_SMALL);
            }
            this.documentHasPage = true;
        } else {
            this.LOGGER.log(Level.SEVERE, "Could not find PTK entries for send order with ID " + send.getId());
        }
    }

    private void createDocumentForPtk(String title) throws PDFException {
        this.createDocumentOrPage(BLDocument.PageLayout.A4);
        this.document.addHeadline(title, BLFont.FONT_BOLD, null, 20.0f);
    }

    private void print(HacEntry hac) throws PDFException {
        this.createDocumentForHac(TransferApiMessages.getString(this.locale, "notification.print.hac.title", new Object[0]));
        Hac2Pdf hac2pdf = new Hac2Pdf(false, this.locale);
        this.document.addTable(hac2pdf.addEntry(ProtocolUtil.toHAC(hac)));
        this.documentHasPage = true;
    }

    private void printHacErrorProtocol(Send send) throws PDFException {
        Query<HacEntry> hacEntries = ProtocolUtil.getHacEntries(send);
        if (hacEntries != null && hacEntries.findCount() > 0) {
            this.createDocumentForHac(NotificationUtil.getErrorProtocolTitle(send, "HAC", this.locale));
            Hac2Pdf hac2pdf = new Hac2Pdf(false, this.locale);
            for (HacEntry entry : hacEntries.findList()) {
                hac2pdf.addEntry(ProtocolUtil.toHAC(entry));
            }
            this.document.addTable(hac2pdf.getHacTable());
            this.documentHasPage = true;
        } else {
            this.LOGGER.log(Level.SEVERE, "Could not find HAC entries for send order with ID " + send.getId());
        }
    }

    private void createDocumentForHac(String title) throws PDFException {
        this.createDocumentOrPage(BLDocument.PageLayout.A4);
        this.document.addHeadline(title, BLFont.FONT_BOLD, null, 20.0f);
    }

    public void finish() {
        try {
            this.document.close();
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
    }

    public final void print(Notification notification) throws PDFException {
        if (notification.isAdditionalInfoFromPTK()) {
            try {
                int ptkId = Integer.parseInt(notification.getOrderInfo().substring(4));
                PtkEntry ptkEntry = DB.find(PtkEntry.class, ptkId);
                if (ptkEntry != null && ptkEntry.getData() != null) {
                    this.print(ptkEntry);
                }
            }
            catch (NumberFormatException e) {
                this.LOGGER.log(Level.SEVERE, "Failed to parse PTK ID of notification!", e);
            }
        } else if (notification.isAdditionalInfoFromHAC()) {
            try {
                int hacId = Integer.parseInt(notification.getOrderInfo().substring(4));
                HacEntry hacEntry = DB.find(HacEntry.class, hacId);
                if (hacEntry != null && hacEntry.getAdditionalInformation() != null) {
                    this.print(hacEntry);
                }
            }
            catch (NumberFormatException e) {
                this.LOGGER.log(Level.SEVERE, "Failed to parse HAC ID of notification!", e);
            }
        } else if (notification.isErrorNotificationFromHAC()) {
            Send send = notification.getSend();
            if (send != null) {
                this.printHacErrorProtocol(send);
            } else {
                this.LOGGER.log(Level.SEVERE, "Could not find send order for error notification with ID " + notification.getId());
            }
        } else if (notification.isErrorNotificationFromPTK()) {
            Send send = notification.getSend();
            if (send != null) {
                this.printPtkErrorProtocol(send);
            } else {
                this.LOGGER.log(Level.SEVERE, "Could not find send order for error notification with ID " + notification.getId());
            }
        } else {
            this.printOther(notification);
            this.documentHasPage = true;
        }
    }

    public abstract void printOther(Notification var1) throws PDFException;
}

