/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.format.iso20022.pain00200103.HACEntry;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.util.SystemUtils;
import io.ebean.Transaction;
import java.io.File;
import java.util.Date;
import java.util.List;

public final class NotificationDeleteHandler {
    public static void deleteNotifications(List<Notification> list) {
        try (Transaction t = DB.beginTransaction();){
            for (Notification item : list) {
                WorkspaceFileSystem.delete(item.getFile());
                item.delete();
                NotificationDeleteHandler.deleteCustomerProtocolEntry(item);
            }
            t.commit();
        }
    }

    private static int deleteCustomerProtocolEntry(Notification item) {
        if ("PTK".equals(item.getOrderType())) {
            return PtkEntry.deleteByTimeAndAction(item.getBank(), item.getFetched(), Action.ADDITIONAL_INFO.getId());
        }
        if ("HAC".equals(item.getOrderType())) {
            return HacEntry.deleteByTimeAndAction(item.getBank(), item.getFetched(), HACEntry.Action.ADDITIONAL.ordinal());
        }
        return 0;
    }

    public static List<Notification> findOlderThan(Date oldest) {
        List list = DB.find(Notification.class).where().lt("fetched", (Object)oldest).findList();
        return list;
    }

    public static int deleteOlderThan(Date oldest) {
        List list = DB.find(Notification.class).where().lt("fetched", (Object)oldest).findList();
        NotificationDeleteHandler.deleteNotifications(list);
        return list.size();
    }

    public static void delete(BankSettings bank) {
        File toReturn = NotificationDeleteHandler.getBankDir(bank);
        SystemUtils.deleteRecursive(toReturn);
        Notification.deleteByBank(bank);
    }

    public static File getBankDir(BankSettings b) {
        return new File(WorkspaceFileSystem.NOTIFICATION_DIR, b.getUniqueKey());
    }
}

