/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PrintUtil;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.iso20022.pain00200103.HAC30Parser;
import de.businesslogics.format.ptk2.PTKEntry;
import de.businesslogics.format.ptk2.PTKParser;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Locale;
import org.xml.sax.SAXException;

public class HacPtkPrinterApi {
    private static final BLFont DISPLAY = BLFont.COURIER_SMALL;
    private final BLFont H1 = BLFont.H1_BOLD;
    private OrderType orderType;
    private final BLLogger logger;
    private final EncryptData encrypt;

    public HacPtkPrinterApi(BLLogger logger, EncryptData encrypt) {
        this.logger = logger;
        this.encrypt = encrypt;
    }

    public boolean canHandle(String orderType) {
        try {
            this.orderType = OrderType.valueOf(orderType);
        }
        catch (IllegalArgumentException ie) {
            this.logger.logError("Unsupported ordertype:" + orderType);
            return false;
        }
        switch (this.orderType.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void addToDocument(BankSettings bank, File file, String orderType, BLDocument document, boolean pageBreak, Locale locale) throws IOException, PDFException {
        if (null != file && file.exists() && this.canHandle(orderType)) {
            String title = TransferApiMessages.getString(locale, "bankprotocolprinter.title", bank.getDisplayName());
            document.addHeadline(title, this.H1, Alignment.ALIGN_CENTER, 10.0f);
            switch (this.orderType.ordinal()) {
                case 0: {
                    PrintUtil.HacTable hacTable = new PrintUtil.HacTable(true, locale);
                    hacTable.setBank(bank);
                    try {
                        this.parseHAC(hacTable, this.encrypt.openInputStream(file));
                    }
                    catch (SAXException e) {
                        throw new IOException(e);
                    }
                    document.addTable(hacTable.getHacTable());
                    break;
                }
                case 1: {
                    try {
                        PTKParser ptkParser = new PTKParser(this.encrypt.openInputStream(file));
                        PTKEntry ptkEntry = ptkParser.nextEntry();
                        while (null != ptkEntry) {
                            document.addTextln(ptkEntry.toString(locale), DISPLAY);
                            ptkEntry = ptkParser.nextEntry();
                        }
                        break;
                    }
                    catch (ParseException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
    }

    private void parseHAC(final PrintUtil.HacTable hacTable, InputStream in) throws SAXException, IOException {
        HAC30Parser parser = new HAC30Parser(new HAC30Parser.Listener(){

            @Override
            public void handle(HAC30Entry hac) {
                hacTable.addEntry(hac);
            }
        });
        parser.parse(in);
    }

    private static enum OrderType {
        HAC,
        PTK;

    }
}

