/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.transfer.api.PreScheduler;
import de.businesslogics.banking.transfer.api.RunnableFetchScheduler;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.client.DistributedSignature;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.orders.HVZOrderDetails;
import de.businesslogics.ebics.schema.orders.HVZResponseOrderData;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Set;

public class HVZPreScheduler
implements PreScheduler,
RunnableFetchScheduler {
    private static final String EXPORT_PATH = System.getProperty("de.businesslogics.banking.transfer.api.HVZPreScheduler.dir", null);

    public static boolean canUseHVZPreScheduler() {
        return EXPORT_PATH != null;
    }

    @Override
    public Set<String> getOrderOrFileTypes(Scheduler s) {
        return Collections.singleton("HVZ");
    }

    @Override
    public YYMMDD getFromDate(Scheduler s) {
        return null;
    }

    @Override
    public YYMMDD getToDate(Scheduler s) {
        return null;
    }

    @Override
    public void setLastFetchDate(Scheduler s, YYMMDD date) {
    }

    @Override
    public void run(EbicsWorker ebicsWorker, Scheduler scheduler) {
        if (HVZPreScheduler.canUseHVZPreScheduler()) {
            DistributedSignature ds = new DistributedSignature(ebicsWorker.getEbicsSession());
            try {
                HVZResponseOrderData response = ds.getDetailedOverview(null);
                File dir = new File(EXPORT_PATH);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String bankName = StringUtils.convertToValidFileName(scheduler.getBank().getDisplayName());
                LocalDateTime now = LocalDateTime.now();
                String name = bankName + "-HVZ-" + now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss")) + ".xml";
                File output = new File(dir, name);
                FileOutputStream fos = new FileOutputStream(output);
                EbicsPrintStream ebicsPrintStream = new EbicsPrintStream(fos);
                ebicsPrintStream.printOut(response);
                fos.close();
                for (HVZOrderDetails details : response.getOrders()) {
                    String dataName = StringUtils.convertToValidFileName(bankName + "-" + details.getOrderTypeOrServiceAsString() + "-" + details.getOrderID().getValue() + "-" + HexTool.toHex(details.getDataDigest().getValue()));
                    File dataFile = new File(dir, dataName);
                    if (dataFile.exists()) continue;
                    FileOutputStream dataFos = new FileOutputStream(dataFile);
                    ds.fetchOrderFile(details, dataFos);
                    dataFos.close();
                }
            }
            catch (EbicsException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

