/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.HTDProcessing;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.transfer.api.AlternativePreScheduler;
import de.businesslogics.banking.transfer.api.PreScheduler;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.banking.transfer.api.RunnableFetchScheduler;
import de.businesslogics.banking.transfer.api.SchedulerProcessing;
import de.businesslogics.banking.transfer.api.UserProcessing;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.h003.FDLOrderParams;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.orders.DateRange;
import de.businesslogics.ebics.schema.orders.HAAResponseOrderData;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.response.AuthorisationFailedException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.InvalidOrderTypeException;
import de.businesslogics.ebics.schema.response.NoDownloadDataAvailableException;
import de.businesslogics.ebics.schema.response.UnsupportedOrderTypeException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.XMLDate;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.task.CronBitSet;
import de.businesslogics.util.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.xml.sax.SAXException;

public class FetchScheduler
implements Callable<List<Fetch>> {
    private static final HashSet<Class<? extends Processing>> PROCESSINGS = new HashSet();
    private static ScheduledThreadPoolExecutor SERVICE = new ScheduledThreadPoolExecutor(Integer.parseInt(System.getProperty("de.businesslogics.banking.transfer.api.FetchScheduler.Threads", "1")));
    private static final HashMap<Integer, ScheduledFuture<List<Fetch>>> MAP = new HashMap();
    private final Scheduler scheduler;
    private final EbicsWorkerFactory worker;

    public static void addPostProcessing(Class<? extends Processing> processingClass) {
        PROCESSINGS.add(processingClass);
    }

    public static java.util.Date nextFetch(int id) {
        ScheduledFuture<List<Fetch>> future = MAP.get(id);
        if (future != null) {
            long delay = future.getDelay(TimeUnit.MILLISECONDS);
            return new java.util.Date(System.currentTimeMillis() + delay + 30000L);
        }
        return null;
    }

    public static void remove(int id) {
        ScheduledFuture<List<Fetch>> future = MAP.remove(id);
        if (future != null) {
            future.cancel(false);
        }
    }

    public static ScheduledFuture<List<Fetch>> fetch(Scheduler scheduler, EbicsWorkerFactory factory) {
        CronBitSet minutes;
        CronBitSet days;
        CronBitSet month = null;
        if (scheduler.getMonth() == null || scheduler.getMonth().isEmpty()) {
            days = new CronBitSet(scheduler.getDays(), 7);
        } else {
            month = new CronBitSet(scheduler.getMonth(), 2);
            days = new CronBitSet(scheduler.getDays(), 5);
        }
        CronBitSet hours = new CronBitSet(scheduler.getHour(), 11);
        if (scheduler.getInterval() != null) {
            minutes = switch (scheduler.getInterval()) {
                default -> throw new MatchException(null, null);
                case Scheduler.Interval.FIFTEEN_MINUTES -> new CronBitSet("0,15,30,45", 12);
                case Scheduler.Interval.FIVE_MINUTES -> new CronBitSet("0,5,10,15,20,25,30,35,40,45,50,55", 12);
                case Scheduler.Interval.HOURLY -> new CronBitSet("0", 12);
                case Scheduler.Interval.NONE -> new CronBitSet(scheduler.getMinute(), 12);
                case Scheduler.Interval.THIRTY_MINUTES -> new CronBitSet("0,30", 12);
            };
        } else {
            minutes = new CronBitSet(scheduler.getMinute(), 12);
        }
        Calendar now = Calendar.getInstance();
        Calendar nextRun = month == null ? CronBitSet.getNextRun(Calendar.getInstance(), days, hours, minutes) : CronBitSet.getNextRun(Calendar.getInstance(), month, days, hours, minutes);
        if (nextRun != null) {
            ScheduledFuture<List<Fetch>> future = SERVICE.schedule(new FetchScheduler(factory, scheduler), nextRun.getTimeInMillis() - now.getTimeInMillis(), TimeUnit.MILLISECONDS);
            ScheduledFuture<List<Fetch>> old = MAP.put(scheduler.getId(), future);
            if (old != null) {
                old.cancel(false);
            }
            return future;
        }
        return null;
    }

    public static ScheduledFuture<List<Fetch>> fetchNow(Scheduler scheduler, EbicsWorker worker) {
        return FetchScheduler.fetchWithDelay(scheduler, bankUser -> worker, 0L, TimeUnit.MILLISECONDS, false);
    }

    public static ScheduledFuture<List<Fetch>> fetchWithDelay(Scheduler scheduler, EbicsWorkerFactory factory, long delay, TimeUnit timeUnit, boolean addToMap) {
        FetchScheduler fs = new FetchScheduler(factory, scheduler);
        ScheduledFuture<List<Fetch>> future = SERVICE.schedule(fs, delay, timeUnit);
        if (addToMap && scheduler.getId() != null) {
            MAP.put(scheduler.getId(), future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fetch fetchFileFromBank(BankUser bankuser, EbicsWorker worker, String orderOrFileType, YYMMDD from, YYMMDD to) throws Exception {
        String suffix;
        String prefix;
        String fileType;
        String orderType;
        RestrictedServiceType serviceType = null;
        BankSettings bank = bankuser.getBank();
        if (BTFTranslator.isBTFString(orderOrFileType)) {
            orderType = "BTD";
            fileType = orderOrFileType;
            serviceType = BTFTranslator.convertFrom(fileType);
            prefix = serviceType.getMsgName().getValue();
            suffix = serviceType.getContainer() != null ? serviceType.getContainer().getContainerType().getValue() : "BTD";
        } else if (orderOrFileType.length() > 3) {
            orderType = "FDL";
            prefix = "FDL";
            suffix = "FDL";
            fileType = orderOrFileType;
        } else if (ProtocolVersion.getInstance(bank.getProtocolVersion()).compareTo(ProtocolVersion.H005) >= 0 && !OrderType.ADMIN30_FETCH_ORDER_TYPES.contains(new OrderType(orderOrFileType))) {
            prefix = orderOrFileType;
            suffix = "BTD";
            fileType = orderOrFileType;
            String tmp = BTFTranslator.getBTFFromFetchOrderType(fileType);
            if (tmp != null) {
                orderType = "BTD";
                serviceType = BTFTranslator.convertFrom(tmp);
            } else {
                orderType = orderOrFileType;
            }
        } else {
            orderType = orderOrFileType;
            prefix = orderOrFileType;
            suffix = orderOrFileType;
            fileType = null;
        }
        File bankFetchedDir = new File(WorkspaceFileSystem.FETCH_DIR, bank.getUniqueKey());
        if (!bankFetchedDir.exists()) {
            bankFetchedDir.mkdirs();
        }
        File tmp = File.createTempFile(prefix + "_", "." + suffix, bankFetchedDir);
        CountingFilterOutputStream fout = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(tmp));
        boolean error = true;
        try {
            StringBuilder nameBuilder;
            if ("FDL".equals(orderType) && fileType != null) {
                Util.logger.logInfo("Starting download for " + fileType + " from " + bank.getDisplayName() + " (" + bank.getBankId() + "), from=" + String.valueOf(from) + " to=" + String.valueOf(to));
                FDLOrderParams params = new FDLOrderParams(new FileFormat(fileType));
                if (from != null) {
                    params.setDateRange(new DateRange(new XMLDate(from), new XMLDate(to)));
                }
                worker.fetchFDL(fout, params);
            } else if (serviceType != null) {
                Util.logger.logInfo("Starting download for " + fileType + " from " + bank.getDisplayName() + " (" + bank.getBankId() + "), from=" + String.valueOf(from) + " to=" + String.valueOf(to));
                worker.fetchFile30(fout, serviceType, from, to);
            } else {
                if (!"HAA".equals(orderType)) {
                    Util.logger.logInfo("Starting download for " + orderType + " from " + bank.getDisplayName() + " (" + bank.getBankId() + "), from=" + String.valueOf(from) + " to=" + String.valueOf(to));
                }
                worker.fetchFile(fout, orderType, from, to);
            }
            fout.close();
            long size = fout.getWritten();
            Util.logger.logInfo("Download done for " + Objects.requireNonNullElse(fileType, orderType) + " from " + bank.getDisplayName() + " (" + bank.getBankId() + ") with " + size + " bytes.");
            error = false;
            Fetch f = new Fetch();
            f.setBank(bank);
            f.setFetched(new Timestamp(System.currentTimeMillis()));
            WorkspaceFile workspaceFile = WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.DATA_FETCHED, tmp, size, null, null);
            f.setFile(workspaceFile);
            f.setFileType(fileType);
            f.setOrderType(orderType);
            if (from != null) {
                f.setFromDate(new Date(from.getTime()));
                f.setToDate(new Date(to.getTime()));
            }
            if ((nameBuilder = new StringBuilder(bankuser.getUser().getName()).append(" (").append(bank.getCustomerId()).append(" / ").append(bankuser.getDefaultUser()).append(')')).length() > 255) {
                nameBuilder.setLength(255);
            }
            f.setFetcher(nameBuilder.toString());
            f.save();
            Fetch fetch = f;
            return fetch;
        }
        finally {
            if (error) {
                fout.close();
                if (tmp.exists()) {
                    SystemUtils.deleteFile(tmp);
                }
            }
        }
    }

    public static void doPostProcessing(Fetch f, Scheduler scheduler, User user) {
        f.setError(null);
        f.save();
        for (Class<? extends Processing> c : PROCESSINGS) {
            try {
                Processing p = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (p instanceof SchedulerProcessing) {
                    ((SchedulerProcessing)p).doPostProcessing(f, scheduler);
                    continue;
                }
                if (p instanceof UserProcessing) {
                    ((UserProcessing)p).doPostProcessing(f, user);
                    continue;
                }
                p.doPostProcessing(f);
            }
            catch (Exception e) {
                Object fetchError = f.getError();
                fetchError = fetchError == null ? e.getMessage() : (String)fetchError + "\n" + e.getMessage();
                f.setError((String)fetchError);
                f.save();
                Util.logger.logWarning("PostProcessing of fetch-id " + f.getId() + " failed for class " + c.getName(), e);
            }
        }
    }

    private FetchScheduler(EbicsWorkerFactory worker, Scheduler scheduler) {
        this.worker = worker;
        this.scheduler = scheduler;
    }

    private List<String> fetchHAA(EbicsWorker worker) throws SAXException, IOException, EbicsException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        worker.fetchFile(bout, "HAA", null, null);
        if (worker.getProtocolVersion().compareTo(ProtocolVersion.H005) >= 0) {
            de.businesslogics.ebics.schema.h005.HAAResponseOrderData haa = new de.businesslogics.ebics.schema.h005.HAAResponseOrderData();
            EbicsRootParser parser = new EbicsRootParser(null, haa);
            EbicsHandler.parse(new ByteArrayInputStream(bout.toByteArray()), parser);
            ArrayList<String> toReturn = new ArrayList<String>();
            for (RestrictedServiceType r : haa.getServices()) {
                toReturn.add(BTFTranslator.convertToString(r));
            }
            return toReturn;
        }
        HAAResponseOrderData haa = new HAAResponseOrderData(worker.getProtocolVersion());
        EbicsRootParser parser = new EbicsRootParser(null, haa);
        EbicsHandler.parse(new ByteArrayInputStream(bout.toByteArray()), parser);
        ArrayList<String> toReturn = new ArrayList<String>();
        for (OrderType o : haa.getOrderTypes()) {
            toReturn.add(o.getValue());
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Fetch> call() {
        ArrayList<Fetch> toReturn = new ArrayList<Fetch>();
        try {
            Scheduler refreshedScheduler;
            YYMMDD toDate;
            YYMMDD from;
            Set<Object> typesToFetch;
            PreScheduler pre;
            EbicsWorker worker;
            block43: {
                if (FetchScheduler.assignActiveBankUser(this.scheduler) == null) {
                    List<BankUser> iniBankUsers = BankUser.findForBankAndStates(this.scheduler.getBank(), new BankUser.UserState[]{BankUser.UserState.CREATED}).stream().filter(u -> !u.isDeactivated()).toList();
                    for (BankUser iniBankUser : iniBankUsers) {
                        try {
                            EbicsWorker worker2 = this.worker.getEbicsWorker(iniBankUser);
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            worker2.fetchFile(bout, "HTD", null, null);
                            if (BankUtils.isCreated(iniBankUser)) {
                                iniBankUser.setState(BankUser.UserState.READY);
                                iniBankUser.save();
                            }
                            HTDProcessing processing = new HTDProcessing();
                            processing.handleHtdFromInputStream(iniBankUser, new ByteArrayInputStream(bout.toByteArray()));
                        }
                        catch (EbicsException | IOException | SAXException e) {
                            continue;
                        }
                        if (FetchScheduler.assignActiveBankUser(this.scheduler) == null) continue;
                        break;
                    }
                }
                if (!BankUtils.isReady(this.scheduler.getBankUser()) && !BankUtils.isCreated(this.scheduler.getBankUser())) {
                    throw new RuntimeException(this.scheduler.getBankUser().getUser().getName() + "(" + this.scheduler.getBankUser().getDefaultUser() + ") state might not be ready or is not created");
                }
                worker = this.worker.getEbicsWorker(this.scheduler.getBankUser());
                pre = null;
                typesToFetch = new HashSet<String>();
                from = null;
                toDate = null;
                Class<?> c = Class.forName(this.scheduler.getOrderOrFileType());
                pre = (PreScheduler)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(pre instanceof RunnableFetchScheduler)) break block43;
                try {
                    this.scheduler.setError(null);
                    ((RunnableFetchScheduler)((Object)pre)).run(worker, this.scheduler);
                }
                catch (Exception e) {
                    this.scheduler.setError(e.getMessage());
                    Util.logger.logError("An error occurred while special scheduler runs from " + this.scheduler.getBankUser().getBank().getDisplayName() + ": " + e.getMessage(), e);
                }
                List<Fetch> e = null;
                return e;
            }
            try {
                typesToFetch = pre.getOrderOrFileTypes(this.scheduler);
                from = pre.getFromDate(this.scheduler);
                toDate = pre.getToDate(this.scheduler);
            }
            catch (Exception e) {
                String[] types;
                for (String t : types = this.scheduler.getOrderOrFileType().split(",")) {
                    typesToFetch.add(t.trim());
                }
            }
            this.scheduler.setError(null);
            if (typesToFetch.size() == 1 && typesToFetch.contains("HAA")) {
                try {
                    typesToFetch.clear();
                    typesToFetch.addAll(this.fetchHAA(worker));
                }
                catch (Exception e) {
                    this.scheduler.setError(e.getMessage());
                    Util.logger.logError("An error occurred while fetching HAA from " + this.scheduler.getBankUser().getBank().getDisplayName() + ": " + e.getMessage(), e);
                }
            } else if (typesToFetch.size() >= 2 && from == null) {
                try {
                    typesToFetch.retainAll(this.fetchHAA(worker));
                }
                catch (Exception e) {
                    this.scheduler.setError(e.getMessage());
                    Util.logger.logError("An error occurred while fetching HAA from " + this.scheduler.getBankUser().getBank().getDisplayName() + ": " + e.getMessage(), e);
                }
            }
            Iterator<Object> e = typesToFetch.iterator();
            while (e.hasNext()) {
                String typeToFetch;
                String orderOrFileType = typeToFetch = (String)e.next();
                YYMMDD today = new YYMMDD();
                if (toDate == null && from != null) {
                    toDate = today;
                }
                try {
                    Fetch f = FetchScheduler.fetchFileFromBank(this.scheduler.getBankUser(), worker, orderOrFileType, from, from == null ? null : toDate);
                    toReturn.add(f);
                    if (pre != null) {
                        pre.setLastFetchDate(this.scheduler, today);
                    }
                    FetchScheduler.doPostProcessing(f, this.scheduler, this.scheduler.getBankUser().getUser());
                    Util.logger.logInfo("Postprocessing done for " + orderOrFileType + " for " + this.scheduler.getBank().getDisplayName() + " (" + this.scheduler.getBank().getBankId() + ").");
                }
                catch (NoDownloadDataAvailableException noData) {
                    Util.logger.logInfo("No data for orderType " + orderOrFileType);
                    this.scheduler.setError(null);
                }
                catch (AuthorisationFailedException | InvalidOrderTypeException | UnsupportedOrderTypeException e2) {
                    Util.logger.logError("Fetching failed for order type '" + orderOrFileType + "' from bank " + this.scheduler.getBank().getDisplayName() + " (" + this.scheduler.getBank().getBankId() + "): " + e2.getMessage());
                    if (pre instanceof AlternativePreScheduler) {
                        AlternativePreScheduler alternativePreScheduler = (AlternativePreScheduler)pre;
                        String alternative = alternativePreScheduler.getAlternativeOrderFileType(this.scheduler, orderOrFileType);
                        if (alternative == null) continue;
                        try {
                            Fetch f = FetchScheduler.fetchFileFromBank(this.scheduler.getBankUser(), worker, alternative, from, from == null ? null : toDate);
                            toReturn.add(f);
                            alternativePreScheduler.saveNewOrderOrFileType(this.scheduler, orderOrFileType, alternative);
                            pre.setLastFetchDate(this.scheduler, today);
                            FetchScheduler.doPostProcessing(f, this.scheduler, this.scheduler.getBankUser().getUser());
                            Util.logger.logInfo("Postprocessing alternative done for " + alternative + "(first try was " + orderOrFileType + ") for " + this.scheduler.getBank().getDisplayName() + " (" + this.scheduler.getBank().getBankId() + ").");
                        }
                        catch (Exception e2Try) {
                            Util.logger.logError("Fetching failed for alternative order type '" + alternative + "'' from bank " + this.scheduler.getBank().getDisplayName() + " (" + this.scheduler.getBank().getBankId() + "): " + e2.getMessage());
                            this.scheduler.setError(e2.getMessage());
                        }
                        continue;
                    }
                    this.scheduler.setError(e2.getMessage());
                }
                catch (EbicsException ebics) {
                    this.scheduler.setError(ebics.getMessage());
                    Util.logger.logError("Fetching failed for order type '" + orderOrFileType + "' from bank " + this.scheduler.getBank().getDisplayName() + " (" + this.scheduler.getBank().getBankId() + "): " + ebics.getMessage());
                }
                catch (Exception e3) {
                    this.scheduler.setError(e3.getMessage());
                    Util.logger.logError("An error occurred while fetching files from " + this.scheduler.getBankUser().getBank().getDisplayName() + ": " + e3.getMessage(), e3);
                }
            }
            if (this.scheduler.getId() != null && (refreshedScheduler = DB.find(Scheduler.class, this.scheduler.getId())) != null) {
                refreshedScheduler.setLastFetch(new Timestamp(System.currentTimeMillis()));
                refreshedScheduler.setError(this.scheduler.getError());
                refreshedScheduler.save();
            }
        }
        finally {
            if (this.scheduler.getId() != null) {
                try {
                    Scheduler refreshedScheduler = DB.find(Scheduler.class, this.scheduler.getId());
                    if (refreshedScheduler != null) {
                        FetchScheduler.fetch(refreshedScheduler, this.worker);
                    }
                }
                catch (Exception e) {
                    Util.logger.logError("Error while restarting a fetchScheduler, restart with old values for id " + this.scheduler.getId());
                    FetchScheduler.fetch(this.scheduler, this.worker);
                }
            }
        }
        return toReturn;
    }

    public static void shutdown(int timeout, TimeUnit unit) throws InterruptedException {
        SERVICE.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        SERVICE.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        SERVICE.shutdown();
        if (timeout > 0 && unit != null) {
            SERVICE.awaitTermination(timeout, unit);
        }
    }

    public static void reset() throws InterruptedException {
        FetchScheduler.shutdown(0, null);
        SERVICE = new ScheduledThreadPoolExecutor(1);
    }

    public static BankUser assignActiveBankUser(Scheduler forScheduler) {
        if (forScheduler.getBankUser() == null) {
            Set<String> typesToFetch = FetchScheduler.getOrderTypes(forScheduler);
            User userToSet = BankUser.findForBankAndStates(forScheduler.getBank(), new BankUser.UserState[]{BankUser.UserState.READY}).stream().filter(u -> !u.isDeactivated()).filter(u -> typesToFetch.stream().map(t -> Util.hasFetchPermission(u, t)).reduce((p1, p2) -> p1 != false && p2 != false).orElse(true)).map(BankUser::getUser).reduce((u1, u2) -> u1.getId() < u2.getId() ? u1 : u2).orElse(null);
            if (userToSet != null) {
                forScheduler.setLoginUser(userToSet);
                forScheduler.save();
            }
        }
        return forScheduler.getBankUser();
    }

    public static Set<String> getOrderTypes(Scheduler scheduler) {
        if (scheduler.getBankUser() == null) {
            return new HashSet<String>();
        }
        try {
            Class<?> c = Class.forName(scheduler.getOrderOrFileType());
            return ((PreScheduler)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getOrderOrFileTypes(scheduler);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return new HashSet<String>(Arrays.asList(scheduler.getOrderOrFileType().split(",")));
        }
    }

    public static QueueStatistics getQueueStatistics() {
        return new QueueStatistics(SERVICE);
    }

    public static interface EbicsWorkerFactory {
        public EbicsWorker getEbicsWorker(BankUser var1);
    }

    public static class QueueStatistics {
        public final int activeCount;
        public final long completedTaskCount;
        public final int corePoolSize;
        public final int largestPoolSize;
        public final int maximumPoolSize;
        public final long poolSize;
        public final long taskCount;

        public QueueStatistics(ScheduledThreadPoolExecutor service) {
            this.activeCount = service.getActiveCount();
            this.completedTaskCount = service.getCompletedTaskCount();
            this.corePoolSize = service.getCorePoolSize();
            this.largestPoolSize = service.getLargestPoolSize();
            this.maximumPoolSize = service.getMaximumPoolSize();
            this.poolSize = service.getPoolSize();
            this.taskCount = service.getTaskCount();
        }

        private QueueStatistics(int activeCount, long completedTaskCount, int corePoolSize, int largestPoolSize, int maximumPoolSize, long poolSize, long taskCount) {
            this.activeCount = activeCount;
            this.completedTaskCount = completedTaskCount;
            this.corePoolSize = corePoolSize;
            this.largestPoolSize = largestPoolSize;
            this.maximumPoolSize = maximumPoolSize;
            this.poolSize = poolSize;
            this.taskCount = taskCount;
        }

        public String toString() {
            return this.activeCount + "|" + this.completedTaskCount + "|" + this.corePoolSize + "|" + this.largestPoolSize + "|" + this.maximumPoolSize + "|" + this.poolSize + "|" + this.taskCount;
        }

        public static QueueStatistics fromString(String s) {
            String[] split = s.split("\\|");
            return new QueueStatistics(Integer.parseInt(split[0]), Long.parseLong(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), Long.parseLong(split[5]), Long.parseLong(split[6]));
        }
    }
}

