/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.FetchParameterUtil;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.NotificationSetting;
import de.businesslogics.util.SystemUtils;
import io.ebean.Transaction;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class FetchDeleteHandler {
    public static void delete(BankSettings bank) {
        File toReturn = FetchDeleteHandler.getBankDir(bank);
        SystemUtils.deleteRecursive(toReturn);
        Fetch.deleteByBank(bank);
    }

    public static File getBankDir(BankSettings b) {
        return new File(WorkspaceFileSystem.FETCH_DIR, b.getUniqueKey());
    }

    public static void delete(List<Fetch> list) {
        try (Transaction t = DB.beginTransaction();){
            for (Fetch f : list) {
                WorkspaceFileSystem.delete(f.getFile());
                DB.delete(Fetch.class, f.getId());
            }
            t.commit();
        }
    }

    public static List<Fetch> findProtocolFilesOlderThan(Date oldest) {
        List list = DB.find(Fetch.class).where().lt("fetched", (Object)oldest).in("orderType", List.of("HAC", "PTK")).findList();
        return list;
    }

    public static int deleteProtocolFilesOlderThan(Date oldest) {
        List list = DB.find(Fetch.class).where().lt("fetched", (Object)oldest).in("orderType", List.of("HAC", "PTK")).findList();
        FetchDeleteHandler.delete(list);
        return list.size();
    }

    private static void add(Set<String> set, FetchParameterUtil.StatementType type, String countryCode) {
        FetchDeleteHandler.add(set, FetchParameterUtil.getDefaultOrderType(type, countryCode));
        FetchDeleteHandler.add(set, FetchParameterUtil.getDefaultBTF(type, countryCode));
    }

    private static void add(Set<String> set, String s) {
        if (s != null && !s.isEmpty()) {
            set.add(s);
        }
    }

    public static List<Fetch> findNotificationFilesOlderThan(Date oldest) {
        ArrayList<Fetch> list = new ArrayList<Fetch>();
        for (BankSettings bank : DB.find(BankSettings.class).findList()) {
            NotificationSetting nf = NotificationSetting.get(bank);
            HashSet<String> fileOrOrderTypes = new HashSet<String>();
            if (nf == null) {
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.camt029Report, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportAXS, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportSCI, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportSCT, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportSDD, bank.getCountryCode());
            } else {
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getCallbackFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getForeignFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getInstantFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getCreditFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getDebitFetchType());
            }
            list.addAll(DB.find(Fetch.class).where().lt("fetched", (Object)oldest).in("orderType", fileOrOrderTypes).findList());
            list.addAll(DB.find(Fetch.class).where().lt("fetched", (Object)oldest).in("fileType", fileOrOrderTypes).findList());
        }
        return list;
    }

    public static int deleteNotificationFilesOlderThan(Date oldest) {
        int total = 0;
        for (BankSettings bank : DB.find(BankSettings.class).findList()) {
            NotificationSetting nf = NotificationSetting.get(bank);
            HashSet<String> fileOrOrderTypes = new HashSet<String>();
            if (nf == null) {
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.camt029Report, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportAXS, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportSCI, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportSCT, bank.getCountryCode());
                FetchDeleteHandler.add(fileOrOrderTypes, FetchParameterUtil.StatementType.pain002ReportSDD, bank.getCountryCode());
            } else {
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getCallbackFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getForeignFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getInstantFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getCreditFetchType());
                FetchDeleteHandler.add(fileOrOrderTypes, nf.getDebitFetchType());
            }
            List list = DB.find(Fetch.class).where().lt("fetched", (Object)oldest).in("orderType", fileOrOrderTypes).findList();
            list.addAll(DB.find(Fetch.class).where().lt("fetched", (Object)oldest).in("fileType", fileOrOrderTypes).findList());
            FetchDeleteHandler.delete(list);
            total += list.size();
        }
        return total;
    }

    public static List<Fetch> findOlderThan(Date oldest) {
        List list = DB.find(Fetch.class).where().lt("fetched", (Object)oldest).findList();
        return list;
    }

    public static int deleteOlderThan(Date oldest) {
        List list = DB.find(Fetch.class).where().lt("fetched", (Object)oldest).findList();
        FetchDeleteHandler.delete(list);
        return list.size();
    }
}

