/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PrintUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;

public abstract class DisplayMessagePrinter {
    private final User user;
    private final Locale locale;
    private final Tenant tenant;

    public DisplayMessagePrinter(User user, Locale locale, Tenant tenant) {
        this.user = user;
        this.locale = locale;
        this.tenant = tenant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File print(File file, String displayMessage) throws IOException, PDFException {
        File pdfFile = Util.createTempFile("OpenReport", ".pdf", true);
        FileOutputStream os = null;
        BLDocument document = null;
        try {
            os = new FileOutputStream(pdfFile);
            document = Util.createBLDocument(os, BLDocument.PageLayout.A4, TransferApiMessages.getString(this.locale, "displaymessageprinter.title", new Object[0]), Util.printLogo(this.user), this.locale);
            document.addTextln(displayMessage, BLFont.COURIER_SMALL);
            DatabasePreferenceStore preferences = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, this.user, this.tenant);
            if (preferences.getBoolean(PreferenceConstants.SEND_REPORT_WITH_DETAILS) && !PrintUtil.isFileTooLargeForDetails(file.length(), document, this.user, this.locale)) {
                this.printPayments(document, file, preferences.getBoolean(PreferenceConstants.SEND_REPORT_DETAILS_WITH_PAGE_BREAK));
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
            SystemUtils.close(os);
        }
        Util.applyPreferencesToPdf(pdfFile, this.user, null, this.locale);
        return pdfFile;
    }

    protected abstract void printPayments(BLDocument var1, File var2, boolean var3) throws IOException, PDFException;
}

