/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.ProtocolSetting;
import de.businesslogics.banking.transfer.api.FetchParameter;
import de.businesslogics.banking.transfer.api.ProtocolFormat;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.Date;
import java.util.List;

public final class CustomerProtocolSettings {
    private final ProtocolSetting setting;
    private List<FetchParameter> otherFetchParameters;

    public static CustomerProtocolSettings byBank(BankSettings bank) {
        return new CustomerProtocolSettings(bank);
    }

    private CustomerProtocolSettings(BankSettings bank) {
        ProtocolSetting protocolSetting = ProtocolSetting.get(bank);
        if (protocolSetting == null) {
            protocolSetting = new ProtocolSetting();
            protocolSetting.setBank(bank);
            protocolSetting.setActive(true);
            if (bank.isFrenchBank()) {
                protocolSetting.setProtocolType(ProtocolSetting.ProtocolType.PSR);
            }
            protocolSetting.save();
        }
        this.setting = protocolSetting;
    }

    public void set(boolean active) {
        this.set(active, null);
    }

    public void set(boolean active, ProtocolFormat f) {
        this.setting.setActive(active);
        if (f != null) {
            switch (f) {
                case HAC: {
                    this.setting.setProtocolType(ProtocolSetting.ProtocolType.HAC);
                    break;
                }
                case PTK: {
                    this.setting.setProtocolType(ProtocolSetting.ProtocolType.PTK);
                    break;
                }
                case PSR: {
                    this.setting.setProtocolType(ProtocolSetting.ProtocolType.PSR);
                }
            }
        }
        this.setting.save();
    }

    public boolean isProtocolActivated() {
        return this.setting.isActive();
    }

    private ProtocolVersion getProtocolVersion() {
        String s = this.setting.getBank().getProtocolVersion();
        if (s != null && s.length() > 0) {
            return ProtocolVersion.getInstance(s);
        }
        return null;
    }

    public ProtocolFormat getProtocolFormat() {
        return switch (this.setting.getProtocolType()) {
            default -> throw new MatchException(null, null);
            case ProtocolSetting.ProtocolType.PTK -> ProtocolFormat.PTK;
            case ProtocolSetting.ProtocolType.HAC -> ProtocolFormat.HAC;
            case ProtocolSetting.ProtocolType.PSR -> ProtocolFormat.PSR;
        };
    }

    public ProtocolFormat getDefaultProtocolFormat() {
        if (this.getProtocolVersion().compareTo(ProtocolVersion.H004) >= 0) {
            return ProtocolFormat.HAC;
        }
        if (this.setting.getBank().isFrenchBank()) {
            return ProtocolFormat.PSR;
        }
        return ProtocolFormat.PTK;
    }

    public CmBank.FetchMode getProtocolFetchMode() {
        return CmBank.FetchMode.DATE;
    }

    public void setProtocolFetchMode(CmBank.FetchMode fetchMode) {
    }

    public ProtocolFormat[] getSupportedProtocolFormats() {
        if (ProtocolVersion.H004.compareTo(this.getProtocolVersion()) <= 0) {
            if (this.setting.getBank().isFrenchBank()) {
                return new ProtocolFormat[]{ProtocolFormat.PSR, ProtocolFormat.PTK, ProtocolFormat.HAC};
            }
            return new ProtocolFormat[]{ProtocolFormat.PTK, ProtocolFormat.PSR, ProtocolFormat.HAC};
        }
        if (this.setting.getBank().isFrenchBank()) {
            return new ProtocolFormat[]{ProtocolFormat.PSR, ProtocolFormat.PTK};
        }
        return new ProtocolFormat[]{ProtocolFormat.PTK, ProtocolFormat.PSR};
    }

    public Date getLastProtocolFetchDate() {
        return this.setting.getLastProtocolFetch();
    }

    public void setLastProtocolFetchDate(Date date) {
        if (date == null && this.setting.getLastProtocolFetch() != null) {
            this.setting.setLastProtocolFetch(null);
            this.setting.save();
        } else if (date != null) {
            this.setting.setLastProtocolFetch(new java.sql.Date(date.getTime()));
            this.setting.save();
        }
    }

    public BankSettings getBank() {
        return this.setting.getBank();
    }
}

