/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.ProtocolListener;
import de.businesslogics.banking.api.ProtocolListenerDS;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.transfer.api.CustomerProtocolSettings;
import de.businesslogics.banking.transfer.api.NotificationUtil;
import de.businesslogics.banking.transfer.api.ProtocolFormat;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.format.ptk2.PTKEntry;
import de.businesslogics.format.ptk2.Result;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class CustomerProtocolProcessing
implements ProtocolListener {
    public static boolean IN_MIGRATION = false;
    private boolean refreshSend = false;

    private Send findClosest(List<Send> l, long compare) {
        long diff = 0L;
        Send found = null;
        for (Send send : l) {
            if (found == null) {
                found = send;
                diff = Math.abs(found.getSent().getTime() - compare);
                continue;
            }
            long diff2 = Math.abs(send.getSent().getTime() - compare);
            if (diff2 >= diff) continue;
            found = send;
            diff = diff2;
        }
        return found;
    }

    @Override
    public void newPTK(BankSettings bank, PTKEntry ptk, PtkEntry vo) {
        if (ptk.getOrderInfo() != null && !ProtocolUtil.isReferentialOrderType(ptk.getOrderInfo().getOrderType())) {
            Send send = this.updateOrderStateByPTK(bank, ptk, vo);
            this.checkForErrorMessage(send, ProtocolFormat.PTK);
        }
        if (ptk.getAction().equals(Action.ADDITIONAL_INFO)) {
            this.checkAdditionalMsg(bank, ptk.toString(), vo, null);
        }
    }

    @Override
    public void newHAC30(BankSettings bank, HAC30Entry hac, HacEntry vo) {
        if (hac.getOrderID() != null) {
            Send send = this.updateOrderStateByHAC(bank, hac, vo);
            this.checkForErrorMessage(send, ProtocolFormat.HAC);
        } else if (hac.getAction() == HAC30Entry.Action.ADDITIONAL) {
            this.checkAdditionalMsg(bank, hac.getAddtlInfs(), null, vo);
        }
    }

    private Send updateOrderStateByHAC(BankSettings bank, HAC30Entry hac, HacEntry vo) {
        List<Send> list;
        String hacOrderNumber = vo.getOrderNumber();
        String hacOrderType = vo.getOrderType();
        String hacFileType = this.checkIfEmpty(vo.getFileType());
        if (hacOrderNumber == null) {
            return null;
        }
        if (hacFileType != null) {
            list = Send.findByFileType(vo.getBank(), hacFileType, hacOrderNumber);
            if (list.size() == 0) {
                list = Send.findByBTFStartsWith(vo.getBank(), hacFileType, hacOrderNumber);
            }
        } else {
            list = Send.find(vo.getBank(), hacOrderType, hacOrderNumber);
        }
        if (list.isEmpty()) {
            Tenant tenant = vo.getBank().getTenant();
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, null, tenant);
            if (preferenceStore.getBoolean(PreferenceConstants.IMPORT_UNKNOWN_SENDITEMS) && preferenceStore.getBoolean(PreferenceConstants.DATABASE_MIGRATION)) {
                this.createDummy(bank, hacOrderType, hacFileType != null ? hacFileType : hac.getFileFormat(), hacOrderNumber, vo.getHacTime());
            }
        } else {
            Send si = this.findClosest(list, vo.getHacTime().getTime());
            if (si != null) {
                Send.State oldState = si.getState();
                ProtocolUtil.updateOrderState(si, hac);
                this.refreshSend = true;
                if (!si.getState().equals((Object)oldState)) {
                    return si;
                }
            }
        }
        return null;
    }

    private String checkIfEmpty(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    protected void createDummy(BankSettings bank, String orderType, String fileType, String orderNumber, Date sent) {
        if (ProtocolListenerDS.isTechnicalOrderType(orderType)) {
            return;
        }
        Send send = new Send();
        send.setBank(bank);
        send.setFileType(fileType);
        send.setOrderNumber(orderNumber);
        send.setOrderType(orderType);
        String transferType = BTFTranslator.isBTFString(fileType) ? fileType : orderType;
        PaymentTransferType.PmtType pmtType = SendParameters.getPmtType(bank, transferType);
        if (pmtType != null) {
            send.setPmtType(pmtType);
        }
        send.setSent(new Timestamp(sent.getTime()));
        send.setState(Send.State.SENT);
        send.save();
    }

    private Send updateOrderStateByPTK(BankSettings bank, PTKEntry entry, PtkEntry vo) {
        String orderType = vo.getOrderType();
        String orderNumber = vo.getOrderNumber();
        if (orderNumber == null || orderType == null) {
            return null;
        }
        List<Send> list = Send.find(vo.getBank(), orderType, orderNumber);
        if (list.isEmpty()) {
            Tenant tenant = vo.getBank().getTenant();
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, null, tenant);
            if (preferenceStore.getBoolean(PreferenceConstants.IMPORT_UNKNOWN_SENDITEMS) && preferenceStore.getBoolean(PreferenceConstants.DATABASE_MIGRATION)) {
                this.createDummy(bank, orderType, null, orderNumber, entry.getDate());
            }
        } else {
            Send si = this.findClosest(list, vo.getPtkTime().getTime());
            if (si != null) {
                Send.State oldState = si.getState();
                this.updateState(si, entry);
                this.refreshSend = true;
                if (!si.getState().equals((Object)oldState)) {
                    return si;
                }
            }
        }
        return null;
    }

    private void updateState(Send si, PTKEntry entry) {
        Result r;
        boolean updateSuccess = si.getState() == null || !si.getState().equals((Object)Send.State.FINISHED_ERROR) && !si.getState().equals((Object)Send.State.FINISHED_OK);
        Action a = entry.getAction();
        if (a.equals(Action.SEND_FILE) || a.equals(Action.SEND_FILE_AND_SIGNATURE)) {
            if (entry.getResult().isSuccess()) {
                if (updateSuccess) {
                    si.setState(Send.State.CONFIRMED);
                }
            } else {
                si.setState(Send.State.FINISHED_ERROR);
            }
        } else if (a.equals(Action.DS_ENTRY)) {
            if (entry.getResult().isSuccess()) {
                if (updateSuccess) {
                    si.setState(Send.State.WAITING_IN_DS);
                }
            } else {
                si.setState(Send.State.FINISHED_ERROR);
            }
        } else if (a.equals(Action.SIGNATURE_CHECK) || a.equals(Action.DISPLAY_CONTENT) || a.equals(Action.DS_FINISH) || a.equals(Action.ACCOUNT_CHECK)) {
            if (entry.getResult().isSuccess()) {
                si.setState(Send.State.FINISHED_OK);
            } else if (entry.getResult() != null && Result.DS_CANCEL_OK.equals(entry.getResult().getResult())) {
                si.setState(Send.State.CANCELED);
            } else if (entry.getResult() != null && Result.SIGFILE_NOT_AVAILABLE.equals(entry.getResult().getResult())) {
                si.setState(Send.State.SIGNATURE_STILL_MISSING);
            } else if (a.equals(Action.DS_FINISH) && entry.getResult().getResult() == null) {
                si.setState(Send.State.FINISHED_OK);
            } else {
                si.setState(Send.State.FINISHED_ERROR);
            }
        } else if (!a.equals(Action.DS_SIGNATURE)) {
            if (a.equals(Action.DS_CANCEL)) {
                si.setState(Send.State.CANCELED);
            } else if (a.equals(Action.ORDER_EXPIRATION)) {
                si.setState(Send.State.FINISHED_ERROR);
            } else if (!a.equals(Action.SEND_SIGNATURE)) {
                if (entry.getOrderInfo() != null) {
                    Util.logger.logError("unknown action <" + String.valueOf(a) + "> found for: " + entry.getOrderInfo().toString(), null);
                } else {
                    Util.logger.logError("unknown action <" + String.valueOf(a) + "> found for entry without orderInfo", null);
                }
            }
        }
        if ((r = entry.getResult().getResult()) != null) {
            si.setErrorCode(String.valueOf(r.getId()));
        }
        si.save();
    }

    @Override
    public void processingDone(BankSettings bank) {
        this.processingDone(this.refreshSend);
        this.refreshSend = false;
    }

    protected void processingDone(boolean refreshSend) {
    }

    private void checkForErrorMessage(Send send, ProtocolFormat protocolFormat) {
        if (send != null && Send.State.FINISHED_ERROR.equals((Object)send.getState())) {
            NotificationUtil.storeErrorNotification(send, protocolFormat);
            this.displayErrorNotification(send, protocolFormat);
        }
    }

    protected void displayErrorNotification(Send send, ProtocolFormat protocolFormat) {
    }

    protected void checkAdditionalMsg(BankSettings bank, String msg, PtkEntry ptk, HacEntry hac) {
        ProtocolFormat protocolFormat = CustomerProtocolSettings.byBank(bank).getProtocolFormat();
        Notification notification = new Notification();
        notification.setBank(bank);
        notification.setOrderType(protocolFormat.name());
        if (ptk != null) {
            notification.setOrderInfo(CustomerProtocolProcessing.buildProtocolFilename(ptk));
            notification.setFetched(ptk.getPtkTime());
            notification.setType(Notification.Type.PTK);
        } else if (hac != null) {
            notification.setOrderInfo(CustomerProtocolProcessing.buildProtocolFilename(hac));
            notification.setFetched(hac.getHacTime());
            notification.setType(Notification.Type.HAC);
        } else {
            notification.setType(Notification.Type.UNKNOWN);
        }
        DB.save(notification);
    }

    public static String buildProtocolFilename(PtkEntry ptk) {
        return "PTK." + ptk.getId();
    }

    public static String buildProtocolFilename(HacEntry hac) {
        return "HAC." + hac.getId();
    }
}

