/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.transfer.api.CustomerProtocolSettings;
import de.businesslogics.banking.transfer.api.PreScheduler;
import de.businesslogics.banking.transfer.api.ProtocolFormat;
import de.businesslogics.bcs.core.YYMMDD;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public final class CustomerProtocolPreScheduler
implements PreScheduler {
    @Override
    public Set<String> getOrderOrFileTypes(Scheduler s) {
        CustomerProtocolSettings settings = CustomerProtocolSettings.byBank(s.getBankUser().getBank());
        return switch (settings.getProtocolFormat()) {
            default -> throw new MatchException(null, null);
            case ProtocolFormat.PTK -> Collections.singleton("PTK");
            case ProtocolFormat.HAC -> Collections.singleton("HAC");
            case ProtocolFormat.PSR -> Collections.singleton("PSR");
        };
    }

    @Override
    public YYMMDD getFromDate(Scheduler s) {
        CustomerProtocolSettings settings = CustomerProtocolSettings.byBank(s.getBankUser().getBank());
        if (CmBank.FetchMode.NEW.equals((Object)settings.getProtocolFetchMode())) {
            return null;
        }
        Date fromDate = settings.getLastProtocolFetchDate();
        if (fromDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            return new YYMMDD(cal.getTimeInMillis());
        }
        return new YYMMDD(fromDate.getTime());
    }

    @Override
    public YYMMDD getToDate(Scheduler s) {
        return null;
    }

    @Override
    public void setLastFetchDate(Scheduler s, YYMMDD date) {
        CustomerProtocolSettings settings = CustomerProtocolSettings.byBank(s.getBankUser().getBank());
        settings.setLastProtocolFetchDate(date);
    }
}

