/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ProtocolListener;
import de.businesslogics.banking.api.ProtocolProcessing;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.transfer.api.CustomerProtocolPreScheduler;
import de.businesslogics.banking.transfer.api.CustomerProtocolProcessing;
import de.businesslogics.banking.transfer.api.CustomerProtocolSettings;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.banking.transfer.api.ProtocolFormat;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CustomerProtocolPostScheduler
implements Processing {
    public static ScheduledFuture<List<Fetch>> fetchProtocolAfterSend(EbicsWorker worker, BankUser bankUser) {
        User u = bankUser.getUser();
        int delay = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, u).getInt(PreferenceConstants.PTK_DELAY);
        if (delay == 0) {
            return null;
        }
        Scheduler s = new Scheduler();
        s.setId(0 - bankUser.getId());
        Date next = FetchScheduler.nextFetch(s.getId());
        int delayInMs = delay * 1000;
        int halfTime = delay * 500;
        if (next == null || next.getTime() - System.currentTimeMillis() < (long)halfTime) {
            s.setBankUser(bankUser);
            s.setOrderOrFileType(CustomerProtocolPreScheduler.class.getName());
            return FetchScheduler.fetchWithDelay(s, bankUser1 -> worker, delayInMs, TimeUnit.MILLISECONDS, true);
        }
        return null;
    }

    public static ScheduledFuture<List<Fetch>> fetchProtocolNow(EbicsWorker worker, BankUser bankUser) {
        Scheduler s = new Scheduler();
        s.setBankUser(bankUser);
        s.setOrderOrFileType(CustomerProtocolPreScheduler.class.getName());
        return FetchScheduler.fetchNow(s, worker);
    }

    @Override
    public void doPostProcessing(Fetch item) throws Exception {
        CustomerProtocolSettings settings = CustomerProtocolSettings.byBank(item.getBank());
        if (item.getOrderType().equals(settings.getProtocolFormat().name())) {
            ProtocolProcessing processing = new ProtocolProcessing(item.getBank(), this.getProtocolListeners());
            try (InputStream in = EncryptData.getInstance().openInputStream(WorkspaceFileSystem.getFile(item.getFile()));){
                if (settings.getProtocolFormat() == ProtocolFormat.HAC) {
                    processing.parseHAC30(in);
                } else if (settings.getProtocolFormat() == ProtocolFormat.PTK) {
                    processing.parsePTK(in);
                } else if (settings.getProtocolFormat() == ProtocolFormat.PSR) {
                    processing.parsePSR(in);
                }
            }
        }
    }

    protected ProtocolListener[] getProtocolListeners() {
        return new ProtocolListener[]{new CustomerProtocolProcessing()};
    }
}

