/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationPmtInf;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.format.camt029.Camt029LogicalFile;
import de.businesslogics.format.camt029.Camt029Notification;
import de.businesslogics.format.camt029.Camt029Transaction;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;

public class Camt029ProcessingApi {
    private static final long ONE_DAY = 86400000L;

    public static void processNotification(Notification notification, Camt029Notification camt029Notification, BLLogger logger) throws Exception {
        String status = camt029Notification.getStatus();
        notification.setGrpSts(status);
        notification.save();
        for (Camt029LogicalFile camt029LogicalFile : camt029Notification.getLogicalFiles()) {
            NotificationPmtInf notificationPmtInf = new NotificationPmtInf();
            notificationPmtInf.setNotification(notification);
            String pmtInfId = camt029LogicalFile.getPmtInfId();
            notificationPmtInf.setOrgnlPmtInfId(pmtInfId);
            notificationPmtInf.setPmtInfSts(status);
            DB.save(notificationPmtInf);
        }
        for (Camt029Transaction camt029Transaction : camt029Notification.getTransactions()) {
            String instructionId;
            NotificationTrx notificationTrx = new NotificationTrx();
            notificationTrx.setNotification(notification);
            String endToEndId = camt029Transaction.getEndToEndId();
            if (endToEndId != null) {
                notificationTrx.setOrgnlEndToEndId(endToEndId);
            }
            if ((instructionId = camt029Transaction.getInstructionId()) != null) {
                notificationTrx.setOrgnlInstrId(instructionId);
            }
            notificationTrx.setTxSts(status);
            DB.save(notificationTrx);
        }
    }

    public static void assignNotification(Notification notification, BLLogger logger) throws Exception {
        String status = notification.getGrpSts();
        Timestamp creationDate = notification.getFetched();
        boolean uniqueCancellationStatus = true;
        String cancellationStatus = null;
        HashSet<SignedPayment> cancelledSignedPayments = new HashSet<SignedPayment>();
        try (Transaction t = DB.beginTransaction();){
            List<NotificationPmtInf> pmtInfs;
            HashSet<Send> sendVOs = new HashSet<Send>();
            List<NotificationTrx> trxs = NotificationTrx.find(notification);
            if (trxs != null && trxs.size() > 0) {
                for (NotificationTrx notificationTrx : trxs) {
                    String endToEndId = notificationTrx.getOrgnlEndToEndId();
                    List<SignedPayment> signedPayments = SignedPayment.findCancelledByEndToEndId(notification.getBank(), endToEndId);
                    if (signedPayments == null || signedPayments.size() <= 0) continue;
                    if (signedPayments.size() != 1) {
                        logger.logWarning("Notification could not be assigned uniquely to one signed payment. Possible candidates with endToEndId = " + endToEndId);
                        for (SignedPayment signedPayment : signedPayments) {
                            logger.logWarning("Signed payment : " + String.valueOf((Object)signedPayment.getPmtType()) + " " + signedPayment.getSend().getOrderNumber() + " " + signedPayment.getPmtInfId());
                        }
                        continue;
                    }
                    SignedPayment signedPayment = signedPayments.get(0);
                    Send send = signedPayment.getSend();
                    sendVOs.add(send);
                    notificationTrx.setSend(send);
                    notificationTrx.setSignedPayment(signedPayment);
                    DB.update(notificationTrx);
                    Notification newestNotification = Notification.findNewestCamt029Notification(signedPayment);
                    if (!creationDate.equals(newestNotification.getFetched())) continue;
                    signedPayment.setCancellationSatus(status);
                    DB.update(signedPayment);
                    if (cancellationStatus == null) {
                        cancellationStatus = status;
                    } else if (!cancellationStatus.equals(status)) {
                        uniqueCancellationStatus = false;
                    }
                    if (!uniqueCancellationStatus) continue;
                    cancelledSignedPayments.add(signedPayment);
                }
            }
            if ((pmtInfs = NotificationPmtInf.find(notification)) != null && pmtInfs.size() > 0) {
                for (NotificationPmtInf pmtInf : pmtInfs) {
                    Send send;
                    String pmtInfId = pmtInf.getOrgnlPmtInfId();
                    List<SignedPayment> signedPayments = SignedPayment.findCancelledByPmtInfId(notification.getBank(), pmtInfId);
                    if (signedPayments == null || signedPayments.size() <= 0) continue;
                    HashSet<Send> sendVOsFromPmtInf = new HashSet<Send>();
                    for (SignedPayment signedPayment : signedPayments) {
                        send = signedPayment.getSend();
                        sendVOsFromPmtInf.add(send);
                    }
                    if (sendVOsFromPmtInf.size() != 1) {
                        logger.logWarning("Notification could not be assigned uniquely to one send order. Possible candidates with pmtInfId = " + pmtInfId);
                        for (Send send2 : sendVOsFromPmtInf) {
                            logger.logWarning("Send order : " + String.valueOf((Object)send2.getPmtType()) + " " + send2.getOrderNumber() + " " + String.valueOf(send2.getSent()));
                        }
                        continue;
                    }
                    for (SignedPayment signedPayment : signedPayments) {
                        send = signedPayment.getSend();
                        sendVOs.add(send);
                        NotificationTrx notificationTrx = new NotificationTrx();
                        notificationTrx.setNotification(notification);
                        notificationTrx.setPmtInf(pmtInf);
                        notificationTrx.setTxSts(status);
                        notificationTrx.setSend(send);
                        notificationTrx.setSignedPayment(signedPayment);
                        notificationTrx.setOrgnlEndToEndId(signedPayment.getReference());
                        DB.save(notificationTrx);
                        Notification newestNotification = Notification.findNewestCamt029Notification(signedPayment);
                        if (!creationDate.equals(newestNotification.getFetched())) continue;
                        signedPayment.setCancellationSatus(status);
                        DB.update(signedPayment);
                        if (cancellationStatus == null) {
                            cancellationStatus = status;
                        } else if (!cancellationStatus.equals(status)) {
                            uniqueCancellationStatus = false;
                        }
                        if (!uniqueCancellationStatus) continue;
                        cancelledSignedPayments.add(signedPayment);
                    }
                }
            }
            if (sendVOs.size() == 1) {
                int countSignedPayments;
                int countCancelledPayments;
                Send send = (Send)sendVOs.iterator().next();
                notification.setSend(send);
                DB.update(notification);
                if (uniqueCancellationStatus && (countCancelledPayments = cancelledSignedPayments.size()) > 0 && countCancelledPayments == (countSignedPayments = SignedPayment.findCountBySend(send))) {
                    send.setCancellationSatus(cancellationStatus);
                    DB.update(send);
                }
            }
            t.commit();
        }
    }

    public static long getClientServerTimeTolerance() {
        return 86400000L;
    }
}

