/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ZipHandler;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.transfer.api.BaseNotificationProcessing;
import de.businesslogics.banking.transfer.api.Camt029ProcessingApi;
import de.businesslogics.banking.transfer.api.TransferApiMessages;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.camt029.Camt029Extractor;
import de.businesslogics.format.camt029.Camt029Notification;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Camt029Processing
extends BaseNotificationProcessing
implements ZipProcessing {
    public Camt029Processing(BLLogger logger, EncryptData encryptData) {
        super(Notification.Type.Camt029, logger, encryptData);
    }

    @Override
    protected void parse(InputStream in) throws Exception {
        ZipHandler zipHandler = new ZipHandler(this, this.logger);
        zipHandler.process(in);
        this.setProcessingResult(zipHandler.getProcessingResult());
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        List<EbicsElement> documents = Camt029Extractor.getDocuments(in);
        for (EbicsElement d : documents) {
            File dataFile = this.createDataFile();
            try (OutputStream out = this.encryptData.openOutputStream(dataFile);){
                EbicsPrintStream eps = new EbicsPrintStream(out);
                Camt029Extractor.addNameSpaceDecl(eps, d);
                eps.printOutPossibleRoot(d);
            }
            this.checkNotification(dataFile, Camt029Extractor.getCreationDate(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Notification saveNotification(File dataFile, Date creationDate, String md5Hash) {
        Notification notification = this.createBaseNotification(dataFile, creationDate, md5Hash);
        InputStream in = null;
        try {
            in = this.encryptData.openInputStream(dataFile);
            Camt029Notification camt029Notification = Camt029Extractor.getNotification(in);
            Camt029ProcessingApi.processNotification(notification, camt029Notification, this.logger);
            Camt029ProcessingApi.assignNotification(notification, this.logger);
        }
        catch (Exception e) {
            Notification notification2;
            try {
                this.logger.logError("Could not save Camt029 notification '" + dataFile.getAbsolutePath() + "'", e);
                notification2 = notification;
            }
            catch (Throwable throwable) {
                SystemUtils.close(in);
                throw throwable;
            }
            SystemUtils.close(in);
            return notification2;
        }
        SystemUtils.close(in);
        return notification;
    }

    @Override
    public String getDescription() {
        return TransferApiMessages.getString(Locale.getDefault(), "Camt029Processing.description", new Object[0]);
    }
}

