/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.transfer.api.NotificationHandler;
import de.businesslogics.format.camt029.Camt029Extractor;
import de.businesslogics.format.camt029.Camt029Notification;
import de.businesslogics.format.sepa.OrderData;
import de.businesslogics.format.sepa.pdf.Camt029ReportGenerator;
import de.businesslogics.pdf.BLDocument;
import java.io.InputStream;
import java.util.Locale;

public class Camt029Printer
implements NotificationHandler {
    private final EncryptData encryptData;
    private Camt029ReportGenerator generator;
    private final Locale locale;

    public Camt029Printer(EncryptData encryptData, Locale locale) {
        this.encryptData = encryptData;
        this.locale = locale;
    }

    @Override
    public void addToDocument(Notification item, BLDocument doc) throws Exception {
        this.generator.addToDocument(item.getBank().getDisplayName(), doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLDocument.PageLayout getPageSize(Notification item) {
        InputStream in = null;
        try {
            in = this.encryptData.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));
            Camt029Notification notification = Camt029Extractor.getNotification(in);
            this.generator = new Camt029ReportGenerator(notification, this.getOrderData(item.getSend()), this.locale);
        }
        catch (Exception exception) {
            Util.closeStream(in);
        }
        catch (Throwable throwable) {
            Util.closeStream(in);
            throw throwable;
        }
        Util.closeStream(in);
        if (this.generator != null) {
            return this.generator.getPageSize();
        }
        return BLDocument.PageLayout.A4;
    }

    private OrderData getOrderData(Send send) {
        if (send != null) {
            boolean isDebitOrder = false;
            PaymentTransferType.PmtType pmtType = send.getPmtType();
            if (pmtType != null) {
                isDebitOrder = PaymentTransferType.FormatType.pain008.equals((Object)pmtType.getFormatType());
            }
            return new OrderData(send.getOriginalSendType(), send.getOrderNumber(), isDebitOrder);
        }
        return null;
    }
}

