/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.transfer.api.NotificationProcessingApi;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class BaseNotificationProcessing
extends NotificationProcessingApi
implements Processing {
    private String orderType;
    protected boolean startedByImport = false;
    private List<Notification> newNotifications;
    private ZipProcessingResult processingResult;
    private String fileType;
    protected String fetchType;

    public ZipProcessingResult getProcessingResult() {
        return this.processingResult;
    }

    public void setProcessingResult(ZipProcessingResult processingResult) {
        this.processingResult = processingResult;
    }

    public BaseNotificationProcessing(Notification.Type type, BLLogger blLogger, EncryptData encryptData) {
        super(type, blLogger, encryptData);
    }

    public void initializeForImport(BankSettings bank) {
        this.setBank(bank);
        this.startedByImport = true;
    }

    @Override
    public void doPostProcessing(Fetch item) throws Exception {
        this.startedByImport = false;
        try (InputStream in = this.encryptData.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));){
            super.setBank(item.getBank());
            this.orderType = item.getOrderType();
            this.fileType = item.getFileType();
            this.fetchType = item.getFetchType();
            this.process(in);
        }
    }

    public void process(InputStream in) throws Exception {
        if (in == null) {
            return;
        }
        this.newNotifications = new ArrayList<Notification>();
        this.parse(in);
    }

    protected abstract void parse(InputStream var1) throws Exception;

    protected void checkNotification(File dataFile, Date creationDate) {
        try {
            InputStream in = this.encryptData.openInputStream(dataFile);
            String hash = SystemUtils.calculateMD5Hash(in);
            in.close();
            if (!Notification.exists(this.bank, hash)) {
                this.newNotifications.add(this.saveNotification(dataFile, creationDate, hash));
            } else {
                dataFile.delete();
            }
        }
        catch (Exception e) {
            this.logger.logError("Could not check notification '" + dataFile.getName() + "'", e);
        }
    }

    protected Notification saveNotification(File dataFile, Date creationDate, String md5Hash) {
        Notification n = this.createBaseNotification(dataFile, creationDate, md5Hash);
        n.save();
        return n;
    }

    protected Notification createBaseNotification(File dataFile, Date creationDate, String md5Hash) {
        return super.createBaseNotification(dataFile, creationDate, md5Hash, this.bank, this.orderType, this.fileType);
    }

    public List<Notification> getNewNotifications() {
        return this.newNotifications;
    }

    public abstract String getDescription();
}

