/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.BankDeleteNotifier;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationSetting;
import de.businesslogics.banking.database.vo.ProtocolSetting;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.transfer.api.FetchDeleteHandler;
import de.businesslogics.banking.transfer.api.NotificationDeleteHandler;
import de.businesslogics.banking.transfer.api.SendOrderHandler;
import de.businesslogics.banking.transfer.gui.Messages;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;

public class BankDelete
implements BankDeleteNotifier {
    @Override
    public String[] checkDataToBeDeleted(BankSettings bank, Locale locale) {
        int notification;
        int fetch;
        int send = Send.countByBank(bank);
        ArrayList<String> toReturn = new ArrayList<String>();
        if (send > 0) {
            toReturn.add(MessageFormat.format(Messages.getString(locale, "BankDelete.sentFiles", new Object[0]), send));
        }
        if ((fetch = Fetch.countByBank(bank)) > 0) {
            toReturn.add(MessageFormat.format(Messages.getString(locale, "BankDelete.fetchedFiles", new Object[0]), fetch));
        }
        if ((notification = Notification.countByBank(bank)) > 0) {
            toReturn.add(MessageFormat.format(Messages.getString(locale, "BankDelete.notificationFiles", new Object[0]), notification));
        }
        if (toReturn.isEmpty()) {
            return null;
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }

    @Override
    public String[] checkDataToBeDeleted(BankSettings[] banks, Locale locale) {
        int send = 0;
        int fetched = 0;
        int notification = 0;
        for (int i = 0; i < banks.length; ++i) {
            send += Send.countByBank(banks[i]);
            fetched += Fetch.countByBank(banks[i]);
            notification += Notification.countByBank(banks[i]);
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        if (send > 0) {
            toReturn.add(MessageFormat.format(Messages.getString(locale, "BankDelete.sentFiles", new Object[0]), send));
        }
        if (fetched > 0) {
            toReturn.add(MessageFormat.format(Messages.getString(locale, "BankDelete.fetchedFiles", new Object[0]), fetched));
        }
        if (notification > 0) {
            toReturn.add(MessageFormat.format(Messages.getString(locale, "BankDelete.notificationFiles", new Object[0]), notification));
        }
        if (toReturn.isEmpty()) {
            return null;
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }

    @Override
    public void deleteBank(BankSettings bank, IProgressMonitorWrapper monitor) {
        monitor.beginTask("", 7);
        FetchDeleteHandler.delete(bank);
        monitor.worked(1);
        NotificationDeleteHandler.delete(bank);
        monitor.worked(1);
        SendOrderHandler.delete(bank);
        monitor.worked(1);
        ProtocolSetting.deleteByBank(bank);
        monitor.worked(1);
        SendFilter.deleteByBank(bank);
        monitor.worked(1);
        DirectoryScanner.deleteByBank(bank);
        monitor.worked(1);
        NotificationSetting.deleteByBank(bank);
        monitor.done();
        WorkspaceFile.deleteByBankAndType(WorkspaceFile.Prefix.DATA_FETCHED, bank);
        WorkspaceFile.deleteByBankAndType(WorkspaceFile.Prefix.DATA_SENT, bank);
        WorkspaceFile.deleteByBankAndType(WorkspaceFile.Prefix.NOTIFICATIONS, bank);
    }
}

