/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.transfer.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.api.acmt.Acmt011Processing;
import de.businesslogics.banking.api.acmt.Acmt014Processing;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.format.acmt.AccountLimitRejectionInfo;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import io.ebean.Transaction;
import java.io.InputStream;
import java.util.Locale;

public class AcmtPostProcessingAPI
implements Processing {
    private final BLLogger logger;
    private final Locale locale;
    protected final EncryptData encryptData;

    public AcmtPostProcessingAPI(BLLogger logger, Locale locale, EncryptData encryptData) {
        this.logger = logger;
        this.locale = locale;
        this.encryptData = encryptData;
    }

    @Override
    public void doPostProcessing(Fetch item) throws Exception {
        if (item == null) {
            return;
        }
        String fetchType = item.getFetchType();
        if (fetchType == null) {
            return;
        }
        if (fetchType.equals(BTFTranslator.getBTFFromFetchOrderType("B14")) || fetchType.equals("B14")) {
            ZipProcessingResult zipProcessingResult = null;
            try (Transaction t = DB.beginTransaction();){
                Acmt014Processing processing = new Acmt014Processing(this.logger, item.getBank());
                InputStream in = this.encryptData.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));
                processing.process(in);
                zipProcessingResult = processing.getProcessingResult();
                SystemUtils.close(in);
                t.commit();
            }
            if (zipProcessingResult != null && zipProcessingResult.hasErrors()) {
                zipProcessingResult.evaluateResult(this.logger, this.locale);
            }
        } else if (fetchType.equals(BTFTranslator.getBTFFromFetchOrderType("B11")) || fetchType.equals("B11")) {
            ZipProcessingResult zipProcessingResult = null;
            try (Transaction t = DB.beginTransaction();){
                Acmt011Processing processing = new Acmt011Processing(this.logger, item.getBank());
                InputStream in = this.encryptData.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));
                processing.process(in);
                zipProcessingResult = processing.getProcessingResult();
                this.furtherB11Processing(processing.getAccountLimitRejectionInfo(), item.getBank());
                SystemUtils.close(in);
                t.commit();
            }
            if (zipProcessingResult != null && zipProcessingResult.hasErrors()) {
                zipProcessingResult.evaluateResult(this.logger, Locale.getDefault());
            }
        }
    }

    protected void furtherB11Processing(AccountLimitRejectionInfo accountLimitRejectionInfo, BankSettings bank) {
    }
}

