/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.tools;

import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.api.AbstractUserImportRunner;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.DatabaseUpdateRunner;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.api.JdbcSettings;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.HistoryLog;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.tools.ConsoleLogger;
import de.businesslogics.banking.tools.DatabaseConnection;
import de.businesslogics.banking.tools.LicenseHandler;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.StringUtils;
import io.ebean.Database;
import io.ebean.Expr;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class WorkspaceImport
implements Runnable {
    private final File sourceWorkspaceDir;
    private final File targetWorkspaceDir;
    private final String sourceTenantName;
    private final String targetTenantName;
    private final boolean withoutAccounts;
    private final boolean withoutRecipients;
    private final boolean withoutPayments;
    private Database sourceServer;
    private Tenant sourceTenant;
    private Tenant targetTenant;

    private WorkspaceImport(File sourceWorkspaceDir, File targetWorkspaceDir, String sourceTenantName, String targetTenantName, boolean withoutAccounts, boolean withoutRecipients, boolean withoutPayments) {
        this.sourceWorkspaceDir = sourceWorkspaceDir;
        this.targetWorkspaceDir = targetWorkspaceDir;
        this.sourceTenantName = sourceTenantName;
        this.targetTenantName = targetTenantName;
        this.withoutAccounts = withoutAccounts;
        this.withoutRecipients = withoutRecipients;
        this.withoutPayments = withoutPayments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.withoutAccounts && !this.withoutPayments) {
            ConsoleLogger.getInstance().logError("To import the payments, the accounts need to be imported, too!");
            return;
        }
        Util.initialize(this.targetWorkspaceDir, ConsoleLogger.getInstance());
        try {
            DatabaseConnection targetConnection = new DatabaseConnection(this.targetWorkspaceDir);
            targetConnection.doUpdates(new DatabaseUpdateRunner(ConsoleLogger.getInstance(), this.targetWorkspaceDir));
            for (Tenant tenant : Tenant.getAllTenants()) {
                if (!this.targetTenantName.equals(tenant.getName())) continue;
                this.targetTenant = tenant;
                break;
            }
            if (this.targetTenant == null) {
                ConsoleLogger.getInstance().logError("Unknown target tenant: " + this.targetTenantName);
                return;
            }
            JdbcSettings sourceJdbcSettings = new JdbcSettings(this.sourceWorkspaceDir);
            this.sourceServer = DatabaseConnection.createNewEbeanServer(sourceJdbcSettings);
            DatabaseUpdateRunner runner = new DatabaseUpdateRunner(ConsoleLogger.getInstance(), this.sourceWorkspaceDir);
            DBType dbType = runner.checkDatabaseConnection(this.sourceServer, null, sourceJdbcSettings.getSchema());
            DatabaseConnection.getInstance().setDbType(dbType);
            LinkedHashMap<Integer, String> updateMap = runner.findDatabaseUpdateScripts(this.sourceServer, dbType);
            for (Integer version : updateMap.keySet()) {
                runner.executeUpdate(this.sourceServer, dbType, sourceJdbcSettings.getSchema(), (String)updateMap.get(version), version);
            }
            for (Tenant tenant : this.sourceServer.find(Tenant.class).findList()) {
                if (!this.sourceTenantName.equals(tenant.getName())) continue;
                this.sourceTenant = tenant;
                break;
            }
            if (this.sourceTenant == null) {
                ConsoleLogger.getInstance().logError("Unknown source tenant: " + this.sourceTenantName);
                return;
            }
            Map<BankUser, BankUser> bankUserMap = this.importUsers();
            if (bankUserMap == null || bankUserMap.isEmpty()) {
                ConsoleLogger.getInstance().logError("No users imported!");
                return;
            }
            try (Transaction t = DB.beginTransaction();){
                Map<Account, Account> importedAccountsMap;
                if (!this.withoutAccounts) {
                    HashMap<BankSettings, BankSettings> banksMap = new HashMap<BankSettings, BankSettings>();
                    for (BankUser sourceBankUser : bankUserMap.keySet()) {
                        banksMap.put(sourceBankUser.getBank(), bankUserMap.get(sourceBankUser).getBank());
                    }
                    importedAccountsMap = this.importAccounts(banksMap);
                } else {
                    importedAccountsMap = null;
                }
                if (!this.withoutRecipients) {
                    User user = bankUserMap.values().iterator().next().getUser();
                    this.importOriginatorsAndRecipients(user);
                }
                if (!this.withoutPayments && importedAccountsMap != null) {
                    this.importPayments(importedAccountsMap);
                }
                t.commit();
            }
        }
        catch (Throwable e) {
            ConsoleLogger.getInstance().logError("Migration failed!", e);
        }
        finally {
            DatabaseConnection.shutdown();
            if (this.sourceServer != null) {
                this.sourceServer.shutdown(true, false);
            }
        }
    }

    private Map<BankUser, BankUser> importUsers() {
        AbstractUserImportRunner runner = new AbstractUserImportRunner(this.sourceWorkspaceDir, null, this.sourceServer.find(User.class).findList()){
            private Map<User, File> sourceUserKeyDirs;
            private Map<User, File> targetUserKeyDirs;

            @Override
            protected void handleThrowable(Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }

            @Override
            protected List<Tenant> getImportingUserTenants() {
                ArrayList<Tenant> result = new ArrayList<Tenant>();
                result.add(WorkspaceImport.this.sourceTenant);
                return result;
            }

            @Override
            protected List<Tenant> findCorrespondingTenants(List<Tenant> tenants) {
                List<Tenant> result = super.findCorrespondingTenants(tenants);
                if (!WorkspaceImport.this.sourceTenant.getName().equals(WorkspaceImport.this.targetTenant.getName())) {
                    Iterator<Tenant> iterator = result.iterator();
                    while (iterator.hasNext()) {
                        Tenant t = iterator.next();
                        if (!t.getName().equals(WorkspaceImport.this.sourceTenant.getName())) continue;
                        iterator.remove();
                        break;
                    }
                    result.add(WorkspaceImport.this.targetTenant);
                }
                return result;
            }

            @Override
            protected boolean askUserOverwrite(String userName) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected File getSourceKeyDirectory(User sourceUser) {
                if (this.sourceUserKeyDirs != null && this.sourceUserKeyDirs.containsKey(sourceUser)) {
                    return this.sourceUserKeyDirs.get(sourceUser);
                }
                File result = super.getSourceKeyDirectory(sourceUser);
                if (result != null && result.exists() && !result.isDirectory()) {
                    System.out.println("Did not find key directory for user " + sourceUser.getName() + ", please enter the correct path [empty to ignore user keys]:");
                    try (Scanner scanner = new Scanner(System.in);){
                        String input;
                        while ((result = (input = scanner.nextLine()) == null || input.isEmpty() ? null : new File(input)) != null && !result.isDirectory()) {
                        }
                    }
                }
                if (this.sourceUserKeyDirs == null) {
                    this.sourceUserKeyDirs = new HashMap<User, File>();
                }
                this.sourceUserKeyDirs.put(sourceUser, result);
                return result;
            }

            @Override
            protected File getTargetKeyDirectory(User user, boolean createDir, File applicationKeyDir) throws IOException {
                if (this.targetUserKeyDirs != null && this.targetUserKeyDirs.containsKey(user)) {
                    return this.targetUserKeyDirs.get(user);
                }
                if (user.getKeyDirectory() != null && !Util.getKeyDirectory(user).getAbsolutePath().startsWith(WorkspaceImport.this.targetWorkspaceDir.getAbsolutePath())) {
                    user.setKeyDirectory(null);
                }
                user.setKeyDirectory(WorkspaceImport.this.buildKeyDirForUser(user));
                File result = new File(WorkspaceImport.this.targetWorkspaceDir, user.getKeyDirectory());
                if (createDir) {
                    result.mkdirs();
                }
                if (this.targetUserKeyDirs == null) {
                    this.targetUserKeyDirs = new HashMap<User, File>();
                }
                this.targetUserKeyDirs.put(user, result);
                return result;
            }
        };
        runner.setSource(this.sourceServer);
        LicenseHandler licenseHandler = new LicenseHandler(ConsoleLogger.getInstance(), true);
        License webLicense = null;
        for (User u : User.getAll()) {
            if (!u.getTenants().contains(this.targetTenant) || u.getWebLicense() == null || licenseHandler.checkLicense(u) != AbstractLicenseHandler.LicenseCheckResult.OK) continue;
            try {
                int n;
                String numberString = licenseHandler.getLicenceProperties(u.getWebLicense()).getProperty("NUMBER_OF_USERS");
                if (numberString == null || !runner.setRemainingUserNumber(n = Integer.valueOf(numberString) - DB.find(User.class).where().eq("webLicense", (Object)u.getWebLicense()).eq("securityMedium", (Object)User.SecurityMedium.DUMMY).findCount())) continue;
                webLicense = u.getWebLicense();
            }
            catch (IOException | NumberFormatException e) {
                ConsoleLogger.getInstance().logWarning("Failed to detect remaining users for license " + u.getWebLicense().getId(), e);
            }
        }
        if (webLicense != null) {
            ConsoleLogger.getInstance().logInfo("Using license " + webLicense.getId());
        }
        runner.run();
        HashSet<User> migratedUsers = new HashSet<User>();
        for (BankUser sourceBankUser : runner.getImportedBankUsers().keySet()) {
            if (migratedUsers.contains(sourceBankUser.getUser())) continue;
            migratedUsers.add(sourceBankUser.getUser());
            BankUser targetBankUser = runner.getImportedBankUsers().get(sourceBankUser);
            if (targetBankUser.getUser().getWebLicense() == null && webLicense != null) {
                targetBankUser.getUser().setWebLicense(webLicense);
                targetBankUser.getUser().save();
            }
            for (Preference preference : this.sourceServer.find(Preference.class).where().eq("user", (Object)sourceBankUser.getUser()).findList()) {
                Preference targetPreference = new Preference();
                targetPreference.setUser(targetBankUser.getUser());
                targetPreference.setApplicationId(preference.getApplicationId());
                targetPreference.setKey(preference.getKey());
                targetPreference.setValue(preference.getValue());
                targetPreference.save();
            }
            for (Yubikey yubikey : this.sourceServer.find(Yubikey.class).where().eq("user", (Object)sourceBankUser.getUser()).findList()) {
                Yubikey targetYubikey = new Yubikey();
                targetYubikey.setUser(targetBankUser.getUser());
                targetYubikey.setPublicId(yubikey.getPublicId());
                targetYubikey.setUsedSince(yubikey.getUsedSince());
                targetYubikey.save();
            }
        }
        return runner.getImportedBankUsers();
    }

    private Map<Account, Account> importAccounts(Map<BankSettings, BankSettings> banksMap) {
        HashMap<Account, Account> result = new HashMap<Account, Account>();
        for (BankSettings sourceBank : banksMap.keySet()) {
            BankSettings targetBank = banksMap.get(sourceBank);
            List<Account> targetBankAccounts = Account.findAccountsForBank(targetBank);
            for (Account sourceAccount : this.sourceServer.find(Account.class).where().eq("bank", (Object)sourceBank).findList()) {
                Account targetAccount = this.findAccount(targetBankAccounts, sourceAccount);
                if (targetAccount == null) {
                    targetAccount = new Account();
                    targetAccount.setBank(targetBank);
                    targetBankAccounts.add(targetAccount);
                    targetAccount.setName(sourceAccount.getName());
                } else if (!Account.getDefaultDisplayName(targetAccount).equals(sourceAccount.getName())) {
                    targetAccount.setName(sourceAccount.getName());
                }
                targetAccount.setDescription(sourceAccount.getDescription());
                targetAccount.setAccountHolder(sourceAccount.getAccountHolder());
                targetAccount.setAccountHolderHTD(sourceAccount.getAccountHolderHTD());
                targetAccount.setGermanBankCode(sourceAccount.getGermanBankCode());
                targetAccount.setGermanAccountNumber(sourceAccount.getGermanAccountNumber());
                targetAccount.setFrenchBankCode(sourceAccount.getFrenchBankCode());
                targetAccount.setFrenchBranchCode(sourceAccount.getFrenchBranchCode());
                targetAccount.setFrenchAccountNumber(sourceAccount.getFrenchAccountNumber());
                targetAccount.setFrenchCheckCode(sourceAccount.getFrenchCheckCode());
                targetAccount.setIban(sourceAccount.getIban());
                targetAccount.setBic(sourceAccount.getBic());
                targetAccount.setNationalAccountNumber(sourceAccount.getNationalAccountNumber());
                targetAccount.setNationalBankCode(sourceAccount.getNationalBankCode());
                targetAccount.setCurrency(sourceAccount.getCurrency());
                targetAccount.setCmIdentification(sourceAccount.getCmIdentification());
                targetAccount.setCreditLimit(sourceAccount.getCreditLimit());
                targetAccount.setInvestmentAmount(sourceAccount.getInvestmentAmount());
                targetAccount.setInfoText(sourceAccount.getInfoText());
                targetAccount.setType(sourceAccount.getType());
                targetAccount.setUseVirtualBalances(sourceAccount.getUseVirtualBalances());
                targetAccount.setVirtualStartBalance(sourceAccount.getVirtualStartBalance());
                targetAccount.setVirtualStartDate(sourceAccount.getVirtualStartDate());
                targetAccount.setIgnoreAccountInformation(sourceAccount.getIgnoreAccountInformation());
                targetAccount.save();
                result.put(sourceAccount, targetAccount);
            }
        }
        return result;
    }

    private String buildKeyDirForUser(User user) {
        File file;
        String normalized = Normalizer.normalize(user.getName(), Normalizer.Form.NFD).replaceAll("[^A-Za-z0-9 ]", "");
        if (normalized.length() == 0) {
            normalized = String.valueOf(user.getId());
        }
        String dir = "./keys/" + normalized;
        int counter = 1;
        do {
            if (!(file = new File(this.targetWorkspaceDir, dir)).isDirectory()) continue;
            dir = "./keys/" + normalized + "." + counter++;
        } while (file.isDirectory());
        return dir;
    }

    private Account findAccount(List<Account> allTargetAccountsList, Account sourceAccount) {
        for (Account account : allTargetAccountsList) {
            if (!StringUtils.valuesDiffer(sourceAccount.getIban(), account.getIban()) || !StringUtils.valuesDiffer(sourceAccount.getBic(), account.getBic()) || !StringUtils.valuesDiffer(sourceAccount.getGermanAccountNumber(), account.getGermanAccountNumber()) || !StringUtils.valuesDiffer(sourceAccount.getGermanBankCode(), account.getGermanBankCode()) || !StringUtils.valuesDiffer(sourceAccount.getNationalAccountNumber(), account.getNationalAccountNumber()) || !StringUtils.valuesDiffer(sourceAccount.getNationalBankCode(), account.getNationalBankCode()) || !StringUtils.valuesDiffer(sourceAccount.getCurrency(), account.getCurrency())) continue;
            return account;
        }
        if (sourceAccount.getIban() != null) {
            ArrayList<Account> targetIbanAccountsList = new ArrayList<Account>();
            for (Account account : allTargetAccountsList) {
                if (!sourceAccount.getIban().equals(account.getIban()) || !StringUtils.valuesDiffer(sourceAccount.getCurrency(), account.getCurrency())) continue;
                targetIbanAccountsList.add(account);
            }
            if (targetIbanAccountsList.size() == 1) {
                return (Account)targetIbanAccountsList.get(0);
            }
            if (sourceAccount.getBic() != null && targetIbanAccountsList.size() > 1) {
                ArrayList<Account> arrayList = new ArrayList<Account>();
                for (Account targetAccount : targetIbanAccountsList) {
                    if (!sourceAccount.getBic().equals(targetAccount.getBic())) continue;
                    arrayList.add(targetAccount);
                }
                if (arrayList.size() == 0) {
                    for (Account targetAccount : targetIbanAccountsList) {
                        if (targetAccount.getBic() != null) continue;
                        return targetAccount;
                    }
                } else {
                    return (Account)arrayList.get(0);
                }
            }
        }
        if (sourceAccount.getGermanBankCode() != null && sourceAccount.getGermanAccountNumber() != null) {
            String normalizedAccountNumber = StringUtils.fillUpFromLeft(sourceAccount.getGermanAccountNumber(), '0', 10);
            for (Account account : allTargetAccountsList) {
                if (account.getGermanAccountNumber() == null || !normalizedAccountNumber.equals(StringUtils.fillUpFromLeft(account.getGermanAccountNumber(), '0', 10)) || !sourceAccount.getGermanBankCode().equals(account.getGermanBankCode()) || account.getCurrency() == null || !sourceAccount.getCurrency().equals(account.getCurrency())) continue;
                return account;
            }
        }
        if (sourceAccount.getFrenchBankCode() != null && sourceAccount.getFrenchBranchCode() != null && sourceAccount.getFrenchAccountNumber() != null) {
            for (Account account : allTargetAccountsList) {
                if (account.getFrenchAccountNumber() == null || !account.getFrenchAccountNumber().equals(sourceAccount.getFrenchAccountNumber()) || !sourceAccount.getFrenchBankCode().equals(account.getFrenchBankCode()) || !sourceAccount.getFrenchBranchCode().equals(account.getFrenchBranchCode())) continue;
                return account;
            }
        }
        if (sourceAccount.getNationalAccountNumber() != null) {
            ArrayList<Account> targetNationalAccountsList = new ArrayList<Account>();
            for (Account account : allTargetAccountsList) {
                if (!sourceAccount.getNationalAccountNumber().equals(account.getNationalAccountNumber()) || !sourceAccount.getCurrency().equals(account.getCurrency())) continue;
                targetNationalAccountsList.add(account);
            }
            if (targetNationalAccountsList.size() == 1) {
                return (Account)targetNationalAccountsList.get(0);
            }
            if (targetNationalAccountsList.size() > 1) {
                for (Account account : targetNationalAccountsList) {
                    if (!StringUtils.valuesDiffer(sourceAccount.getNationalBankCode(), account.getNationalBankCode())) continue;
                    return account;
                }
                for (Account account : targetNationalAccountsList) {
                    if (!StringUtils.valuesDiffer(sourceAccount.getBic(), account.getBic())) continue;
                    return account;
                }
            }
        }
        return null;
    }

    private void importOriginatorsAndRecipients(User user) {
        for (PaymentOriginator sourcePaymentOriginator : this.sourceServer.find(PaymentOriginator.class).where().eq("tenant", (Object)this.sourceTenant).findList()) {
            PaymentOriginator targetPaymentOriginator = PaymentOriginator.findOriginatorByName(sourcePaymentOriginator.getPaymentType(), sourcePaymentOriginator.getName(), this.targetTenant);
            if (targetPaymentOriginator != null) continue;
            targetPaymentOriginator = new PaymentOriginator();
            targetPaymentOriginator.setTenant(this.targetTenant);
            targetPaymentOriginator.setPaymentType(sourcePaymentOriginator.getPaymentType());
            targetPaymentOriginator.setName(sourcePaymentOriginator.getName());
            targetPaymentOriginator.setOriginatorInfo(sourcePaymentOriginator.getOriginatorInfo());
            targetPaymentOriginator.save();
        }
        for (PaymentRecipient sourcePaymentRecipient : this.sourceServer.find(PaymentRecipient.class).where().eq("tenant", (Object)this.sourceTenant).findList()) {
            PaymentRecipient targetPaymentRecipient = (PaymentRecipient)DB.find(PaymentRecipient.class).where().eq("tenant", (Object)this.targetTenant).eq("paymentType", (Object)sourcePaymentRecipient.getPaymentType()).eq("accountNumber", (Object)sourcePaymentRecipient.getAccountNumber()).or(Expr.isNull((String)"bankCode"), Expr.eq((String)"bankCode", (Object)sourcePaymentRecipient.getBankCode())).setMaxRows(1).findOne();
            if (targetPaymentRecipient == null) {
                targetPaymentRecipient = new PaymentRecipient();
                targetPaymentRecipient.setTenant(this.targetTenant);
                targetPaymentRecipient.setPaymentType(sourcePaymentRecipient.getPaymentType());
                targetPaymentRecipient.setDisplayName(sourcePaymentRecipient.getDisplayName());
                int counter = 0;
                while (PaymentRecipient.findNonHistoricRecipientByDisplayName(sourcePaymentRecipient.getPaymentType(), targetPaymentRecipient.getDisplayName(), this.targetTenant) != null) {
                    targetPaymentRecipient.setDisplayName(sourcePaymentRecipient.getDisplayName() + "." + ++counter);
                }
                targetPaymentRecipient.setName(sourcePaymentRecipient.getName());
                targetPaymentRecipient.setAccountNumber(sourcePaymentRecipient.getAccountNumber());
                targetPaymentRecipient.setBankCode(sourcePaymentRecipient.getBankCode());
                targetPaymentRecipient.setBankName(sourcePaymentRecipient.getBankName());
                targetPaymentRecipient.setPurpose(sourcePaymentRecipient.getPurpose());
                targetPaymentRecipient.setSepaMandateId(sourcePaymentRecipient.getSepaMandateId());
                targetPaymentRecipient.setRecipientInfo(sourcePaymentRecipient.getRecipientInfo());
                targetPaymentRecipient.save(user, false);
                continue;
            }
            if (targetPaymentRecipient.getBankCode() != null || sourcePaymentRecipient.getBankCode() == null) continue;
            targetPaymentRecipient.setBankCode(sourcePaymentRecipient.getBankCode());
            targetPaymentRecipient.save(user, false);
        }
    }

    private void importPayments(Map<Account, Account> importedAccountsMap) {
        User createdUser;
        Account targetAccount;
        HashMap importedPaymentFolder = new HashMap();
        for (PaymentFolder sourcePaymentFolder : this.sourceServer.find(PaymentFolder.class).where().eq("tenant", (Object)this.sourceTenant).findList()) {
            PaymentFolder targetPaymentFolder = PaymentFolder.findByName(sourcePaymentFolder.getName(), this.targetTenant);
            if (targetPaymentFolder != null) continue;
            targetPaymentFolder = new PaymentFolder();
            targetPaymentFolder.setName(sourcePaymentFolder.getName());
            targetPaymentFolder.setTenant(this.targetTenant);
            DB.save(targetPaymentFolder);
        }
        for (Object sourceOpenPayment : this.sourceServer.find(OpenPayment.class).where().eq("bank.tenant", (Object)this.sourceTenant).findList()) {
            targetAccount = importedAccountsMap.get(((OpenPayment)sourceOpenPayment).getAccount());
            if (targetAccount == null) continue;
            OpenPayment targetOpenPayment = new OpenPayment();
            targetOpenPayment.setBank(targetAccount.getBank());
            targetOpenPayment.setAccount(targetAccount);
            targetOpenPayment.setPmtType(((OpenPayment)sourceOpenPayment).getPmtType());
            targetOpenPayment.setOrderType(((OpenPayment)sourceOpenPayment).getOrderType());
            targetOpenPayment.setFileType(((OpenPayment)sourceOpenPayment).getFileType());
            targetOpenPayment.setCredit(((OpenPayment)sourceOpenPayment).isCredit());
            targetOpenPayment.setUrgent(((OpenPayment)sourceOpenPayment).isUrgent());
            targetOpenPayment.setRecipient(((OpenPayment)sourceOpenPayment).getRecipient());
            targetOpenPayment.setAmount(((OpenPayment)sourceOpenPayment).getAmount());
            targetOpenPayment.setAmountCurrency(((OpenPayment)sourceOpenPayment).getAmountCurrency());
            targetOpenPayment.setPurpose(((OpenPayment)sourceOpenPayment).getPurpose());
            targetOpenPayment.setExecutionDate(((OpenPayment)sourceOpenPayment).getExecutionDate());
            targetOpenPayment.setPaymentData(((OpenPayment)sourceOpenPayment).getPaymentData());
            targetOpenPayment.setFolder((PaymentFolder)importedPaymentFolder.get(((OpenPayment)sourceOpenPayment).getFolder()));
            targetOpenPayment.setSalaryPayment(((OpenPayment)sourceOpenPayment).getSalaryPayment());
            createdUser = ((HistoryLog)sourceOpenPayment).getCreatedUser() != null ? User.getUser(((HistoryLog)sourceOpenPayment).getCreatedUser().getName()) : null;
            targetOpenPayment.save(createdUser, false);
        }
        for (PeriodicPayment sourcePeriodicPayment : this.sourceServer.find(PeriodicPayment.class).where().eq("bank.tenant", (Object)this.sourceTenant).findList()) {
            targetAccount = importedAccountsMap.get(sourcePeriodicPayment.getAccount());
            if (targetAccount == null) continue;
            PeriodicPayment targetPeriodicPayment = new PeriodicPayment();
            targetPeriodicPayment.setBank(targetAccount.getBank());
            targetPeriodicPayment.setAccount(targetAccount);
            targetPeriodicPayment.setPmtType(sourcePeriodicPayment.getPmtType());
            targetPeriodicPayment.setOrderType(sourcePeriodicPayment.getOrderType());
            targetPeriodicPayment.setFileType(sourcePeriodicPayment.getFileType());
            targetPeriodicPayment.setCredit(sourcePeriodicPayment.isCredit());
            targetPeriodicPayment.setUrgent(sourcePeriodicPayment.isUrgent());
            targetPeriodicPayment.setRecipient(sourcePeriodicPayment.getRecipient());
            targetPeriodicPayment.setAmount(sourcePeriodicPayment.getAmount());
            targetPeriodicPayment.setAmountCurrency(sourcePeriodicPayment.getAmountCurrency());
            targetPeriodicPayment.setPurpose(sourcePeriodicPayment.getPurpose());
            targetPeriodicPayment.setExecutionInterval(sourcePeriodicPayment.getExecutionInterval());
            targetPeriodicPayment.setFirstExecutionDate(sourcePeriodicPayment.getFirstExecutionDate());
            targetPeriodicPayment.setLastExecutionDate(sourcePeriodicPayment.getLastExecutionDate());
            targetPeriodicPayment.setPreviousExecutionDate(sourcePeriodicPayment.getPreviousExecutionDate());
            targetPeriodicPayment.setNextExecutionDate(sourcePeriodicPayment.getNextExecutionDate());
            targetPeriodicPayment.setPaymentData(sourcePeriodicPayment.getPaymentData());
            targetPeriodicPayment.setGenericPurpose(sourcePeriodicPayment.getGenericPurpose());
            targetPeriodicPayment.setFolder((PaymentFolder)importedPaymentFolder.get(sourcePeriodicPayment.getFolder()));
            targetPeriodicPayment.setSalaryPayment(sourcePeriodicPayment.getSalaryPayment());
            createdUser = sourcePeriodicPayment.getCreatedUser() != null ? User.getUser(sourcePeriodicPayment.getCreatedUser().getName()) : null;
            targetPeriodicPayment.save(createdUser, false);
        }
        for (PaymentTemplate sourcePaymentTemplate : this.sourceServer.find(PaymentTemplate.class).where().eq("bank.tenant", (Object)this.sourceTenant).findList()) {
            targetAccount = importedAccountsMap.get(sourcePaymentTemplate.getAccount());
            if (targetAccount == null) continue;
            PaymentTemplate targetPaymentTemplate = new PaymentTemplate();
            targetPaymentTemplate.setBank(targetAccount.getBank());
            targetPaymentTemplate.setName(sourcePaymentTemplate.getName());
            int counter = 1;
            while (PaymentTemplate.findTemplateByName(targetPaymentTemplate.getName()) != null) {
                targetPaymentTemplate.setName(sourcePaymentTemplate.getName() + "." + counter++);
            }
            targetPaymentTemplate.setAccount(targetAccount);
            targetPaymentTemplate.setPmtType(sourcePaymentTemplate.getPmtType());
            targetPaymentTemplate.setOrderType(sourcePaymentTemplate.getOrderType());
            targetPaymentTemplate.setFileType(sourcePaymentTemplate.getFileType());
            targetPaymentTemplate.setCredit(sourcePaymentTemplate.isCredit());
            targetPaymentTemplate.setUrgent(sourcePaymentTemplate.isUrgent());
            targetPaymentTemplate.setRecipient(sourcePaymentTemplate.getRecipient());
            targetPaymentTemplate.setAmount(sourcePaymentTemplate.getAmount());
            targetPaymentTemplate.setAmountCurrency(sourcePaymentTemplate.getAmountCurrency());
            targetPaymentTemplate.setGenericPurpose(sourcePaymentTemplate.getGenericPurpose());
            targetPaymentTemplate.setPaymentData(sourcePaymentTemplate.getPaymentData());
            targetPaymentTemplate.setSalaryPayment(sourcePaymentTemplate.getSalaryPayment());
            targetPaymentTemplate.save();
        }
    }

    public static void main(String[] args) {
        File sourceWorkspaceDir = null;
        File targetWorkspaceDir = null;
        String sourceTenant = "DEFAULT";
        String targetTenant = "DEFAULT";
        boolean withoutAccounts = false;
        boolean withoutRecipients = false;
        boolean withoutPayments = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("--sourceWorkspaceDir".equals(args[i]) && i < args.length - 1) {
                sourceWorkspaceDir = new File(args[++i]);
                continue;
            }
            if ("--targetWorkspaceDir".equals(args[i]) && i < args.length - 1) {
                targetWorkspaceDir = new File(args[++i]);
                continue;
            }
            if ("--sourceTenant".equals(args[i]) && i < args.length - 1) {
                sourceTenant = args[++i];
                continue;
            }
            if ("--targetTenant".equals(args[i]) && i < args.length - 1) {
                targetTenant = args[++i];
                continue;
            }
            if ("--withoutAccounts".equals(args[i])) {
                withoutAccounts = true;
                continue;
            }
            if ("--withoutRecipients".equals(args[i])) {
                withoutRecipients = true;
                continue;
            }
            if (!"--withoutPayments".equals(args[i])) continue;
            withoutPayments = true;
        }
        if (sourceWorkspaceDir == null || !sourceWorkspaceDir.isDirectory() || targetWorkspaceDir == null || !targetWorkspaceDir.isDirectory()) {
            System.err.println("Usage: java -jar bl-banking-workspace-import-tool.jar --sourceWorkspaceDir <...> --targetWorkspaceDir <...> [--sourceTenant <...> --targetTenant <...> --withoutAccounts --withoutRecipients --withoutPayments]");
            return;
        }
        new WorkspaceImport(sourceWorkspaceDir, targetWorkspaceDir, sourceTenant, targetTenant, withoutAccounts, withoutRecipients, withoutPayments).run();
    }
}

