/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AddressPropertyHandler;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.format.AddressData;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;

public class SwissRecipientData
extends RecipientData {
    private final PaymentType recipientType;
    private AddressData address;

    public SwissRecipientData(PaymentType type) {
        this.recipientType = type;
    }

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
    }

    @Override
    public PaymentType getPaymentType() {
        return this.recipientType;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        this.address = AddressPropertyHandler.getAddressData(properties);
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        AddressPropertyHandler.setAddressData(this.address, properties);
        this.setRecipientInfoProperties(properties);
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            SwissRecipientData original = new SwissRecipientData(originalVo.getPaymentType());
            original.setPaymentRecipient(originalVo);
            if (!AddressData.areEqual(this.address, original.getAddress())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean hasChangeWithoutForEyes(PaymentRecipient originalVo) {
        if (super.hasChangeWithoutForEyes(originalVo)) {
            return true;
        }
        try {
            SwissRecipientData original = new SwissRecipientData(this.recipientType);
            original.setPaymentRecipient(originalVo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
    }

    public AddressData getAddress() {
        return this.address;
    }

    public void setAddress(AddressData address) {
        this.address = address;
    }
}

