/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.VopUtil;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.transfer.api.SendFileAutoDetectException;
import de.businesslogics.banking.transfer.api.SendFileDetector;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.xml.sax.SAXException;

public class SepaSendFileDetector
implements SendFileDetector {
    private boolean doVopCheck = false;

    @Override
    public void doVopCheck(boolean doVopCheck) {
        this.doVopCheck = doVopCheck;
    }

    @Override
    public SendFileDetector.Result detect(File f, User user) throws SendFileAutoDetectException {
        HashMap<BankSettings, String> bankTransferTypeMap = new HashMap<BankSettings, String>();
        List<SEPALogicalFile> logicalFiles = this.getLogicalfiles(f);
        List<BankSettings> banks = this.getBanks(logicalFiles, user);
        if (banks.isEmpty()) {
            throw new NoBankFoundException();
        }
        for (BankSettings bank : banks) {
            Set<PaymentTransferType.PmtType> pmtTypes;
            Set<String> transferTypes = this.getTransferTypes(user, bank, pmtTypes = this.getPmtTypes(logicalFiles, bank.getCountryCode()), logicalFiles);
            if (transferTypes.size() != 1) continue;
            bankTransferTypeMap.put(bank, transferTypes.iterator().next());
        }
        if (bankTransferTypeMap.isEmpty()) {
            throw new DifferentOrderTypeException();
        }
        return new SendFileDetector.Result(bankTransferTypeMap);
    }

    private Set<String> getTransferTypes(User user, BankSettings bank, Set<PaymentTransferType.PmtType> pmtTypes, List<SEPALogicalFile> logicalFiles) throws SendFileAutoDetectException {
        HashSet<String> transferTypes = new HashSet<String>();
        for (PaymentTransferType.PmtType pmtType : pmtTypes) {
            if ("AT".equalsIgnoreCase(bank.getCountryCode()) && PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER.equals((Object)pmtType)) {
                pmtType = PaymentTransferType.PmtType.AUSTRIAN_FOREIGN;
            }
            if (!SendUtil.isBeforeVopDate() && bank.isVopActivated() && VopUtil.hasVopPermission(user, bank, pmtType) && (this.doVopCheck || bank.isVopMandatory() && logicalFiles.size() == 1 && logicalFiles.getFirst().getNbOfTxs() == 1L)) {
                transferTypes.add(SendParameters.getTransferTypeVopByBank(bank, pmtType));
                continue;
            }
            transferTypes.add(SendParameters.getTransferTypeByBank(bank, pmtType));
        }
        return transferTypes;
    }

    private List<SEPALogicalFile> getLogicalfiles(File file) throws SendFileAutoDetectException {
        List<SEPALogicalFile> list;
        FileInputStream in = new FileInputStream(file);
        try {
            list = GeneralSEPAExtractor.getLogicalFiles(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SAXException e) {
                throw new GeneralException((Throwable)e);
            }
        }
        ((InputStream)in).close();
        return list;
    }

    private Set<PaymentTransferType.PmtType> getPmtTypes(List<SEPALogicalFile> logicalFiles, String bankCountryCode) {
        HashSet<PaymentTransferType.PmtType> pmtTypes = new HashSet<PaymentTransferType.PmtType>();
        for (SEPALogicalFile logicalFile : logicalFiles) {
            List<SEPAPaymentData> transactions = logicalFile.getTransactions();
            for (SEPAPaymentData paymentData : transactions) {
                pmtTypes.add(SepaApi.getPmtType(paymentData, bankCountryCode));
            }
        }
        return pmtTypes;
    }

    private List<BankSettings> getBanks(List<SEPALogicalFile> logicalFiles, User user) throws SendFileAutoDetectException {
        ArrayList<BankSettings> fileBanks = new ArrayList<BankSettings>();
        Set<String> ibans = this.getIBANsFromLogicalFileList(logicalFiles);
        if (ibans == null || ibans.isEmpty()) {
            throw new NoSepaPaymentDataFoundException();
        }
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            if (!BankUtils.isReady(bankUser)) continue;
            List<Account> accounts = Account.findAccountsForBank(bankUser.getBank());
            HashSet<String> i2 = new HashSet<String>();
            for (Account account : accounts) {
                if (account.getIban() == null || Account.Type.CASH_MANAGEMENT.equals((Object)account.getType())) continue;
                i2.add(account.getIban());
            }
            if (!i2.containsAll(ibans)) continue;
            fileBanks.add(bankUser.getBank());
        }
        return fileBanks;
    }

    private Set<String> getIBANsFromLogicalFileList(List<SEPALogicalFile> logicalFileList) throws DifferentOrderTypeException {
        HashSet<String> ibans = new HashSet<String>();
        List<SEPAPaymentData> trxs = null;
        for (SEPALogicalFile lgFile : logicalFileList) {
            trxs = lgFile.getTransactions();
            for (SEPAPaymentData sepaData : trxs) {
                ibans.add(sepaData.getOriginatorIban());
            }
        }
        return ibans;
    }

    public final class NoBankFoundException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = 1236014028225229638L;

        @Override
        public String getMessage(Locale locale) {
            return SepaApiMessages.getString(locale, "sendFileAutoDetect.noBankCouldBeFound", new Object[0]);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }
    }

    private final class DifferentOrderTypeException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = 2465038316320613071L;

        private DifferentOrderTypeException() {
        }

        @Override
        public String getMessage(Locale locale) {
            return SepaApiMessages.getString(locale, "sendFileAutoDetect.differentOrderTypesFound", new Object[0]);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }
    }

    private final class GeneralException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = -8719472773391215019L;

        public GeneralException(Throwable cause) {
            super(cause);
        }

        @Override
        public String getMessage(Locale locale) {
            if (this.getCause() != null) {
                return this.getCause().getMessage();
            }
            return super.getMessage();
        }
    }

    private final class NoSepaPaymentDataFoundException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = -4976667795999396387L;

        private NoSepaPaymentDataFoundException() {
        }

        @Override
        public String getMessage(Locale locale) {
            return SepaApiMessages.getString(locale, "sendFileAutoDetect.noSepaPaymentDataFound", new Object[0]);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }
    }
}

