/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AddressPropertyHandler;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.format.AddressData;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public final class SepaRecipientData
extends RecipientData {
    private static final ThreadLocal<SimpleDateFormat> YYYYMMDD = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));
    private Date mandateSignDate;
    private String sequenceType;
    private String leiNumber;
    private AddressData address;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
        this.setName(properties.getProperty(RecipientData.MultiwebPropertiesKeys.NAME.name()));
        this.setAccountNumber(properties.getProperty(RecipientData.MultiwebPropertiesKeys.IBAN.name()));
        this.setBankCode(properties.getProperty(RecipientData.MultiwebPropertiesKeys.BIC.name()));
        this.setPurpose(properties.getProperty(RecipientData.MultiwebPropertiesKeys.PURPOSE.name()));
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.SEPA;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        String propMandateSignDate = properties.getProperty(PropertiesKeys.MANDATE_SIGN_DATE.getKey());
        if (propMandateSignDate != null && !propMandateSignDate.isEmpty()) {
            try {
                this.mandateSignDate = YYYYMMDD.get().parse(propMandateSignDate);
            }
            catch (ParseException e) {
                throw new IOException("Failed to parse mandate sign date!", e);
            }
        }
        this.sequenceType = properties.getProperty(PropertiesKeys.SEQUENCE_TYPE.getKey());
        this.leiNumber = properties.getProperty(PropertiesKeys.LEI_NUMBER.getKey());
        this.address = AddressPropertyHandler.getAddressData(properties);
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        String mandateSignDateString = this.mandateSignDate != null ? YYYYMMDD.get().format(this.mandateSignDate) : null;
        this.setProperty(properties, PropertiesKeys.MANDATE_SIGN_DATE, mandateSignDateString);
        this.setProperty(properties, PropertiesKeys.SEQUENCE_TYPE, this.sequenceType);
        this.setProperty(properties, PropertiesKeys.LEI_NUMBER, this.leiNumber);
        AddressPropertyHandler.setAddressData(this.address, properties);
        this.setRecipientInfoProperties(properties);
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            SepaRecipientData original = new SepaRecipientData();
            original.setPaymentRecipient(originalVo);
            if (!AddressData.areEqual(this.address, original.getAddress())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.leiNumber, original.getLeiNumber())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean hasChangeWithoutForEyes(PaymentRecipient originalVo) {
        if (super.hasChangeWithoutForEyes(originalVo)) {
            return true;
        }
        try {
            SepaRecipientData original = new SepaRecipientData();
            original.setPaymentRecipient(originalVo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
        boolean useMandateAdministration = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean(PreferenceConstants.USE_MANDATE_ADMISTRATION);
        if (withHeader) {
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]), false, columnSeparator, lineSeparator);
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name", new Object[0]), false, columnSeparator, lineSeparator);
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.iban", new Object[0]), false, columnSeparator, lineSeparator);
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.bic", new Object[0]), false, columnSeparator, lineSeparator);
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), false, columnSeparator, lineSeparator);
            if (!useMandateAdministration) {
                SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.mandateReference", new Object[0]), false, columnSeparator, lineSeparator);
                SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.mandateSignDate", new Object[0]), false, columnSeparator, lineSeparator);
                SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.sequenceType", new Object[0]), false, columnSeparator, lineSeparator);
            }
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]), false, columnSeparator, lineSeparator);
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.town", new Object[0]), false, columnSeparator, lineSeparator);
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.country", new Object[0]), false, columnSeparator, lineSeparator);
            SepaRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.bank", new Object[0]), true, columnSeparator, lineSeparator);
        }
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getDisplayName(), false, columnSeparator, lineSeparator);
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getName(), false, columnSeparator, lineSeparator);
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getAccountNumber(), false, columnSeparator, lineSeparator);
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getBankCode(), false, columnSeparator, lineSeparator);
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getPurpose(), false, columnSeparator, lineSeparator);
        if (!useMandateAdministration) {
            SepaRecipientData.writeCsvFieldToWriter(writer, this.getPaymentRecipient().getSepaMandateId(), false, columnSeparator, lineSeparator);
            if (this.getMandateSignDate() != null) {
                SepaRecipientData.writeCsvFieldToWriter(writer, DateFormat.getDateInstance().format(this.getMandateSignDate()), false, columnSeparator, lineSeparator);
            } else {
                SepaRecipientData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
            }
            if (this.getSequenceType() != null) {
                SepaRecipientData.writeCsvFieldToWriter(writer, this.getSequenceType(), false, columnSeparator, lineSeparator);
            } else {
                SepaRecipientData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
            }
        }
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getAddressLine1(), false, columnSeparator, lineSeparator);
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getAddressLine2(), false, columnSeparator, lineSeparator);
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getCountry(), false, columnSeparator, lineSeparator);
        SepaRecipientData.writeCsvFieldToWriter(writer, this.getBankName(), true, columnSeparator, lineSeparator);
    }

    public Date getMandateSignDate() {
        return this.mandateSignDate;
    }

    public void setMandateSignDate(Date mandateSignDate) {
        this.mandateSignDate = mandateSignDate;
    }

    public String getSequenceType() {
        return this.sequenceType;
    }

    public void setSequenceType(String sequenceType) {
        this.sequenceType = sequenceType;
    }

    public String getLeiNumber() {
        return this.leiNumber;
    }

    public void setLeiNumber(String leiNumber) {
        this.leiNumber = leiNumber;
    }

    public AddressData getAddress() {
        return this.address;
    }

    public void setAddress(AddressData address) {
        this.address = address;
    }

    public String getAddressLine1() {
        List<String> addressLines = this.getAddress().getAddressLines();
        return !addressLines.isEmpty() ? addressLines.getFirst() : "";
    }

    public String getAddressLine2() {
        List<String> addressLines = this.getAddress().getAddressLines();
        return addressLines.size() >= 2 ? addressLines.get(1) : "";
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        MANDATE_SIGN_DATE("mandateSignDate"),
        SEQUENCE_TYPE("sequenceType"),
        LEI_NUMBER("lei");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

