/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.core.GeneralTexts;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.payments.api.BankingPaymentPrinter;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.ChequeInstructionData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.RejectedSEPAOrder;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.PaymentUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class SepaPaymentPrinter
extends BankingPaymentPrinter {
    private final String orderType;

    public SepaPaymentPrinter(Locale locale, String orderType) {
        super(locale);
        this.orderType = orderType;
    }

    @Deprecated
    public void printPayment(BLDocument document, Send send, SEPAPaymentData payment, String reference) throws PDFException {
        this.printPayment(document, send, null, payment, reference);
    }

    public void printPayment(BLDocument document, SignedPayment signedPayment, SEPAPaymentData payment, String reference) throws PDFException {
        if (signedPayment != null) {
            this.printPayment(document, signedPayment.getSend(), signedPayment, payment, reference);
        } else {
            this.printPayment(document, null, null, payment, reference);
        }
    }

    private void printPayment(BLDocument document, Send send, SignedPayment signedPayment, SEPAPaymentData payment, String reference) throws PDFException {
        ChequeInstructionData chkData;
        BLTable<?> t = PDFCreator.getInstance().createTable(4);
        t.setBorder(BLBorder.NO_BORDER);
        t.setWidth(100.0f);
        t.setWidths(new int[]{17, 33, 17, 33});
        boolean isCredit = payment.isCredit();
        boolean isForeign = payment.isForeignPayment() || !SEPAServiceLevel.SEPA.name().equals(payment.getServiceLevel());
        boolean isCheque = payment.isChequePayment();
        String headerText = isCredit ? (GeneralSEPAExtractor.URGP.equals(payment.getServiceLevel()) ? SepaApiMessages.getString(this.locale, "printer.urgentcreditpayment", new Object[0]) : (payment.isInstantPayment() ? SepaApiMessages.getString(this.locale, "printer.instantcreditpayment", new Object[0]) : (isCheque ? BankingApiMessages.getString(this.locale, "PaymentTypeUtil.chequePaymentXML", new Object[0]) : (isForeign ? SepaApiMessages.getString(this.locale, "printer.foreigncreditpayment", new Object[0]) : SepaApiMessages.getString(this.locale, "printer.creditpayment", new Object[0]))))) : (SEPALocalInstrument.B2B.name().equals(payment.getDebitType()) ? SepaApiMessages.getString(this.locale, "printer.b2bdebitpayment", new Object[0]) : SepaApiMessages.getString(this.locale, "printer.coredebitpayment", new Object[0]));
        this.printHeaderLine(t, headerText);
        if (send != null) {
            this.printOrderInfo(t, send, reference);
        }
        t.setDefaultColspan(2);
        t.addCell(this.getTextOriginatorData(isCredit), BOLD_FONT);
        t.addCell(this.getTextRecipientData(isCredit), BOLD_FONT);
        t.setDefaultColspan(1);
        String textName = this.getTextName();
        t.addCell(textName, FONT);
        t.addCell(payment.getOriginator(), FONT);
        t.addCell(textName, FONT);
        t.addCell(payment.getRecipient(), FONT);
        String textIban = this.getTextIban();
        t.addCell(textIban, FONT);
        t.addCell(IbanUtil.formatIBAN(payment.getOriginatorIban()), FONT);
        if (!isCheque) {
            if (isForeign) {
                t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.accountNumberIban", new Object[0]), FONT);
            } else {
                t.addCell(textIban, FONT);
            }
            t.addCell(IbanUtil.formatIBAN(payment.getRecipientIban()), FONT);
        } else {
            this.addEmptyCells(t, 2);
        }
        String textBic = this.getTextBic();
        t.addCell(textBic, FONT);
        t.addCell(payment.getOriginatorBic(), FONT);
        if (!isCheque) {
            if (isForeign) {
                t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.bankCodeBic", new Object[0]), FONT);
            } else {
                t.addCell(textBic, FONT);
            }
            t.addCell(payment.getRecipientBic(), FONT);
        } else {
            this.addEmptyCells(t, 2);
        }
        if (isForeign && !isCheque) {
            this.addEmptyCells(t, 2);
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.clearingSystem", new Object[0]), FONT);
            t.addCell(payment.getRecipientClearingSystemId(), FONT);
        }
        if (isForeign) {
            int i;
            this.addEmptyCells(t, 4);
            this.addEmptyCells(t, 4);
            List<String> originatorAddress = this.getAddressTableCells(payment.getOriginatorAddressData());
            List<String> recipientAddress = this.getAddressTableCells(payment.getRecipientAddressData());
            if (isCheque) {
                List<String> chequeAddress;
                ChequeInstructionData chkData2 = payment.getChequeInstructionData();
                if (chkData2 != null && !(chequeAddress = this.getAddressTableCells(chkData2.getDeliverToAddress())).isEmpty()) {
                    recipientAddress.add("");
                    recipientAddress.add("");
                    recipientAddress.add(BankingApiMessages.getString(this.locale, "GeneralMessages.ultimateRecipient", new Object[0]));
                    recipientAddress.add(chkData2.getDeliverToName());
                    recipientAddress.addAll(chequeAddress);
                }
            } else {
                List<String> bankAddress = this.getAddressTableCells(payment.getRecipientBankAddressData());
                if (!bankAddress.isEmpty()) {
                    recipientAddress.add("");
                    recipientAddress.add("");
                    recipientAddress.add(BankingApiMessages.getString(this.locale, "GeneralMessages.bankAddress", new Object[0]));
                    recipientAddress.addAll(bankAddress.subList(1, bankAddress.size()));
                }
            }
            boolean originatorHasMoreLines = false;
            int max = originatorAddress.size();
            if (recipientAddress.size() < max) {
                max = recipientAddress.size();
                originatorHasMoreLines = true;
            }
            for (i = 0; i < max; i += 2) {
                t.addCell(originatorAddress.get(i));
                t.addCell(originatorAddress.get(i + 1));
                t.addCell(recipientAddress.get(i));
                t.addCell(recipientAddress.get(i + 1));
            }
            if (originatorHasMoreLines) {
                while (i < originatorAddress.size()) {
                    t.addCell(originatorAddress.get(i));
                    t.addCell(originatorAddress.get(i + 1));
                    this.addEmptyCells(t, 2);
                    i += 2;
                }
            } else {
                while (i < recipientAddress.size()) {
                    this.addEmptyCells(t, 2);
                    t.addCell(recipientAddress.get(i));
                    t.addCell(recipientAddress.get(i + 1));
                    i += 2;
                }
            }
            this.addEmptyCells(t, 4);
            this.addEmptyCells(t, 4);
        }
        if (!isCredit) {
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.creditorId", new Object[0]), FONT);
            t.addCell(payment.getCreditorId(), FONT);
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.mandateReference", new Object[0]), FONT);
            t.addCell(payment.getMandateId(), FONT);
            this.addEmptyCell(t);
            this.addEmptyCell(t);
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.mandateSignDate", new Object[0]), FONT);
            this.printDate(t, payment.getMandateSignDate());
            this.addEmptyCell(t);
            this.addEmptyCell(t);
            t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.sequenceType", new Object[0]), FONT);
            t.addCell(payment.getSequenceType(), FONT);
        }
        t.setDefaultColspan(4);
        this.addEmptyCell(t);
        t.addCell(this.getTextPaymentData(), BOLD_FONT);
        t.setDefaultColspan(1);
        t.addCell(this.getTextAmount(), FONT);
        t.addCell(PaymentUtils.formatAmount(payment.getAmount(), payment.getCurrency(), this.locale), FONT);
        if (payment.hasExecutionTime()) {
            t.addCell(GeneralMessages.getInstance((Locale)this.locale).EXECUTION_TIME, FONT);
            this.printDateTime(t, payment.getExecutionDate());
        } else {
            t.addCell(this.getTextExecutionDate(payment.isCredit()), FONT);
            this.printDate(t, payment.getExecutionDate());
        }
        if (isForeign) {
            t.addCell(this.getTextCurrency());
            t.addCell(payment.getCurrency().getCurrencyCode());
            if (payment.getChargeBearer() != null && !payment.getChargeBearer().isEmpty()) {
                t.addCell(this.getTextFeeType(), FONT);
                t.addCell(payment.getChargeBearer(), FONT);
            }
            if (payment.getServiceLevel() != null && !payment.getServiceLevel().isEmpty()) {
                t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.serviceLevel", new Object[0]), FONT);
                t.addCell(payment.getServiceLevel(), FONT);
            }
        }
        if (isCheque && (chkData = payment.getChequeInstructionData()) != null) {
            if (chkData.getChequeType() != null && !chkData.getChequeType().isEmpty()) {
                t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.chequeType", new Object[0]), FONT);
                t.addCell(chkData.getChequeType(), FONT);
            }
            if (chkData.getDeliveryMethod() != null && !chkData.getDeliveryMethod().isEmpty()) {
                t.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.deliveryMethod", new Object[0]), FONT);
                t.addCell(chkData.getDeliveryMethod(), FONT);
            }
        }
        t.addCell(this.getTextPurpose(), FONT);
        t.addCell(payment.getPurpose(), FONT);
        t.addCell(GeneralMessages.getInstance((Locale)this.locale).END_TO_END_REFERENCE, FONT);
        t.addCell(payment.getEndToEndId(), FONT);
        if (send != null) {
            String reason;
            t.setDefaultColspan(4);
            this.addEmptyCell(t);
            t.addCell(this.getTextOrderData(), BOLD_FONT);
            t.setDefaultColspan(1);
            String sendType = send.getOriginalSendType();
            if (Util.isOrderType(sendType)) {
                t.addCell(this.getTextOrderType(), FONT);
                t.addCell(sendType, FONT);
            } else {
                t.addCell(this.getTextBTF(), FONT);
                t.addCell(sendType, FONT);
            }
            t.addCell(this.getTextOrderNumber(), FONT);
            t.addCell(send.getOrderNumber(), FONT);
            t.addCell(this.getTextMsgId(), FONT);
            t.addCell(send.getMsgId(), FONT);
            t.addCell(this.getTextPmtInfId(), FONT);
            if (signedPayment != null) {
                t.addCell(signedPayment.getPmtInfId(), FONT);
            } else {
                t.addCell(payment.getPmtInfId(), FONT);
            }
            t.addCell(this.getTextSendTime(), FONT);
            t.addCell(DateFormat.getDateTimeInstance(1, 2, this.locale).format(send.getSent()), FONT);
            t.addCell(this.getTextState(), FONT);
            if (signedPayment != null) {
                t.addCell(SendUtil.getExtendedState(signedPayment, this.locale));
            } else {
                t.addCell(SendUtil.getExtendedState(send, this.locale));
            }
            if (signedPayment.isRejected() && (reason = signedPayment.getStatusReasonInfo()) != null) {
                t.addCell(GeneralTexts.DEFAULT.REASON, FONT);
                t.setDefaultColspan(3);
                Object description = RejectedSEPAOrder.getDescriptionFromTrxReasonInfo(reason, false, Locale.getDefault());
                String additionalInfo = RejectedSEPAOrder.getAdditionalInfoFromTrxReasonInfo(reason);
                if (additionalInfo != null && !((String)description).contains(additionalInfo)) {
                    description = (String)description + " " + additionalInfo;
                }
                t.addCell((String)description);
                t.setDefaultColspan(1);
            }
            if (signedPayment.getBooking() != null) {
                CmBooking b = signedPayment.getBooking();
                t.addCell(GeneralMessages.getInstance((Locale)this.locale).BOOKING_DATE, FONT);
                this.printDate(t, b.getValueDate());
                t.addCell(GeneralMessages.getInstance((Locale)this.locale).VALUE_DATE, FONT);
                this.printDate(t, b.getValueDate());
                CmStatement s = signedPayment.getBooking().getStatement();
                if (s.getStatementNumberToDisplay() != null) {
                    t.addCell(GeneralMessages.getInstance((Locale)this.locale).ACCOUNT_STATEMENT, FONT);
                    t.addCell(s.getStatementNumberToDisplay().toString(), FONT);
                }
            }
        }
        document.addTable(t);
    }

    private List<String> getAddressTableCells(AddressData a) {
        ArrayList<String> list = new ArrayList<String>();
        if (a == null) {
            return list;
        }
        if (a.getDepartment() != null && !a.getDepartment().isEmpty()) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.departement", new Object[0]));
            list.add(a.getDepartment());
        }
        if (a.getSubDepartment() != null && !a.getSubDepartment().isEmpty()) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.subDepartement", new Object[0]));
            list.add(a.getSubDepartment());
        }
        if (a.getStreetName() != null && !a.getStreetName().isEmpty()) {
            list.add(this.getTextStreet());
            list.add(a.getStreetName());
        }
        if (a.getBuildingNumber() != null && !a.getBuildingNumber().isEmpty()) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.buildingNumber", new Object[0]));
            list.add(a.getBuildingNumber());
        }
        if (a.getPostCode() != null && !a.getPostCode().isEmpty()) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.postCode", new Object[0]));
            list.add(a.getPostCode());
        }
        if (a.getTownName() != null && !a.getTownName().isEmpty()) {
            list.add(this.getTextTown());
            list.add(a.getTownName());
        }
        if (a.getCountryOfResidence() != null && !a.getCountryOfResidence().isEmpty()) {
            list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.subCountry", new Object[0]));
            list.add(a.getCountryOfResidence());
        }
        if (!list.isEmpty() && a.getCountry() != null && !a.getCountry().isEmpty()) {
            list.add(this.getTextCountry());
            list.add(a.getCountry());
            list.add("");
            list.add("");
        }
        boolean firstline = true;
        for (String line : a.getAddressLines()) {
            if (firstline) {
                list.add(BankingApiMessages.getString(this.locale, "GeneralMessages.address", new Object[0]));
            } else {
                list.add("");
            }
            list.add(line);
        }
        if (!a.getAddressLines().isEmpty() && a.getCountry() != null && !a.getCountry().isEmpty()) {
            list.add(this.getTextCountry());
            list.add(a.getCountry());
        }
        return list;
    }
}

