/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.SepaChecker;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PaymentImportHandler;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.banking.sepa.api.SepaPaymentImportException;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.xml.sax.SAXException;

public abstract class SepaPaymentImportHandler
extends PaymentImportHandler {
    @Deprecated
    public SepaPaymentImportHandler(BLLogger logger) {
        super(logger, Locale.getDefault(), true);
    }

    @Deprecated
    public SepaPaymentImportHandler(BLLogger logger, Locale locale) {
        super(logger, locale, true);
    }

    public SepaPaymentImportHandler(BLLogger logger, Locale locale, boolean importRecipient) {
        super(logger, locale, importRecipient);
    }

    public final void readFrom(InputStream inputStream, BankSettings bankSettings, PaymentTransferType.PmtType pmtType, User user) throws SepaPaymentImportException, SAXException, IOException {
        this.readFrom(inputStream, bankSettings, pmtType, user, false);
    }

    public final void readFrom(InputStream inputStream, BankSettings bankSettings, PaymentTransferType.PmtType pmtType, User user, boolean allowContainerFileImport) throws SepaPaymentImportException, SAXException, IOException {
        this.accounts = this.loadAccounts(user, bankSettings, pmtType, PermissionsLoader.AccountType.IBAN);
        if (SepaApi.isCreditPmtType(pmtType)) {
            this.importPayments(GeneralSEPAExtractor.getPaymentsFromCCT(inputStream, allowContainerFileImport), pmtType, user);
        } else {
            this.importPayments(GeneralSEPAExtractor.getDebitPayments(inputStream, allowContainerFileImport), pmtType, user);
        }
    }

    protected abstract Account checkForReplaceAccount(List<Account> var1, String var2, String var3);

    protected abstract boolean checkForOverrideImportSalaries();

    protected abstract void createPayment(BankSettings var1, PaymentTransferType.PmtType var2, SEPAPaymentData var3) throws SepaPaymentImportException;

    protected abstract boolean isImportSalaries();

    protected abstract boolean isDisplayAsSingleBooking();

    private void importPayments(List<SEPAPaymentData> payments, PaymentTransferType.PmtType selectedPmtType, User user) throws SepaPaymentImportException {
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording(user);
        boolean useMandateAdministration = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean(PreferenceConstants.USE_MANDATE_ADMISTRATION);
        boolean displayAsSingleBooking = this.isDisplayAsSingleBooking();
        boolean importSalaries = this.isImportSalaries();
        String selectedPmtTypeName = PaymentTypeUtil.getUniquePaymentName(this.locale, selectedPmtType);
        for (SEPAPaymentData payment : payments) {
            PaymentType paymentType;
            PaymentTransferType.PmtType defaultPmtType;
            BankSettings bankSettings = this.loadBank(payment);
            if (bankSettings == null) {
                this.logger.logInfo("Originator account not found - IBAN: " + payment.getOriginatorIban());
                this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownOriginatorAccount", IbanUtil.formatIfIBAN(payment.getOriginatorIban())));
                continue;
            }
            PaymentTransferType.PmtType pmtType = SepaApi.getPmtType(payment, selectedPmtType, bankSettings.getCountryCode());
            if (!this.isSuitablePmtType(pmtType, payment, selectedPmtType, selectedPmtTypeName)) continue;
            Tenant tenant = bankSettings.getTenant();
            DatabasePreferenceStore paymentsStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, tenant);
            boolean allowOriginatorRecording = paymentsStore.getBoolean(de.businesslogics.banking.payments.core.PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
            boolean checkPermissions = paymentsStore.getBoolean(de.businesslogics.banking.payments.core.PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING);
            DatabasePreferenceStore sepaStore = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user, tenant);
            boolean allowForeignCurrencies = sepaStore.getBoolean(PreferenceConstants.ALLOW_FOREIGN_CURRENCIES);
            if (checkPermissions) {
                String orderTypeOrBtf;
                Account originatorAccount = this.loadOriginatorAccount(bankSettings, payment.getOriginatorIban(), payment.getCurrency().getCurrencyCode());
                String string = orderTypeOrBtf = BankUtils.isProtocolH005OrNewer(bankSettings.getProtocolVersion()) ? SendParameters.getBTF(bankSettings, pmtType) : SendParameters.getOrderType(bankSettings, pmtType);
                if (originatorAccount == null || new PermissionsLoader(user).getAccountOrderTypes(originatorAccount, new String[]{orderTypeOrBtf}).isEmpty()) {
                    String iban = IbanUtil.formatIfIBAN(payment.getOriginatorIban());
                    this.logger.logInfo("No permission for originator account " + iban + " or for order type " + orderTypeOrBtf);
                    this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.noPermissionForAccountOrOrderType", orderTypeOrBtf, iban));
                    continue;
                }
            }
            if (PaymentTransferType.PmtType.SEPA_TRANSFER.equals((Object)(defaultPmtType = SendParameters.getDefaultPmtType(selectedPmtType))) || PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER.equals((Object)defaultPmtType) || PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)defaultPmtType) || PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT.equals((Object)defaultPmtType) || PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT.equals((Object)defaultPmtType)) {
                if (!allowForeignCurrencies && !"EUR".equals(payment.getCurrency().getCurrencyCode())) {
                    this.addIgnoredPayment(SepaApiMessages.getString(this.locale, "import.onlyineur", payment.getCurrency().getCurrencyCode()));
                    this.logger.logInfo("No import of SEPA payment with currency = " + payment.getCurrency().getCurrencyCode());
                    continue;
                }
                if (displayAsSingleBooking) {
                    payment.setDisplayAsSingleBooking(true);
                }
            }
            if (!importSalaries && SEPAUtil.isSalaryPayment(payment.getPaymentCategory(), payment.getPurposeCode()) && !(importSalaries = this.checkForOverrideImportSalaries())) {
                this.addIgnoredPayment(SepaApiMessages.getString(this.locale, "import.nosalarypayments", new Object[0]));
                this.logger.logInfo("Found salary payment in import file, ignored it because import of salary payments is deactivated!");
                continue;
            }
            if (PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER.equals((Object)pmtType)) {
                if (payment.getServiceLevel() != null) {
                    this.logger.logInfo("Corrected service level for payment of type " + String.valueOf((Object)pmtType) + " from '" + payment.getServiceLevel() + "' to NULL");
                    payment.setServiceLevel(null);
                }
            } else {
                String expectedServiceLevel = SepaChecker.getExpectedServiceLevel(defaultPmtType);
                if (expectedServiceLevel != null && !expectedServiceLevel.equals(payment.getServiceLevel())) {
                    this.logger.logInfo("Corrected service level for payment of type " + String.valueOf((Object)defaultPmtType) + " from '" + payment.getServiceLevel() + "' to " + expectedServiceLevel);
                    payment.setServiceLevel(expectedServiceLevel);
                }
            }
            if (!payment.isCredit() && useMandateAdministration && !this.importRecipient && this.mandateWithDifferentDataExists(payment, bankSettings)) continue;
            if (!allowRecipientRecording && PaymentRecipient.findRecipientByAccountInfo(paymentType = useMandateAdministration && !payment.isCredit() ? PaymentType.MANDATE : PaymentType.SEPA, payment.getRecipient(), payment.getRecipientIban(), payment.getRecipientBic(), bankSettings.getTenant()) == null) {
                this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownRecipient", payment.getRecipient()));
                this.logger.logInfo("Ignored SEPA payment as the recipient " + payment.getRecipient() + "is unknown!");
                continue;
            }
            if (!allowOriginatorRecording && PaymentOriginator.findOriginatorByName(paymentType = useMandateAdministration && !payment.isCredit() ? PaymentType.MANDATE : PaymentType.SEPA, payment.getOriginator(), bankSettings.getTenant()) == null) {
                this.addIgnoredPayment(BankingApiMessages.getString(this.locale, "GeneralMessages.unknownOriginator", payment.getOriginator()));
                this.logger.logInfo("Ignored SEPA payment as the originator " + payment.getOriginator() + "is unknown!");
                continue;
            }
            this.createPayment(bankSettings, selectedPmtType, payment);
        }
    }

    private boolean mandateWithDifferentDataExists(SEPAPaymentData payment, BankSettings bankSettings) {
        PaymentRecipient mandate;
        String mandateId = StringUtils.checkNullAndTrim(payment.getMandateId());
        if (mandateId.length() > 0 && (mandate = PaymentRecipient.findNonHistoricSepaMandateByMandateId(mandateId, bankSettings.getTenant())) != null) {
            try {
                SepaMandateData mandateData = new SepaMandateData();
                mandateData.setPaymentRecipient(mandate);
                String existingMandate = mandateData.getMandateRepresentation();
                String mandateFromPayment = SepaMandateData.getMandateRepresentation(payment);
                if (!existingMandate.equals(mandateFromPayment)) {
                    String debtor = StringUtils.checkNullAndTrim(payment.getRecipient());
                    String msg1 = "Direct debit with debtor " + debtor + " and mandateId " + mandateId + " was not imported: ";
                    String msg2 = "Mandate in payment " + mandateFromPayment + " differs from existing mandate " + existingMandate;
                    String msg = msg1 + msg2;
                    this.addIgnoredPayment(msg);
                    this.logger.logInfo(msg);
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.logError("Mandate with ID " + mandateId + " and pmt_recipient.id = " + mandate.getId() + " cound not be loaded", e);
            }
        }
        return false;
    }

    private boolean isSuitablePmtType(PaymentTransferType.PmtType pmtType, SEPAPaymentData paymentData, PaymentTransferType.PmtType selectedPmtType, String selectedPmtTypeName) {
        boolean hasSelectedDefaultPmtType = selectedPmtType.equals((Object)SendParameters.getDefaultPmtType(selectedPmtType));
        if (selectedPmtType.equals((Object)pmtType) || hasSelectedDefaultPmtType && selectedPmtType.equals((Object)SendParameters.getDefaultPmtType(pmtType))) {
            return true;
        }
        String msgKey = SepaApi.isDebitPmtType(selectedPmtType) ? "import.noSuitableDebitPmtType" : "import.noSuitableCreditPmtType";
        String msg = SepaApiMessages.getString(this.locale, msgKey, paymentData.getRecipient(), PaymentTypeUtil.getUniquePaymentName(this.locale, pmtType), selectedPmtTypeName);
        this.logger.logInfo(msg);
        this.addIgnoredPayment(msg);
        return false;
    }

    private BankSettings loadBank(SEPAPaymentData sepaPaymentData) {
        if (this.accounts == null || this.accounts.isEmpty()) {
            return null;
        }
        for (Account account : this.accounts) {
            if (account.getIban() == null || !account.getIban().equals(sepaPaymentData.getOriginatorIban())) continue;
            sepaPaymentData.setOriginatorBic(account.getBic());
            return account.getBank();
        }
        Account replaceAccount = this.checkForReplaceAccount(this.accounts, sepaPaymentData.getOriginatorBic(), sepaPaymentData.getOriginatorIban());
        if (replaceAccount != null) {
            sepaPaymentData.setOriginatorBic(replaceAccount.getBic());
            sepaPaymentData.setOriginatorIban(replaceAccount.getIban());
            sepaPaymentData.setAccountCurrency(Currency.getInstance(replaceAccount.getCurrency()));
            return replaceAccount.getBank();
        }
        return null;
    }

    private Account loadOriginatorAccount(BankSettings bankSettings, String iban, String currencyCode) {
        Account account = Account.findAccountByIban(bankSettings, iban, currencyCode);
        if (account == null) {
            account = Account.findAccountByIban(bankSettings, iban, null);
        }
        return account;
    }
}

