/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.csv.Converter2;
import de.businesslogics.format.sepa.csv.Format2;
import de.businesslogics.format.sepa.csv.XLSColumHandler;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;

public final class SepaPaymentConversionHandler2
extends PaymentConversionHandler2<Format2> {
    private final GeneralSEPAWriter.Version sepaVersion;
    private final ConverterFormat.Type type;

    public SepaPaymentConversionHandler2(GeneralSEPAWriter.Version sepaVersion, ConverterFormat.Type type, BLLogger logger, File file) {
        super(logger, file);
        this.sepaVersion = sepaVersion;
        this.type = type;
    }

    @Deprecated
    public SepaPaymentConversionHandler2(GeneralSEPAWriter.Version sepaVersion, boolean isCredit, BLLogger logger, File file) {
        super(logger, file);
        this.sepaVersion = sepaVersion;
        this.type = isCredit ? ConverterFormat.Type.SEPA_CREDIT : ConverterFormat.Type.SEPA_DEBIT;
    }

    @Override
    public Format2 getDefaultFormat() {
        if (ConverterFormat.Type.PAIN_001_INTERNATIONAL.equals((Object)this.type)) {
            return Format2.DEFAULT_PAIN_001_INTERNATIONAL;
        }
        if (ConverterFormat.Type.SEPA_DEBIT.equals((Object)this.type)) {
            return Format2.DEFAULT_DEBIT;
        }
        return Format2.DEFAULT_CREDIT;
    }

    @Override
    protected Format2 getFormat(ConverterFormat format) {
        Format2 result = new Format2(format.getFormat(), format.getCountryCode(), new XLSColumHandler());
        result.setCreateInternationalPayments(ConverterFormat.Type.PAIN_001_INTERNATIONAL.equals((Object)format.getType()));
        result.setSepaVersion(this.sepaVersion);
        return result;
    }

    @Override
    protected int checkXls(Format2 format, boolean hasHeader) {
        return Converter2.checkXLS(this.file, format, hasHeader);
    }

    @Override
    protected boolean checkCSVFile(Format2 format, boolean hasHeader) {
        return Converter2.checkCSVFile(this.file, format, hasHeader);
    }

    @Override
    protected List<ConverterFormat> getFormats(User user) {
        List<ConverterFormat> formats = ConverterFormat.findAllByType(this.type, user);
        if (formats.isEmpty()) {
            ConverterFormat format = new ConverterFormat();
            format.setType(this.type);
            format.setFormat(this.getDefaultFormat().toString());
            format.setEncoding(Charset.defaultCharset().name());
            format.setFieldSeparator(";");
            format.setHasHeader(true);
            format.setTenant(user.getTenants().get(0));
            format.save();
            formats.add(format);
        }
        return formats;
    }
}

