/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PaymentConversionHandler;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.csv.Converter;
import de.businesslogics.format.sepa.csv.Format;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;

public final class SepaPaymentConversionHandler
extends PaymentConversionHandler<Format> {
    private final GeneralSEPAWriter.Version sepaVersion;
    private final boolean isCredit;

    public SepaPaymentConversionHandler(GeneralSEPAWriter.Version sepaVersion, boolean isCredit, BLLogger logger, File file) {
        super(logger, file);
        this.sepaVersion = sepaVersion;
        this.isCredit = isCredit;
    }

    @Override
    public Format getDefaultFormat() {
        if (this.isCredit) {
            return Format.DEFAULT_CREDIT;
        }
        return Format.DEFAULT_DEBIT;
    }

    @Override
    protected Format getFormat(ConverterFormat format) {
        Format result = new Format(format.getFormat(), format.getCountryCode());
        result.setSepaVersion(this.sepaVersion);
        return result;
    }

    @Override
    protected int checkXls(Format format, boolean hasHeader) {
        return Converter.checkXLS(this.file, format, hasHeader);
    }

    @Override
    protected boolean checkCSVFile(Format format, boolean hasHeader) {
        return Converter.checkCSVFile(this.file, format, hasHeader);
    }

    @Override
    protected List<ConverterFormat> getFormats(User user) {
        List<ConverterFormat> formats = ConverterFormat.findAllByType(this.isCredit ? ConverterFormat.Type.SEPA_CREDIT : ConverterFormat.Type.SEPA_DEBIT, user);
        if (formats.isEmpty()) {
            if (this.isCredit) {
                ConverterFormat creditFormat = new ConverterFormat();
                creditFormat.setType(ConverterFormat.Type.SEPA_CREDIT);
                creditFormat.setFormat(Format.DEFAULT_CREDIT.toString());
                creditFormat.setEncoding(Charset.defaultCharset().name());
                creditFormat.setFieldSeparator(";");
                creditFormat.setHasHeader(true);
                creditFormat.setTenant(user.getTenants().get(0));
                creditFormat.save();
                formats.add(creditFormat);
            } else {
                ConverterFormat debitFormat = new ConverterFormat();
                debitFormat.setType(ConverterFormat.Type.SEPA_DEBIT);
                debitFormat.setFormat(Format.DEFAULT_DEBIT.toString());
                debitFormat.setEncoding(Charset.defaultCharset().name());
                debitFormat.setFieldSeparator(";");
                debitFormat.setHasHeader(true);
                debitFormat.setTenant(user.getTenants().get(0));
                debitFormat.save();
                formats.add(debitFormat);
            }
        }
        return formats;
    }
}

