/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.payments.api.AddressPropertyHandler;
import de.businesslogics.banking.payments.api.OriginatorData;
import de.businesslogics.format.AddressData;
import java.io.IOException;
import java.util.Properties;

public final class SepaOriginatorData
extends OriginatorData {
    private String creditorId;
    private String taxNumber;
    private AddressData address;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
        this.setName(properties.getProperty(OriginatorData.MultiwebPropertiesKeys.NAME.name()));
        this.setCreditorId(properties.getProperty(OriginatorData.MultiwebPropertiesKeys.CREDITOR_ID.name()));
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.SEPA;
    }

    @Override
    protected void loadOriginatorInfo() throws IOException {
        Properties properties = this.loadOriginatorInfoProperties();
        this.creditorId = properties.getProperty(PropertiesKeys.CREDITOR_ID.getKey());
        this.taxNumber = properties.getProperty(PropertiesKeys.TAX_NUMBER.getKey());
        this.address = AddressPropertyHandler.getAddressData(properties);
    }

    @Override
    protected void buildOriginatorInfo() throws IOException {
        Properties properties = new Properties();
        this.setProperty(properties, PropertiesKeys.CREDITOR_ID, this.creditorId);
        this.setProperty(properties, PropertiesKeys.TAX_NUMBER, this.taxNumber);
        AddressPropertyHandler.setAddressData(this.address, properties);
        this.setOriginatorInfoProperties(properties);
    }

    public String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public String getTaxNumber() {
        return this.taxNumber;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public AddressData getAddress() {
        return this.address;
    }

    public void setAddress(AddressData address) {
        this.address = address;
    }

    public void addAddress(AddressData newAddress) {
        if (newAddress != null) {
            if (this.address == null) {
                this.address = newAddress;
            } else {
                boolean unstructured;
                boolean bl = unstructured = newAddress.getAddressLines().size() > 0;
                if (unstructured) {
                    this.address.getAddressLines().clear();
                    this.address.getAddressLines().addAll(newAddress.getAddressLines());
                } else {
                    this.address.setDepartment(newAddress.getDepartment());
                    this.address.setSubDepartment(newAddress.getSubDepartment());
                    this.address.setStreetName(newAddress.getStreetName());
                    this.address.setBuildingNumber(newAddress.getBuildingNumber());
                    this.address.setBuildingName(newAddress.getBuildingName());
                    this.address.setFloor(newAddress.getFloor());
                    this.address.setPostCode(newAddress.getPostCode());
                    this.address.setTownName(newAddress.getTownName());
                    this.address.setCountrySubDivision(newAddress.getCountrySubDivision());
                }
                this.address.setCountry(newAddress.getCountry());
            }
        }
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null || value.trim().length() == 0) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value.trim());
        }
    }

    private static enum PropertiesKeys {
        CREDITOR_ID("creditorId"),
        TAX_NUMBER("taxNumber");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

