/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.transfer.api.NotificationSettings;
import de.businesslogics.banking.transfer.api.PreScheduler;
import de.businesslogics.bcs.core.YYMMDD;
import java.util.HashSet;
import java.util.Set;

public final class SepaNotificationPreScheduler
implements PreScheduler {
    @Override
    public Set<String> getOrderOrFileTypes(Scheduler s) {
        NotificationSettings notificationsHandler = NotificationSettings.getForBank(s.getBank());
        HashSet<String> result = new HashSet<String>();
        if (notificationsHandler.fetchCreditNotifications()) {
            result.add(notificationsHandler.getFetchTypeForCreditNotifications());
        }
        if (notificationsHandler.fetchInstantNotifications()) {
            result.add(notificationsHandler.getFetchTypeForInstantNotifications());
        }
        if (notificationsHandler.fetchDebitNotifications()) {
            result.add(notificationsHandler.getFetchTypeForDebitNotifications());
        }
        if (notificationsHandler.fetchCallbackNotifications()) {
            result.add(notificationsHandler.getFetchTypeForCallbackNotifications());
        }
        if (notificationsHandler.fetchForeignNotifications()) {
            result.add(notificationsHandler.getFetchTypeForForeignNotifications());
        }
        if (notificationsHandler.fetchVopNotifications()) {
            result.add(notificationsHandler.getFetchTypeForVopNotifications());
        }
        return result;
    }

    @Override
    public YYMMDD getFromDate(Scheduler s) {
        NotificationSettings notificationsHandler = NotificationSettings.getForBank(s.getBank());
        if (CmBank.FetchMode.NEW.equals((Object)notificationsHandler.getFetchMode())) {
            return null;
        }
        if (notificationsHandler.getLastFetchDate() != null) {
            return new YYMMDD(notificationsHandler.getLastFetchDate().getTime());
        }
        return new YYMMDD();
    }

    @Override
    public YYMMDD getToDate(Scheduler s) {
        return null;
    }

    @Override
    public void setLastFetchDate(Scheduler s, YYMMDD date) {
        NotificationSettings notificationsHandler = NotificationSettings.getForBank(s.getBank());
        notificationsHandler.setLastFetchDate(date);
        notificationsHandler.save();
    }
}

