/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.sepa.SepaDebitType;
import de.businesslogics.banking.api.sepa.SepaSequenceType;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AddressPropertyHandler;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public final class SepaMandateData
extends RecipientData {
    private static final ThreadLocal<SimpleDateFormat> YYYYMMDD = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));
    private static final String SEPARATOR = "|";
    private Date mandateSignDate;
    private SepaSequenceType sequenceType;
    private SepaDebitType mandateType;
    private String creditorId;
    private String creditor;
    private String originalCreditor;
    private String originalCreditorId;
    private String originalMandateId;
    private String originalRecipientIban;
    private String originalRecipientBic;
    private String leiNumber;
    private AddressData address;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.MANDATE;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        String propMandateSignDate = properties.getProperty(PropertiesKeys.MANDATE_SIGN_DATE.getKey());
        if (propMandateSignDate != null && !propMandateSignDate.isEmpty()) {
            try {
                this.mandateSignDate = YYYYMMDD.get().parse(propMandateSignDate);
            }
            catch (ParseException e) {
                throw new IOException("Failed to parse mandate sign date!", e);
            }
        }
        this.sequenceType = SepaSequenceType.getByName(properties.getProperty(PropertiesKeys.SEQUENCE_TYPE.getKey()));
        this.mandateType = SepaDebitType.getByName(properties.getProperty(PropertiesKeys.MANDATE_TYPE.getKey()));
        this.creditorId = properties.getProperty(PropertiesKeys.CREDITOR_ID.getKey());
        this.creditor = properties.getProperty(PropertiesKeys.CREDITOR.getKey());
        this.leiNumber = properties.getProperty(PropertiesKeys.LEI_NUMBER.getKey());
        this.originalCreditor = properties.getProperty(PropertiesKeys.ORIGINAL_CREDITOR.getKey());
        this.originalCreditorId = properties.getProperty(PropertiesKeys.ORIGINAL_CREDITOR_ID.getKey());
        this.originalMandateId = properties.getProperty(PropertiesKeys.ORIGINAL_MANDATE_ID.getKey());
        this.originalRecipientIban = properties.getProperty(PropertiesKeys.ORIGINAL_RECIPIENT_IBAN.getKey());
        this.originalRecipientBic = properties.getProperty(PropertiesKeys.ORIGINAL_RECIPIENT_BIC.getKey());
        this.address = AddressPropertyHandler.getAddressData(properties);
        if (this.address.isEmpty()) {
            String debtorCountry;
            String addressLine2;
            String addressLine1 = StringUtils.checkNullAndTrim(properties.getProperty(PropertiesKeys.DEBTOR_STREET.getKey()));
            if (!addressLine1.isEmpty()) {
                this.address.getAddressLines().add(addressLine1);
            }
            if (!(addressLine2 = StringUtils.checkNullAndTrim(properties.getProperty(PropertiesKeys.DEBTOR_TOWN.getKey()))).isEmpty()) {
                this.address.getAddressLines().add(addressLine2);
            }
            if (!(debtorCountry = StringUtils.checkNullAndTrim(properties.getProperty(PropertiesKeys.DEBTOR_COUNTRY.getKey()))).isEmpty()) {
                this.address.setCountry(debtorCountry);
            }
        }
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        String mandateSignDateString = this.mandateSignDate != null ? YYYYMMDD.get().format(this.mandateSignDate) : null;
        this.setProperty(properties, PropertiesKeys.MANDATE_SIGN_DATE, mandateSignDateString);
        this.setProperty(properties, PropertiesKeys.SEQUENCE_TYPE, this.sequenceType != null ? this.sequenceType.name() : null);
        this.setProperty(properties, PropertiesKeys.MANDATE_TYPE, this.mandateType != null ? this.mandateType.name() : null);
        this.setProperty(properties, PropertiesKeys.CREDITOR_ID, this.creditorId);
        this.setProperty(properties, PropertiesKeys.CREDITOR, this.creditor);
        this.setProperty(properties, PropertiesKeys.ORIGINAL_CREDITOR, this.originalCreditor);
        this.setProperty(properties, PropertiesKeys.ORIGINAL_CREDITOR_ID, this.originalCreditorId);
        this.setProperty(properties, PropertiesKeys.ORIGINAL_MANDATE_ID, this.originalMandateId);
        this.setProperty(properties, PropertiesKeys.ORIGINAL_RECIPIENT_IBAN, this.originalRecipientIban);
        this.setProperty(properties, PropertiesKeys.ORIGINAL_RECIPIENT_BIC, this.originalRecipientBic);
        AddressPropertyHandler.setAddressData(this.address, properties);
        this.setProperty(properties, PropertiesKeys.LEI_NUMBER, this.leiNumber);
        this.setRecipientInfoProperties(properties);
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            SepaMandateData original = new SepaMandateData();
            original.setPaymentRecipient(originalVo);
            if (StringUtils.valuesDiffer(this.creditor, original.getCreditor())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.creditorId, original.getCreditorId())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.getPaymentRecipient().getSepaMandateId(), originalVo.getSepaMandateId())) {
                return true;
            }
            if (!SepaMandateData.toString(this.mandateSignDate).equals(SepaMandateData.toString(original.getMandateSignDate()))) {
                return true;
            }
            if (!SepaMandateData.toString(this.mandateType).equals(SepaMandateData.toString(original.getMandateType()))) {
                return true;
            }
            if (!this.toString(this.sequenceType).equals(this.toString(original.getSequenceType()))) {
                return true;
            }
            if (!AddressData.areEqual(this.address, original.getAddress())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.leiNumber, original.getLeiNumber())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String toString(Date date) {
        if (date == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(date);
    }

    private static String toString(SepaDebitType type) {
        if (type == null) {
            return "";
        }
        return type.name();
    }

    private String toString(SepaSequenceType type) {
        if (type == null) {
            return "";
        }
        return type.name();
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
        if (withHeader) {
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payee", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.creditorId", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payer", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.iban", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.bic", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.mandateReference", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.mandateSignDate", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.debitType", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.sequenceType", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payerStreet", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payerPlace", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payerCountry", new Object[0]), false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.bank", new Object[0]), true, columnSeparator, lineSeparator);
        }
        SepaMandateData.writeCsvFieldToWriter(writer, this.getDisplayName(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getCreditor(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getCreditorId(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getName(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getAccountNumber(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getBankCode(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getPurpose(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getPaymentRecipient().getSepaMandateId(), false, columnSeparator, lineSeparator);
        if (this.getMandateSignDate() != null) {
            SepaMandateData.writeCsvFieldToWriter(writer, YYYYMMDD.get().format(this.getMandateSignDate()), false, columnSeparator, lineSeparator);
        } else {
            SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
        }
        SepaMandateData.writeCsvFieldToWriter(writer, this.getMandateType() != null ? this.getMandateType().name() : SepaDebitType.CORE.name(), false, columnSeparator, lineSeparator);
        SepaMandateData.writeCsvFieldToWriter(writer, this.getSequenceType() != null ? this.getSequenceType().name() : SepaSequenceType.OOFF.name(), false, columnSeparator, lineSeparator);
        if (this.address != null) {
            AddressData unstructuredAddress = AddressData.convertToDKSepaAddress(this.address);
            List<String> addressLines = unstructuredAddress.getAddressLines();
            if (addressLines.size() >= 2) {
                SepaMandateData.writeCsvFieldToWriter(writer, addressLines.get(0), false, columnSeparator, lineSeparator);
                SepaMandateData.writeCsvFieldToWriter(writer, addressLines.get(1), false, columnSeparator, lineSeparator);
                SepaMandateData.writeCsvFieldToWriter(writer, this.address.getCountry(), false, columnSeparator, lineSeparator);
            } else if (addressLines.size() == 1) {
                SepaMandateData.writeCsvFieldToWriter(writer, addressLines.getFirst(), false, columnSeparator, lineSeparator);
                SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
                SepaMandateData.writeCsvFieldToWriter(writer, this.address.getCountry(), false, columnSeparator, lineSeparator);
            } else {
                SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
                SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
                SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
            }
        } else {
            SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
            SepaMandateData.writeCsvFieldToWriter(writer, null, false, columnSeparator, lineSeparator);
        }
        SepaMandateData.writeCsvFieldToWriter(writer, this.getBankName(), true, columnSeparator, lineSeparator);
    }

    public Date getMandateSignDate() {
        return this.mandateSignDate;
    }

    public void setMandateSignDate(Date mandateSignDate) {
        this.mandateSignDate = mandateSignDate;
    }

    public SepaSequenceType getSequenceType() {
        return this.sequenceType;
    }

    public void setSequenceType(SepaSequenceType sequenceType) {
        this.sequenceType = sequenceType;
    }

    public SepaDebitType getMandateType() {
        return this.mandateType;
    }

    public void setMandateType(SepaDebitType mandateType) {
        this.mandateType = mandateType;
    }

    public String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public String getCreditor() {
        return this.creditor;
    }

    public void setCreditor(String creditor) {
        this.creditor = creditor;
    }

    public String getOriginalCreditor() {
        return this.originalCreditor;
    }

    public void setOriginalCreditor(String originalCreditor) {
        this.originalCreditor = originalCreditor;
    }

    public String getOriginalCreditorId() {
        return this.originalCreditorId;
    }

    public void setOriginalCreditorId(String originalCreditorId) {
        this.originalCreditorId = originalCreditorId;
    }

    public String getOriginalMandateId() {
        return this.originalMandateId;
    }

    public void setOriginalMandateId(String originalMandateId) {
        this.originalMandateId = originalMandateId;
    }

    public String getOriginalRecipientIban() {
        return this.originalRecipientIban;
    }

    public void setOriginalRecipientIban(String originalRecipientIban) {
        this.originalRecipientIban = originalRecipientIban;
    }

    public String getOriginalRecipientBic() {
        return this.originalRecipientBic;
    }

    public void setOriginalRecipientBic(String originalRecipientBic) {
        this.originalRecipientBic = originalRecipientBic;
    }

    public AddressData getAddress() {
        return this.address;
    }

    public void setAddress(AddressData address) {
        this.address = address;
    }

    @Deprecated
    public String getDebtorStreet() {
        if (this.address != null && this.address.getAddressLines() != null && !this.address.getAddressLines().isEmpty()) {
            return this.address.getAddressLines().getFirst();
        }
        return null;
    }

    @Deprecated
    public void setDebtorStreet(String debtorStreet) {
        String s = StringUtils.checkNullAndTrim(debtorStreet);
        if (this.address == null) {
            this.address = new AddressData();
        }
        if (!this.address.getAddressLines().isEmpty()) {
            if (!s.isEmpty()) {
                this.address.getAddressLines().set(0, s);
            } else {
                this.address.getAddressLines().removeFirst();
            }
        } else if (!s.isEmpty()) {
            this.address.getAddressLines().add(s);
        }
    }

    @Deprecated
    public String getDebtorTown() {
        if (this.address != null && this.address.getAddressLines() != null && this.address.getAddressLines().size() > 1) {
            return this.address.getAddressLines().get(1);
        }
        return null;
    }

    @Deprecated
    public void setDebtorTown(String debtorTown) {
        String s = StringUtils.checkNullAndTrim(debtorTown);
        if (this.address == null) {
            this.address = new AddressData();
        }
        if (this.address.getAddressLines().size() > 1) {
            if (s.length() > 1) {
                this.address.getAddressLines().set(1, s);
            } else {
                this.address.getAddressLines().remove(1);
            }
        } else if (!s.isEmpty()) {
            this.address.getAddressLines().add(s);
        }
    }

    @Deprecated
    public String getDebtorCountry() {
        if (this.address != null && this.address.getCountry() != null) {
            return this.address.getCountry();
        }
        String accNumber = this.getAccountNumber();
        if (IbanUtil.checkIban(accNumber)) {
            return IbanUtil.getCountryCode(accNumber);
        }
        return null;
    }

    @Deprecated
    public void setDebtorCountry(String debtorCountry) {
        if (this.address == null) {
            this.address = new AddressData();
        }
        this.address.setCountry(debtorCountry);
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    public String getLeiNumber() {
        return this.leiNumber;
    }

    public void setLeiNumber(String leiNumber) {
        this.leiNumber = leiNumber;
    }

    public String getMandateRepresentation() {
        return StringUtils.checkNullAndTrim(this.getPaymentRecipient().getSepaMandateId()) + SEPARATOR + SepaMandateData.toString(this.mandateSignDate) + SEPARATOR + SepaMandateData.toString(this.mandateType) + SEPARATOR + StringUtils.checkNullAndTrim(this.creditor) + SEPARATOR + StringUtils.checkNullAndTrim(this.creditorId) + SEPARATOR + StringUtils.checkNullAndTrim(this.getPaymentRecipient().getName()) + SEPARATOR + StringUtils.checkNullAndTrim(this.getPaymentRecipient().getAccountNumber()) + SEPARATOR + StringUtils.checkNullAndTrim(this.getPaymentRecipient().getBankCode());
    }

    public static String getMandateRepresentation(SEPAPaymentData payment) {
        return StringUtils.checkNullAndTrim(payment.getMandateId()) + SEPARATOR + SepaMandateData.toString(payment.getMandateSignDate()) + SEPARATOR + StringUtils.checkNullAndTrim(payment.getDebitType()) + SEPARATOR + StringUtils.checkNullAndTrim(payment.getOriginator()) + SEPARATOR + StringUtils.checkNullAndTrim(payment.getCreditorId()) + SEPARATOR + StringUtils.checkNullAndTrim(payment.getRecipient()) + SEPARATOR + StringUtils.checkNullAndTrim(payment.getRecipientIban()) + SEPARATOR + StringUtils.checkNullAndTrim(payment.getRecipientBic());
    }

    public void createFromPayment(BLLogger logger, BankSettings bank, SEPAPaymentData payment) {
        String displayName = RecipientData.getUniqueDisplayName(payment.getRecipient(), PaymentType.MANDATE, bank.getTenant());
        this.setDisplayName(displayName);
        this.setTenant(bank.getTenant());
        this.setDataFromPayment(payment);
        if (logger != null) {
            String msg = "Created mandate " + displayName + ": " + this.getMandateRepresentation();
            logger.logInfo(msg);
        }
    }

    public void updateFromPayment(BLLogger logger, SEPAPaymentData payment) {
        String existingMandate = this.getMandateRepresentation();
        this.setDataFromPayment(payment);
        String updatedMandate = this.getMandateRepresentation();
        if (!existingMandate.equals(updatedMandate) && logger != null) {
            String msg = "Updated mandate " + this.getDisplayName() + " with mandateID " + this.getPaymentRecipient().getSepaMandateId() + " from " + existingMandate + " to " + updatedMandate;
            logger.logInfo(msg);
        }
    }

    private void setDataFromPayment(SEPAPaymentData payment) {
        this.getPaymentRecipient().setSepaMandateId(payment.getMandateId());
        this.mandateSignDate = payment.getMandateSignDate();
        this.mandateType = SepaDebitType.getByName(payment.getDebitType());
        this.sequenceType = SepaSequenceType.getByName(payment.getSequenceType());
        this.creditor = payment.getOriginator();
        this.creditorId = payment.getCreditorId();
        this.setName(payment.getRecipient());
        this.setAccountNumber(payment.getRecipientIban());
        this.setBankCode(payment.getRecipientBic());
        this.setAddress(payment.getRecipientAddressData());
        if (payment.hasStructuredPurpose()) {
            this.setPurpose(null);
            this.setReference(payment.getPurposeReference());
        } else {
            this.setPurpose(payment.getPurpose());
            this.setReference(null);
        }
    }

    private static enum PropertiesKeys {
        MANDATE_SIGN_DATE("mandateSignDate"),
        SEQUENCE_TYPE("sequenceType"),
        MANDATE_TYPE("mandateType"),
        CREDITOR_ID("creditorId"),
        CREDITOR("creditor"),
        ORIGINAL_CREDITOR("originalCreditor"),
        ORIGINAL_CREDITOR_ID("originalCreditorId"),
        ORIGINAL_MANDATE_ID("originalMandateId"),
        ORIGINAL_RECIPIENT_IBAN("originalRecipientIban"),
        ORIGINAL_RECIPIENT_BIC("originalRecipientBic"),
        DEBTOR_STREET("debtorStreet"),
        DEBTOR_TOWN("debtorTown"),
        DEBTOR_COUNTRY("debtorCountry"),
        LEI_NUMBER("lei");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

