/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AddressPropertyHandler;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;

public final class SepaForeignRecipientData
extends RecipientData {
    private AddressData address;
    private AddressData bankAddress;
    private String clearingSystemId;
    private String feeType;
    private String leiNumber;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.SEPA_FOREIGN;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        this.address = AddressPropertyHandler.getAddressData(properties);
        this.bankAddress = AddressPropertyHandler.getBankAddressData(properties);
        this.clearingSystemId = properties.getProperty(PropertiesKeys.CLR_SYS_ID.getKey());
        this.feeType = properties.getProperty(PropertiesKeys.FEE_TYPE.getKey());
        this.leiNumber = properties.getProperty(PropertiesKeys.LEI_NUMBER.getKey());
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        AddressPropertyHandler.setAddressData(this.address, properties);
        AddressPropertyHandler.setBankAddressData(this.bankAddress, properties);
        this.setProperty(properties, PropertiesKeys.CLR_SYS_ID, this.clearingSystemId);
        this.setProperty(properties, PropertiesKeys.FEE_TYPE, this.feeType);
        this.setProperty(properties, PropertiesKeys.LEI_NUMBER, this.leiNumber);
        this.setRecipientInfoProperties(properties);
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            SepaForeignRecipientData original = new SepaForeignRecipientData();
            original.setPaymentRecipient(originalVo);
            if (!AddressData.areEqual(this.address, original.getAddress())) {
                return true;
            }
            if (!AddressData.areEqual(this.bankAddress, original.getBankAddress())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.getClearingSystemId(), original.getClearingSystemId())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.feeType, original.getFeeType())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.leiNumber, original.getLeiNumber())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
        if (withHeader) {
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.address", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.departement", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.subDepartement", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.buildingNumber", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.buildingName", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.floor", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.town", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.postCode", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.subCountry", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.country", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.accountNumberIban", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.clearingSystem", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.bankCodeBic", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.feeType", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.bank", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.bankAddress", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.departement", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.subDepartement", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.buildingNumber", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.buildingName", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.floor", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.town", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.postCode", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.subCountry", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.country", new Object[0]), false, columnSeparator, lineSeparator);
            SepaForeignRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), true, columnSeparator, lineSeparator);
        }
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getDisplayName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddressAsString(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getDepartment(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getSubDepartment(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getStreetName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getBuildingNumber(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getBuildingName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getFloor(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getTownName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getPostCode(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getCountrySubDivision(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getCountry(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getAccountNumber(), false, columnSeparator, lineSeparator);
        String clearingSys = this.getClearingSystemId();
        if (clearingSys == null) {
            clearingSys = "BIC";
        }
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, clearingSys, false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankCode(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getFeeType(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddressAsString(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getDepartment(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getSubDepartment(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getStreetName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getBuildingNumber(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getBuildingName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getFloor(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getTownName(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getPostCode(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankAddress().getCountrySubDivision(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getBankCountry(), false, columnSeparator, lineSeparator);
        SepaForeignRecipientData.writeCsvFieldToWriter(writer, this.getPurpose(), true, columnSeparator, lineSeparator);
    }

    public AddressData getAddress() {
        return this.address;
    }

    public void setAddress(AddressData address) {
        this.address = address;
    }

    public void addAddress(AddressData newAddress) {
        if (newAddress != null) {
            if (this.address == null) {
                this.address = newAddress;
            } else {
                boolean unstructured;
                boolean bl = unstructured = newAddress.getAddressLines().size() > 0;
                if (unstructured) {
                    this.address.getAddressLines().clear();
                    this.address.getAddressLines().addAll(newAddress.getAddressLines());
                } else {
                    this.address.setDepartment(newAddress.getDepartment());
                    this.address.setSubDepartment(newAddress.getSubDepartment());
                    this.address.setStreetName(newAddress.getStreetName());
                    this.address.setBuildingNumber(newAddress.getBuildingNumber());
                    this.address.setBuildingName(newAddress.getBuildingName());
                    this.address.setFloor(newAddress.getFloor());
                    this.address.setPostCode(newAddress.getPostCode());
                    this.address.setTownName(newAddress.getTownName());
                    this.address.setCountrySubDivision(newAddress.getCountrySubDivision());
                }
                this.address.setCountry(newAddress.getCountry());
            }
        }
    }

    public AddressData getBankAddress() {
        return this.bankAddress;
    }

    public void setBankAddress(AddressData bankAddress) {
        this.bankAddress = bankAddress;
    }

    public void addBankAddress(AddressData newAddress) {
        if (newAddress != null) {
            if (this.bankAddress == null) {
                this.bankAddress = newAddress;
            } else {
                boolean unstructured;
                boolean bl = unstructured = newAddress.getAddressLines().size() > 0;
                if (unstructured) {
                    this.bankAddress.getAddressLines().clear();
                    this.bankAddress.getAddressLines().addAll(newAddress.getAddressLines());
                } else {
                    this.bankAddress.setDepartment(newAddress.getDepartment());
                    this.bankAddress.setSubDepartment(newAddress.getSubDepartment());
                    this.bankAddress.setStreetName(newAddress.getStreetName());
                    this.bankAddress.setBuildingNumber(newAddress.getBuildingNumber());
                    this.bankAddress.setBuildingName(newAddress.getBuildingName());
                    this.bankAddress.setFloor(newAddress.getFloor());
                    this.bankAddress.setPostCode(newAddress.getPostCode());
                    this.bankAddress.setTownName(newAddress.getTownName());
                    this.bankAddress.setCountrySubDivision(newAddress.getCountrySubDivision());
                }
                this.bankAddress.setCountry(newAddress.getCountry());
            }
        }
    }

    public String getClearingSystemId() {
        return this.clearingSystemId;
    }

    public void setClearingSystemId(String clearingSystemId) {
        this.clearingSystemId = clearingSystemId;
    }

    private String getCountry() {
        if (this.address != null) {
            return this.address.getCountry();
        }
        return null;
    }

    private String getBankCountry() {
        if (this.bankAddress != null) {
            return this.bankAddress.getCountry();
        }
        return null;
    }

    public String getFeeType() {
        if (this.feeType == null) {
            return "";
        }
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getLeiNumber() {
        return this.leiNumber;
    }

    public void setLeiNumber(String leiNumber) {
        this.leiNumber = leiNumber;
    }

    private String getAddressAsString() {
        return SepaForeignRecipientData.getAddressAsString(this.address);
    }

    private String getBankAddressAsString() {
        return SepaForeignRecipientData.getAddressAsString(this.bankAddress);
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        CLR_SYS_ID("clrSysId"),
        FEE_TYPE("feeType"),
        LEI_NUMBER("lei");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

