/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.sepa.api.SepaApiMessages;
import java.util.Locale;

public final class SepaCallbackException
extends Exception {
    private static final long serialVersionUID = -4415567867993518040L;
    private Errors error;

    public String getTitle(Locale locale) {
        return SepaApiMessages.getString(locale, "callback.callbackNotPossible", new Object[0]);
    }

    public String getMessage(Locale locale) {
        return this.getMessage(locale, false);
    }

    public String getMessage(Locale locale, boolean isBLBanking) {
        if (Errors.ORDER_MULTIPLE_LOGICAL_FILES.equals((Object)this.error)) {
            if (isBLBanking) {
                return SepaApiMessages.getString(locale, "callback.orderMultipleLogicalFiles2", new Object[0]);
            }
            return SepaApiMessages.getString(locale, "callback.orderMultipleLogicalFiles", new Object[0]);
        }
        if (Errors.PAYMENTS_MULTIPLE_LOGICAL_FILES.equals((Object)this.error)) {
            return SepaApiMessages.getString(locale, "callback.paymentsMultipleLogicalFiles", new Object[0]);
        }
        if (Errors.PAYMENTS_NOT_FOUND.equals((Object)this.error)) {
            return SepaApiMessages.getString(locale, "callback.paymentsNotFound", new Object[0]);
        }
        if (Errors.SALARY_PAYMENTS_FOUND.equals((Object)this.error)) {
            return SepaApiMessages.getString(locale, "callback.salaryPaymentsFound", new Object[0]);
        }
        if (Errors.GENERAL.equals((Object)this.error)) {
            return SepaApiMessages.getString(locale, "callback.generalError", this.getMessage());
        }
        return "Unexpected error = " + this.getMessage();
    }

    public SepaCallbackException(Errors error) {
        this.error = error;
    }

    public SepaCallbackException(Throwable cause) {
        super(cause);
        this.error = Errors.GENERAL;
    }

    public Errors getError() {
        return this.error;
    }

    public static enum Errors {
        GENERAL,
        ORDER_MULTIPLE_LOGICAL_FILES,
        PAYMENTS_MULTIPLE_LOGICAL_FILES,
        PAYMENTS_NOT_FOUND,
        SALARY_PAYMENTS_FOUND;

    }
}

