/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.payments.api.AbstractBankOrder;
import de.businesslogics.banking.payments.api.BankOrderCallback;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.sepa.api.SepaCallbackException;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPACallbackGenerator;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.SAXException;

public class SepaCallbackApi {
    public static SEPALogicalFile getLogicalFile(File sepaFile, boolean isCreditFile, EncryptData encryption, BLLogger logger) throws SepaCallbackException {
        List<SEPALogicalFile> logicalFiles = SepaCallbackApi.getLogicalFiles(sepaFile, isCreditFile, encryption, logger);
        if (logicalFiles != null && logicalFiles.size() == 1) {
            SEPALogicalFile logicalFile = logicalFiles.get(0);
            return logicalFile;
        }
        throw new SepaCallbackException(SepaCallbackException.Errors.ORDER_MULTIPLE_LOGICAL_FILES);
    }

    private static List<SEPALogicalFile> getLogicalFiles(File sepaFile, boolean isCreditFile, EncryptData encryption, BLLogger logger) throws SepaCallbackException {
        List<SEPALogicalFile> logicalFiles = null;
        InputStream in = null;
        try {
            in = encryption.openInputStream(sepaFile);
            List<SEPALogicalFile> list = logicalFiles = isCreditFile ? GeneralSEPAExtractor.getLogicalFilesFromCCT(in) : GeneralSEPAExtractor.getLogicalFilesFromDebit(in);
            return list;
        }
        catch (Exception e) {
            logger.logError("Error in SepaCallbackApi.getLogicalFiles()", e);
            throw new SepaCallbackException(e);
        }
        finally {
            SystemUtils.close(in);
        }
    }

    public static Map<SEPALogicalFile, List<SEPAPaymentData>> getPaymentsMap(File sepaFile, boolean isCreditFile, EncryptData encryption, List<SignedPayment> signedPayments, BLLogger logger) throws SepaCallbackException {
        List<SEPALogicalFile> logicalFiles = SepaCallbackApi.getLogicalFiles(sepaFile, isCreditFile, encryption, logger);
        int logicalFileNumber = 0;
        SEPALogicalFile logicalFile = null;
        List<SEPAPaymentData> paymentsFromLogicalFile = null;
        ArrayList<SEPAPaymentData> paymentsToCallback = new ArrayList<SEPAPaymentData>();
        for (SignedPayment signedPayment : signedPayments) {
            PaymentPosition position = SepaCallbackApi.getPaymentPosition(signedPayment, logicalFiles, logger);
            if (logicalFileNumber == 0) {
                logicalFileNumber = position.getLogicalFileNumber();
                logicalFile = logicalFiles.get(logicalFileNumber - 1);
                paymentsFromLogicalFile = logicalFile.getTransactions();
            } else if (logicalFileNumber != position.getLogicalFileNumber()) {
                throw new SepaCallbackException(SepaCallbackException.Errors.PAYMENTS_MULTIPLE_LOGICAL_FILES);
            }
            if (position.getPaymentNumber() > paymentsFromLogicalFile.size()) {
                logger.logError("Error in SepaCallbackApi.getPaymentsMap(): Invalid value in database. PaymentNumber=" + position.getPaymentNumber() + " is larger than number of payments in logical file=" + paymentsFromLogicalFile.size());
                throw new SepaCallbackException(SepaCallbackException.Errors.PAYMENTS_NOT_FOUND);
            }
            paymentsToCallback.add(paymentsFromLogicalFile.get(position.getPaymentNumber() - 1));
        }
        if (logicalFile != null && paymentsToCallback.size() > 0) {
            HashMap<SEPALogicalFile, List<SEPAPaymentData>> paymentsMap = new HashMap<SEPALogicalFile, List<SEPAPaymentData>>();
            paymentsMap.put(logicalFile, paymentsToCallback);
            return paymentsMap;
        }
        logger.logError("Error in SepaCallbackApi.getPaymentsMap(): Payments not found in order file");
        throw new SepaCallbackException(SepaCallbackException.Errors.PAYMENTS_NOT_FOUND);
    }

    private static PaymentPosition getPaymentPosition(SignedPayment signedPayment, List<SEPALogicalFile> logicalFiles, BLLogger logger) throws SepaCallbackException {
        Integer logicalFileId = signedPayment.getLogicalFile();
        Integer paymentNumber = signedPayment.getPaymentNumber();
        if (logicalFileId != null && logicalFileId > 0 && paymentNumber != null && paymentNumber > 0) {
            if (logicalFileId > logicalFiles.size()) {
                logger.logError("Error in SepaCallbackApi.getPaymentPosition(): Invalid value in database. LogicalFileNumber=" + logicalFileId + " is larger than number of logical file=" + logicalFiles.size());
                throw new SepaCallbackException(SepaCallbackException.Errors.PAYMENTS_NOT_FOUND);
            }
            return new PaymentPosition(logicalFileId, paymentNumber);
        }
        int logicalFilePosition = 1;
        for (SEPALogicalFile logicalFile : logicalFiles) {
            int paymentPosition = SepaCallbackApi.getPaymentPosition(signedPayment, logicalFile);
            if (paymentPosition > 0) {
                return new PaymentPosition(logicalFilePosition, paymentPosition);
            }
            ++logicalFilePosition;
        }
        logger.logError("Error in SepaCallbackApi.getPaymentPosition(): Payment with reference=" + signedPayment.getReference() + ", recipient='" + signedPayment.getRecipient() + "' and purpose=' " + signedPayment.getPurpose() + "' could not be found in order file");
        throw new SepaCallbackException(SepaCallbackException.Errors.PAYMENTS_NOT_FOUND);
    }

    private static int getPaymentPosition(SignedPayment signedPayment, SEPALogicalFile logicalFile) {
        String endToEndId = signedPayment.getReference();
        BigDecimal amount = signedPayment.getAmount();
        String currency = signedPayment.getAmountCurrency();
        String purpose = signedPayment.getPurpose();
        String recipient = signedPayment.getRecipient();
        String account = StringUtils.checkNullAndTrim(signedPayment.getAccount().getIban()).replaceAll(" ", "");
        List<SEPAPaymentData> transactions = logicalFile.getTransactions();
        int countTransactions = transactions.size();
        for (int i = 0; i < countTransactions; ++i) {
            SEPAPaymentData transaction = transactions.get(i);
            if (!endToEndId.equals(transaction.getEndToEndId()) || amount.compareTo(transaction.getAmount()) != 0 || currency == null || !currency.equals(transaction.getCurrency().getCurrencyCode()) || !SepaCallbackApi.compare(purpose, transaction.getPurpose()) || !recipient.equals(transaction.getRecipient()) || !account.equals(transaction.getOriginatorIban())) continue;
            return i + 1;
        }
        return -1;
    }

    private static boolean compare(String s1, String s2) {
        if (StringUtils.isEmpty(s1)) {
            return StringUtils.isEmpty(s2);
        }
        if (StringUtils.isEmpty(s2)) {
            return false;
        }
        return s1.trim().equals(s2.trim());
    }

    public static void checkForSalaryPayments(boolean displayAmounts, List<SignedPayment> signedPayments, BLLogger logger) throws SepaCallbackException {
        if (!displayAmounts && signedPayments != null) {
            for (SignedPayment signedPayment : signedPayments) {
                if (!signedPayment.isSalaryPayment()) continue;
                throw new SepaCallbackException(SepaCallbackException.Errors.SALARY_PAYMENTS_FOUND);
            }
        }
    }

    public static String checkForOriginatorBic(SEPALogicalFile logicalFile, Locale locale) {
        String bic;
        List<SEPAPaymentData> transactions = logicalFile.getTransactions();
        if (transactions != null && transactions.size() > 0 && (bic = transactions.get(0).getOriginatorBic()) != null && bic.length() >= 8) {
            return null;
        }
        return SepaApiMessages.getString(locale, "callback.originatorBicDialogMessage", new Object[0]);
    }

    public static String checkForDoubleCallback(Send send, List<SignedPayment> signedPayments, Locale locale) {
        if (signedPayments != null && signedPayments.size() > 0) {
            return SepaCallbackApi.checkForDoubleCallback(signedPayments, locale);
        }
        return SepaCallbackApi.checkForDoubleCallback(send, locale);
    }

    private static String checkForDoubleCallback(Send send, Locale locale) {
        Send callback = send.getCallback();
        if (callback != null) {
            int countWithCallback;
            String orderNumber = callback.getOrderNumber();
            int count = SignedPayment.findCountBySend(send);
            if (count == (countWithCallback = SignedPayment.findCountBySendWithCallbackFlag(send))) {
                return SepaApiMessages.getString(locale, "callback.callbackExistsForOrder", orderNumber);
            }
            if (countWithCallback == 1) {
                return SepaApiMessages.getString(locale, "callback.callbackExistsForOnePayment", orderNumber);
            }
            return SepaApiMessages.getString(locale, "callback.callbackExistsForMultiplePayments", orderNumber);
        }
        return null;
    }

    private static String checkForDoubleCallback(List<SignedPayment> signedPayments, Locale locale) {
        Send callbackJob;
        int countPaymentsWithCallback = 0;
        HashSet<Send> callbackJobs = new HashSet<Send>();
        for (SignedPayment signedPayment : signedPayments) {
            if (signedPayment.getCallback() == null) continue;
            callbackJobs.add(signedPayment.getCallback());
            ++countPaymentsWithCallback;
        }
        if (countPaymentsWithCallback == 1) {
            callbackJob = (Send)callbackJobs.iterator().next();
            if (signedPayments.size() == 1) {
                return SepaApiMessages.getString(locale, "callback.callbackExistsForSelectedPayment", callbackJob.getOrderType(), callbackJob.getOrderNumber());
            }
            return SepaApiMessages.getString(locale, "callback.callbackExistsForOneSelectedPayment", callbackJob.getOrderType(), callbackJob.getOrderNumber());
        }
        if (countPaymentsWithCallback > 1) {
            if (signedPayments.size() == countPaymentsWithCallback) {
                if (callbackJobs.size() == 1) {
                    callbackJob = (Send)callbackJobs.iterator().next();
                    return SepaApiMessages.getString(locale, "callback.callbackExistsForAllSelectedPayments", callbackJob.getOrderType(), callbackJob.getOrderNumber());
                }
                return SepaApiMessages.getString(locale, "callback.callbackExistsForAllSelectedPayments2", new Object[0]);
            }
            if (callbackJobs.size() == 1) {
                callbackJob = (Send)callbackJobs.iterator().next();
                return SepaApiMessages.getString(locale, "callback.callbackExistsForSomeSelectedPayments", callbackJob.getOrderType(), callbackJob.getOrderNumber());
            }
            return SepaApiMessages.getString(locale, "callback.callbackExistsForSomeSelectedPayments2", new Object[0]);
        }
        return null;
    }

    public static <BankOrderType extends AbstractBankOrder> List<BankOrderType> createBankOrders(BankUser bankUser, BankOrderCallback<BankOrderType> bankOrderCallback, SEPACallbackGenerator.CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, SEPALogicalFile logicalFile, List<SEPAPaymentData> payments) throws DisplayFileException, KnownFormatException, IOException, InvalidPasswordException, SAXException {
        return SepaCallbackApi.createBankOrders(bankUser, bankOrderCallback, callbackReasonCode, additionalCallbackInfo, logicalFile, payments, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <BankOrderType extends AbstractBankOrder> List<BankOrderType> createBankOrders(BankUser bankUser, BankOrderCallback<BankOrderType> bankOrderCallback, SEPACallbackGenerator.CallbackReasonCode callbackReasonCode, String additionalCallbackInfo, SEPALogicalFile logicalFile, List<SEPAPaymentData> payments, String originatorBic) throws DisplayFileException, KnownFormatException, IOException, InvalidPasswordException, SAXException {
        ArrayList<BankOrderType> arrayList;
        BankSettings bank = bankUser.getBank();
        SEPAPaymentData firstPayment = logicalFile.getTransactions().get(0);
        PaymentTransferType.PmtType pmtType = SepaCallbackApi.getCallbackPmtType(firstPayment.isCredit());
        String transferType = SendParameters.getTransferTypeByBank(bank, pmtType);
        String callbackMessageId = SepaApi.getMessageId(bankUser);
        File c55File = AbstractBankOrder.createOrderFile(bank.getUniqueKey(), transferType, null);
        CountingFilterOutputStream out = null;
        try {
            out = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(c55File));
            SEPACallbackGenerator.createCamt055Callback(callbackMessageId, callbackReasonCode, additionalCallbackInfo, logicalFile, payments, originatorBic, out);
            long orderDataSize = c55File.length();
            ArrayList<BankOrderType> bankOrders = new ArrayList<BankOrderType>();
            bankOrders.add(bankOrderCallback.createBankOrder(bankUser.getBank(), pmtType, transferType, c55File, orderDataSize));
            arrayList = bankOrders;
        }
        catch (Throwable throwable) {
            SystemUtils.close(out);
            throw throwable;
        }
        SystemUtils.close(out);
        return arrayList;
    }

    private static PaymentTransferType.PmtType getCallbackPmtType(boolean hasCreditPayments) {
        return hasCreditPayments ? PaymentTransferType.PmtType.C55_CALLBACK : PaymentTransferType.PmtType.C55_SDD_CALLBACK;
    }

    private static PaymentTransferType.PmtType getCallbackPmtType(Send send) {
        return SepaCallbackApi.getCallbackPmtType(!PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT.equals((Object)send.getPmtType()) && !PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT.equals((Object)send.getPmtType()));
    }

    public static boolean isCallbackAllowed(boolean allowForAllStates, Send sendItem) {
        return !(sendItem.getFile() == null || sendItem.getPmtType() != null && !SepaApi.isPain001OrPain008PmtType(sendItem.getPmtType()) || !allowForAllStates && Send.State.FINISHED_OK != sendItem.getState());
    }

    public static boolean hasUserAnyCallbackPermissions(User user) {
        for (BankUser bankUser : BankUser.findActiveBanksForUser(user)) {
            if (BankUserHtdInfo.findForBankUser(bankUser) == null) {
                return true;
            }
            BankSettings bank = bankUser.getBank();
            String transferType1 = SendParameters.getTransferTypeByBank(bank, PaymentTransferType.PmtType.C55_CALLBACK);
            if (Util.isOrderType(transferType1) ? UserPermission.hasPermissionForOrderType(bankUser, OrderType.TransferType.SEND, transferType1) : UserPermission.hasPermissionForFileFormat(bankUser, OrderType.TransferType.SEND, transferType1)) {
                return true;
            }
            String transferType2 = SendParameters.getTransferTypeByBank(bank, PaymentTransferType.PmtType.C55_SDD_CALLBACK);
            if (!(Util.isOrderType(transferType2) ? UserPermission.hasPermissionForOrderType(bankUser, OrderType.TransferType.SEND, transferType2) : UserPermission.hasPermissionForFileFormat(bankUser, OrderType.TransferType.SEND, transferType2))) continue;
            return true;
        }
        return false;
    }

    public static String checkSepaCallbackPermission(User user, Send send, Locale locale) {
        BankSettings bank = send.getBank();
        BankUser bankUser = BankUser.findBankUser(bank, user);
        if (BankUserHtdInfo.findForBankUser(bankUser) != null) {
            PaymentTransferType.PmtType callbackPmtType = SepaCallbackApi.getCallbackPmtType(send);
            String transferType = SendParameters.getTransferTypeByBank(bank, callbackPmtType);
            if (Util.isOrderType(transferType)) {
                if (!UserPermission.hasPermissionForOrderType(bankUser, OrderType.TransferType.SEND, transferType)) {
                    return BankingApiMessages.getString(locale, "GeneralMessages.callbackOrders.noOrderTypePermission", transferType, bank.getDisplayName());
                }
            } else if (!UserPermission.hasPermissionForFileFormat(bankUser, OrderType.TransferType.SEND, transferType)) {
                return BankingApiMessages.getString(locale, "GeneralMessages.callbackOrders.noBTFPermission", transferType, bank.getDisplayName());
            }
        }
        return null;
    }

    private static class PaymentPosition {
        private int logicalFileNumber = 0;
        private int paymentNumber = 0;

        public PaymentPosition(int logicalFileNumber, int paymentNumber) {
            this.logicalFileNumber = logicalFileNumber;
            this.paymentNumber = paymentNumber;
        }

        public int getLogicalFileNumber() {
            return this.logicalFileNumber;
        }

        public int getPaymentNumber() {
            return this.paymentNumber;
        }
    }
}

