/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.AbstractLicenseHandler;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.sepa.SepaDebitType;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.api.sepa.SepaSequenceType;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.payments.api.AbstractBankOrder;
import de.businesslogics.banking.payments.api.BankOrderCallback;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.FileNumberHandler;
import de.businesslogics.banking.payments.api.PaymentApiMessages;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.sepa.ChequeDeliveryCode;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.RegReporting;
import de.businesslogics.format.sepa.RegReportingDetail;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPurposeCode;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.format.sepa.at.AustrianFeeMessageHandler;
import de.businesslogics.format.sepa.at.PostbarPurpose;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.io.CountingFilterOutputStream;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.SAXException;

public final class SepaApi {
    private static final String EUR = "EUR";
    public static final int DEFAULT_MAX_EXECUTION_DATE = 15;
    public static final int DEFAULT_LEAD_TIME_FOR_DEBITS = 1;
    public static final int MIN_MSG_ID = 1;
    public static final int MAX_MSG_ID = 9999;
    public static final String CCT = "CCT";
    public static final String CCT_BTF = "SCT_pain.001";
    public static final String CCU = "CCU";
    public static final String CCU_BTF = "XCT:DE:URG_pain.001";
    public static final String CIP = "CIP";
    public static final String CIP_BTF = "SCI:DE_pain.001";
    public static final String AXZ = "AXZ";
    public static final String AXZ_BTF = "XCT:DE_pain.001";
    public static final String XCT = "XCT";
    public static final String XE2 = "XE2";
    public static final String CDD = "CDD";
    public static final String CDD_BTF = "SDD::COR_pain.008";
    public static final String CDB = "CDB";
    public static final String CDB_BTF = "SDD::B2B_pain.008";
    @Deprecated
    public static final String CD1 = "CD1";
    @Deprecated
    public static final String CD1_BTF = "SDD:BIL:0CD1_pain.008";
    public static final String SEPA_2_x_CREDIT_FILE_TYPE = "pain.001.001.02.sct";
    public static final String SEPA_3_x_CREDIT_FILE_TYPE = "pain.001.001.03.sct";
    public static final String CORE_DEBIT_FILE_TYPE = "pain.008.001.01.sdd";
    public static final String B2B_DEBIT_FILE_TYPE = "pain.008.001.01.sbb";
    public static final PaymentTransferType.PmtType[] PmtTypesForCreditTransferRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SEPA_TRANSFER};
    public static final PaymentTransferType.PmtType[] PmtTypesForUrgentTransferRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER};
    public static final PaymentTransferType.PmtType[] PmtTypesForInstantTransferRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER};
    public static final PaymentTransferType.PmtType[] PmtTypesForForeignTransferRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER};
    public static final PaymentTransferType.PmtType[] PmtTypesForChequePaymentRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE};
    public static final PaymentTransferType.PmtType[] PostbarPmtTypes = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT};
    public static final PaymentTransferType.PmtType[] TaxOfficePmtTypes = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT};
    public static final PaymentTransferType.PmtType[] PmtTypesForESRPaymentRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SWISS_ESR_TRANSFER};
    public static final PaymentTransferType.PmtType[] PmtTypesForES1PaymentRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SWISS_ES1_TRANSFER};
    public static final PaymentTransferType.PmtType[] PmtTypesForES2PaymentRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SWISS_ES2_TRANSFER};
    public static final PaymentTransferType.PmtType[] PmtTypesForSwissTransferRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SWISS_DOMESTIC_TRANSFER_3};
    public static PaymentTransferType.PmtType[] PmtTypesForDirectDebitRecording = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT, PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT};
    public static final String[] CREDIT_ORDER_TYPES = new String[]{"CCT", "XCT", "XE2", "SCT_pain.001"};
    public static final String[] URGENT_CREDIT_ORDER_TYPES = new String[]{"CCU", "XCT:DE:URG_pain.001"};
    public static final String[] INSTANT_CREDIT_ORDER_TYPES = new String[]{"CIP", "SCI:DE_pain.001"};
    public static final List<PaymentTransferType.PmtType> PMT_TYPES_FOREIGN_PAYMENTS = Arrays.asList(PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER, PaymentTransferType.PmtType.AUSTRIAN_FOREIGN, PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE, PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE);
    public static final String[] DEBIT_ORDER_TYPES = new String[]{"CDD", "CDB", "SDD::COR_pain.008", "SDD::B2B_pain.008"};
    public static final String[] CREDIT_FILE_TYPES = new String[]{"pain.001.001.02.sct", "pain.001.001.03.sct"};
    public static final String[] DEBIT_FILE_TYPES = new String[]{"pain.008.001.01.sdd", "pain.008.001.01.sbb"};
    public static final String[] CREDIT_ORDER_TYPES_AND_FILE_TYPES = new String[]{"CCT", "CCU", "CIP", "XCT", "XE2", "SCT_pain.001", "XCT:DE:URG_pain.001", "SCI:DE_pain.001", "pain.001.001.02.sct", "pain.001.001.03.sct"};
    public static final String[] DEBIT_ORDER_TYPES_AND_FILE_TYPES = new String[]{"CDD", "CDB", "SDD::COR_pain.008", "SDD::B2B_pain.008", "pain.008.001.01.sdd", "pain.008.001.01.sbb"};
    private static final List<GeneralSEPAWriter.Version> OLD_SEPA_VERSIONS = Arrays.asList(GeneralSEPAWriter.Version.V24, GeneralSEPAWriter.Version.V25, GeneralSEPAWriter.Version.V24Iso, GeneralSEPAWriter.Version.V25Iso);
    private static final List<GeneralSEPAWriter.Version> OLD_DK_VERSIONS = Arrays.asList(GeneralSEPAWriter.Version.V24, GeneralSEPAWriter.Version.V25);
    public static final PaymentType[] CREDIT_RECIPIENT_TYPES = new PaymentType[]{PaymentType.SEPA, PaymentType.MANDATE};
    private static final PaymentType[] FOREIGN_RECIPIENT_TYPES = new PaymentType[]{PaymentType.SEPA_FOREIGN};
    private static final PaymentType[] CHEQUE_RECIPIENT_TYPES = new PaymentType[]{PaymentType.CHEQUE};
    private static final PaymentType[] AUSTRIAN_TAX_OFFICE_RECIPIENT_TYPES = new PaymentType[]{PaymentType.AUSTRIAN_TAX_OFFICE};
    private static final PaymentType[] AUSTRIAN_POSTBAR_RECIPIENT_TYPES = new PaymentType[]{PaymentType.AUSTRIAN_POSTBAR};
    private static final PaymentType[] SWISS_ESR_RECIPIENT_TYPES = new PaymentType[]{PaymentType.SWISS_ESR};
    private static final PaymentType[] SWISS_ES1_RECIPIENT_TYPES = new PaymentType[]{PaymentType.SWISS_POST_ACCOUNT};
    private static final PaymentType[] SWISS_ES2_RECIPIENT_TYPES = new PaymentType[]{PaymentType.SWISS_IID};
    public static final Date NO_EXECUTION_DATE;
    public static MessageIdGenerator messageIdGenerator;
    private static final String version30CreditText = "pain.001.001.03 (DK V 3.0 - V 3.6)";
    private static final String version27CreditText = "pain.001.003.03 (DK V 2.7 - V 2.9)";
    private static final String version25CreditText = "pain.001.002.03 (DK V 2.5)";
    private static final String version24CreditText = "pain.001.002.02 (DK V 2.4)";
    private static final String version25IsoCreditText = "pain.001.001.03 (ISO)";
    private static final String version24IsoCreditText = "pain.001.001.02 (ISO)";
    private static final String version30ChCreditText = "pain.001.001.03.ch.02 (CH)";
    private static final String version30DebitText = "pain.008.001.02 (DK V 3.0 - V 3.6)";
    private static final String version27DebitText = "pain.008.003.02 (DK V 2.7 - V 2.9)";
    private static final String version25DebitText = "pain.008.002.02 (DK V 2.5)";
    private static final String version24DebitText = "pain.008.002.01 (DK V 2.4)";
    private static final String version25IsoDebitText = "pain.008.001.02 (ISO)";
    private static final String version24IsoDebitText = "pain.008.001.01 (ISO)";
    private static final String[] bankCodesWithoutUrgentTaxOfficePaymentSupport;

    public static String getCreditTextForSEPAVersion(GeneralSEPAWriter.Version version) {
        switch (version) {
            case V30: {
                return version30CreditText;
            }
            case V27: {
                return version27CreditText;
            }
            case V25: {
                return version25CreditText;
            }
            case V24: {
                return version24CreditText;
            }
            case V25Iso: {
                return version25IsoCreditText;
            }
            case V24Iso: {
                return version24IsoCreditText;
            }
            case V30Ch: {
                return version30ChCreditText;
            }
        }
        return "";
    }

    public static String getDebitTextForSEPAVersion(GeneralSEPAWriter.Version version) {
        switch (version) {
            case V30: {
                return version30DebitText;
            }
            case V27: {
                return version27DebitText;
            }
            case V25: {
                return version25DebitText;
            }
            case V24: {
                return version24DebitText;
            }
            case V25Iso: {
                return version25IsoDebitText;
            }
            case V24Iso: {
                return version24IsoDebitText;
            }
        }
        return "";
    }

    @Deprecated
    public static GeneralSEPAWriter.Version getSEPAVersion(boolean isCredit, BankSettings bank) {
        return SepaApi.getDefaultSEPAVersion(isCredit, bank);
    }

    public static GeneralSEPAWriter.Version getSEPAVersionForPayment(SEPAPaymentData paymentData, BankSettings bank) {
        if (StringUtils.checkNullAndTrim(paymentData.getOriginatorLei()).length() > 0 || StringUtils.checkNullAndTrim(paymentData.getRecipientLei()).length() > 0) {
            return paymentData.isCredit() ? GeneralSEPAWriter.Version.Iso00100109 : GeneralSEPAWriter.Version.Iso00800108;
        }
        GeneralSEPAWriter.Version version = SepaApi.getDefaultSEPAVersion(paymentData.isCredit(), bank);
        if (paymentData.isCHPayment() || paymentData.getServiceLevel() == null) {
            version = GeneralSEPAWriter.Version.V30Ch;
        } else if (paymentData.isForeignPayment() || !SEPAServiceLevel.SEPA.name().equals(paymentData.getServiceLevel()) || !StringUtils.isEmpty(paymentData.getOriginatorAccountType()) || paymentData.isChequePayment()) {
            version = SepaApi.getVersionForForeignPayments(version);
        }
        if (paymentData.hasModifiedMandate()) {
            version = SepaApi.getVersionForMandateAmendments();
        }
        if (paymentData.isInstantPayment()) {
            version = SepaApi.getVersionForInstantPaymentsWithExecutionTime();
        } else if (!EUR.equals(paymentData.getCurrency().getCurrencyCode()) || paymentData.getOriginatorAddressData() != null || paymentData.getRecipientAddressData() != null) {
            version = paymentData.isCredit() ? SepaApi.getVersionForForeignCurrencyOrInstantPayment(version) : GeneralSEPAWriter.Version.Iso00800108;
        }
        if (SEPAPaymentCategory.isProprietary(paymentData.getPaymentCategory()) && GeneralSEPAWriter.Version.V30.equals((Object)version)) {
            version = GeneralSEPAWriter.Version.V25Iso;
        }
        return version;
    }

    @Deprecated
    public static GeneralSEPAWriter.Version getDefaultSEPAVersion(boolean isFrench) {
        return isFrench ? GeneralSEPAWriter.Version.V25Iso : GeneralSEPAWriter.Version.V30;
    }

    @Deprecated
    public static GeneralSEPAWriter.Version getDefaultSEPAVersion(boolean isCredit, BankSettings bank) {
        return SepaSchemeHandler.getDefaultVersion(isCredit, bank);
    }

    public static Date getEarliestExecutionDateForDebits(BankSettings bank, SepaDebitType debitType, SepaSequenceType seqType) {
        if (bank != null && debitType != null && seqType != null) {
            return SEPAUtil.getEarliestExecutionDate(SepaApi.getSEPAVersion(false, bank), false, debitType.name(), seqType.name(), SepaApi.getLeadTimeForDebits(bank));
        }
        return null;
    }

    public static int getLeadTimeForDebits(BankSettings bank) {
        if (bank != null) {
            return SepaApi.getLeadTimeForDebits(PaymentProperties.findForBank(bank));
        }
        return 1;
    }

    public static int getLeadTimeForDebits(PaymentProperties paymentProperties) {
        Integer leadTime;
        if (paymentProperties != null && (leadTime = paymentProperties.getSepaLeadTimeForDebits()) != null) {
            return leadTime;
        }
        return 1;
    }

    public static String getMessageId(BankUser bankUser) {
        if (new DatabasePreferenceStore(Preference.ApplicationId.SEPA, bankUser.getUser()).getBoolean(PreferenceConstants.ADD_TIMESTAMP_TO_MSGID)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return SepaApi.getMsgId(bankUser) + " " + sdf.format(new Date());
        }
        return String.valueOf(SepaApi.getMsgId(bankUser));
    }

    public static BicLoader.Service getDebitService(String debitType) {
        if (SepaDebitType.CORE.name().equals(debitType)) {
            return BicLoader.Service.Sdd;
        }
        if (SepaDebitType.B2B.name().equals(debitType)) {
            return BicLoader.Service.B2b;
        }
        if (SepaDebitType.COR1.name().equals(debitType)) {
            return BicLoader.Service.Cor1;
        }
        return null;
    }

    public static String getServiceLevel(String orderType) {
        if (AXZ.equals(orderType) || AXZ_BTF.equals(orderType)) {
            return null;
        }
        if (CCU.equals(orderType) || CCU_BTF.equals(orderType)) {
            return SEPAServiceLevel.URGP.name();
        }
        return SEPAServiceLevel.SEPA.name();
    }

    public static int getMsgId(BankUser bankUser) {
        char orderNumberPrefix;
        int refNumber = FileNumberHandler.getNumber(bankUser, FileNumberHandler.FileNumber.SEPA_MESSAGE_ID, 1, 9999);
        if (bankUser.getOrderNumber() != null && bankUser.getOrderNumber().length() > 0) {
            orderNumberPrefix = bankUser.getOrderNumber().charAt(0);
        } else {
            String licenseOrderNumber;
            AbstractLicenseHandler licenseHandler = AbstractLicenseHandler.getInstance();
            if (licenseHandler != null) {
                try {
                    licenseOrderNumber = licenseHandler.getLicenseProperties(bankUser.getUser()).getProperty("ORDER_NUMBER");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                licenseOrderNumber = null;
            }
            if (licenseOrderNumber != null && licenseOrderNumber.length() > 0) {
                orderNumberPrefix = licenseOrderNumber.charAt(0);
                bankUser.setOrderNumber(licenseOrderNumber);
                bankUser.save();
            } else {
                orderNumberPrefix = 'A';
            }
        }
        int letterPosition = Character.getNumericValue(orderNumberPrefix) - 9 + 26;
        return letterPosition * 10000 + refNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <BankOrderType extends AbstractBankOrder> Map<BankOrderType, List<OpenPayment>> createBankOrders(BankUser bankUser, PaymentTransferType.PmtType pmtType, String orderType, Iterator<BankOrderPayment<SEPAPaymentData>> paymentsIterator, BankOrderCallback<BankOrderType> bankOrderCallback, Locale locale) throws DisplayFileException, KnownFormatException, IOException, InvalidPasswordException, SAXException {
        HashMap result;
        block69: {
            CountingFilterOutputStream countingFilterOutputStream;
            ArrayList<Object> paymentsList;
            String msgId;
            GeneralSEPAWriter.Version version;
            boolean isCredit;
            String initiatingParty;
            block68: {
                LinkedHashMap logicalFilesMap = new LinkedHashMap();
                PaymentProperties paymentProperties = PaymentProperties.findExistingForBank(bankUser.getBank());
                initiatingParty = null;
                isCredit = true;
                boolean versionFromPmtTransferType = false;
                version = null;
                boolean hasIbanOnlyPayments = false;
                boolean hasModifiedMandates = false;
                boolean hasForeignCurrencies = false;
                boolean hasInstantPayments = false;
                boolean hasInstantPaymentsWithExecutionTime = false;
                boolean hasUrgentPayments = false;
                boolean hasForeignPayments = false;
                boolean hasCHPayments = false;
                boolean hasOriginatorAddress = false;
                boolean hasRecipientAddress = false;
                boolean hasProprietaryCategory = false;
                boolean hasOriginatorAccountType = false;
                boolean convertToDKSepaAddress = false;
                while (paymentsIterator.hasNext()) {
                    Currency c;
                    BankOrderPayment<SEPAPaymentData> bankOrderPayment = paymentsIterator.next();
                    SEPAPaymentData paymentData = bankOrderPayment.getPaymentData();
                    if (bankUser.getBank().isAustrianBank()) {
                        paymentData.setPmtTpInfOnLFLevel(Boolean.TRUE);
                    }
                    if (SEPAPaymentCategory.isProprietary(paymentData.getPaymentCategory()) && !hasProprietaryCategory) {
                        hasProprietaryCategory = true;
                    }
                    if (paymentData.isCHPayment() && !hasCHPayments) {
                        hasCHPayments = true;
                    }
                    if (paymentData.isForeignPayment() && !hasForeignPayments) {
                        hasForeignPayments = true;
                    }
                    if (!StringUtils.isEmpty(paymentData.getOriginatorAccountType()) && !hasOriginatorAccountType) {
                        hasOriginatorAccountType = true;
                    }
                    if (paymentData.isInstantPayment()) {
                        if (!hasInstantPayments) {
                            hasInstantPayments = true;
                        }
                        if (!hasInstantPaymentsWithExecutionTime) {
                            hasInstantPaymentsWithExecutionTime = paymentData.hasExecutionTime();
                        }
                    }
                    if (paymentData.isUrgentPayment() && !hasUrgentPayments) {
                        hasUrgentPayments = true;
                    }
                    if (!hasForeignCurrencies && (c = paymentData.getCurrency()) != null) {
                        boolean bl = hasForeignCurrencies = !EUR.equals(c.getCurrencyCode());
                    }
                    if (!hasIbanOnlyPayments) {
                        hasIbanOnlyPayments = SepaApi.bicsAreMissing(paymentData.getOriginatorBic(), paymentData.getRecipientBic());
                    }
                    isCredit = paymentData.isCredit();
                    if (version == null) {
                        OpenPayment op = bankOrderPayment.getOpenPayment();
                        if (op != null && (version = SepaSchemeHandler.getSepaVersion(bankUser.getBank(), op.getPmtType())) != null) {
                            versionFromPmtTransferType = true;
                        }
                        if (version == null) {
                            version = SepaApi.getSEPAVersion(isCredit, bankUser.getBank());
                        }
                        if (op != null) {
                            boolean bl = convertToDKSepaAddress = !(!GeneralSEPAWriter.Version.V30.equals((Object)version) && !GeneralSEPAWriter.Version.V25Iso.equals((Object)version) || !PaymentTransferType.PmtType.SEPA_TRANSFER.equals((Object)op.getPmtType()) && !PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER.equals((Object)op.getPmtType()) && !PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT.equals((Object)op.getPmtType()) && !PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT.equals((Object)op.getPmtType()) && !PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)op.getPmtType()) && !PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT.equals((Object)op.getPmtType()) && !PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT.equals((Object)op.getPmtType()));
                            if (PaymentTransferType.PmtType.AUSTRIAN_FOREIGN.equals((Object)op.getPmtType()) || PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)op.getPmtType())) {
                                version = GeneralSEPAWriter.Version.V25IsoATX;
                            }
                        }
                    }
                    if (paymentData.isUrgentPayment() && GeneralSEPAWriter.Version.Iso00100109.equals((Object)version)) {
                        paymentData.setChargeBearer(SEPAFeeType.SHAR.name());
                    }
                    if (paymentData.isUrgentPayment() && !GeneralSEPAWriter.Version.Iso00100109.equals((Object)version)) {
                        paymentData.setChargeBearer(SEPAFeeType.SLEV.name());
                    }
                    if (paymentData.getOriginatorAddressData() != null) {
                        if (!hasOriginatorAddress) {
                            hasOriginatorAddress = true;
                        }
                        if (convertToDKSepaAddress) {
                            paymentData.setOriginatorAddressData(AddressData.convertToDKSepaAddress(paymentData.getOriginatorAddressData()));
                        }
                    }
                    if (paymentData.getRecipientAddressData() != null) {
                        if (!hasRecipientAddress) {
                            hasRecipientAddress = true;
                        }
                        if (convertToDKSepaAddress) {
                            paymentData.setRecipientAddressData(AddressData.convertToDKSepaAddress(paymentData.getRecipientAddressData()));
                        }
                    }
                    if (!isCredit && !hasModifiedMandates && paymentData.hasModifiedMandate()) {
                        hasModifiedMandates = true;
                    }
                    String logicalFileKey = paymentData.getLogicalFileKey();
                    if (!GeneralSEPAWriter.allowDTAUSChars(version)) {
                        bankOrderPayment.setPaymentData((SEPAPaymentData)paymentData.clone());
                        paymentData = bankOrderPayment.getPaymentData();
                        if (bankOrderPayment.getPaymentData().getPurpose() != null) {
                            String msg = PaymentApiMessages.getString(locale, "PurposeTransform.message", "", "");
                            if (paymentData.getPurpose().contains(msg)) {
                                paymentData.setPurpose(paymentData.getPurpose().replaceAll(msg, PaymentApiMessages.getString(locale, "PurposeTransform.message2", "", "")));
                            }
                        }
                        paymentData.replaceDTAUSChars();
                    }
                    if (bankOrderPayment.getOpenPayment().getPmtType() == PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER || bankOrderPayment.getOpenPayment().getPmtType() == PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER) {
                        bankOrderPayment.setPaymentData((SEPAPaymentData)paymentData.clone());
                        paymentData = bankOrderPayment.getPaymentData();
                        paymentData.replaceSEPAForeignChars();
                    }
                    if (logicalFilesMap.containsKey(logicalFileKey)) {
                        ((List)logicalFilesMap.get(logicalFileKey)).add(bankOrderPayment);
                        continue;
                    }
                    ArrayList<BankOrderPayment<SEPAPaymentData>> l = new ArrayList<BankOrderPayment<SEPAPaymentData>>();
                    l.add(bankOrderPayment);
                    logicalFilesMap.put(logicalFileKey, l);
                    if (initiatingParty != null) continue;
                    initiatingParty = paymentData.getInitiatingParty();
                }
                msgId = messageIdGenerator != null ? messageIdGenerator.generate(bankUser, orderType) : SepaApi.getMessageId(bankUser);
                if (versionFromPmtTransferType) {
                    if (hasInstantPaymentsWithExecutionTime) {
                        if (!GeneralSEPAWriter.Version.Iso00100108.equals((Object)version) && !GeneralSEPAWriter.Version.Iso00100109.equals((Object)version)) {
                            version = SepaApi.getVersionForInstantPaymentsWithExecutionTime();
                        }
                    } else if (hasProprietaryCategory && GeneralSEPAWriter.Version.V30.equals((Object)version)) {
                        version = GeneralSEPAWriter.Version.V25Iso;
                    }
                } else if (isCredit && hasProprietaryCategory) {
                    if (!GeneralSEPAWriter.Version.Iso00100108.equals((Object)version) && !GeneralSEPAWriter.Version.Iso00100109.equals((Object)version)) {
                        version = GeneralSEPAWriter.Version.V25Iso;
                    }
                } else if (isCredit && hasOriginatorAccountType) {
                    if (!GeneralSEPAWriter.Version.V30Ch.equals((Object)version) && !GeneralSEPAWriter.Version.Iso00100109.equals((Object)version)) {
                        version = GeneralSEPAWriter.Version.V25Iso;
                    }
                } else if (hasCHPayments) {
                    version = GeneralSEPAWriter.Version.V30Ch;
                } else if (hasUrgentPayments) {
                    version = GeneralSEPAWriter.Version.V25Iso;
                } else if (hasForeignPayments && !GeneralSEPAWriter.Version.V25IsoATX.equals((Object)version)) {
                    version = SepaApi.getVersionForForeignPayments(version);
                } else {
                    version = SepaApi.checkVersion(version, hasUrgentPayments, hasIbanOnlyPayments, hasModifiedMandates);
                    if (hasInstantPaymentsWithExecutionTime) {
                        version = SepaApi.getVersionForInstantPaymentsWithExecutionTime();
                    } else if ((hasForeignCurrencies || hasInstantPayments || hasOriginatorAddress || hasRecipientAddress) && !GeneralSEPAWriter.Version.V25IsoATX.equals((Object)version)) {
                        version = GeneralSEPAWriter.Version.V25Iso;
                    }
                }
                boolean splittedOrder = false;
                if (!hasUrgentPayments || paymentProperties == null || paymentProperties.getSepaMaxUrgentPaymentsPerFile() == null || paymentProperties.getSepaMaxUrgentPaymentsPerFile() <= 0) {
                    paymentsList = new ArrayList(logicalFilesMap.values());
                } else {
                    int maxSize = paymentProperties.getSepaMaxUrgentPaymentsPerFile();
                    if (logicalFilesMap.size() > 1 && maxSize > 0) {
                        splittedOrder = true;
                    }
                    paymentsList = new ArrayList(logicalFilesMap.size());
                    for (ArrayList<List<SEPAPaymentData>> logicalFileList : logicalFilesMap.values()) {
                        if (logicalFileList.size() > maxSize) {
                            for (int i = 0; i < logicalFileList.size(); i += maxSize) {
                                if (i + maxSize < logicalFileList.size()) {
                                    paymentsList.add(logicalFileList.subList(i, i + maxSize));
                                    splittedOrder = true;
                                    continue;
                                }
                                paymentsList.add(logicalFileList.subList(i, logicalFileList.size()));
                            }
                            continue;
                        }
                        paymentsList.add(logicalFileList);
                    }
                }
                result = new HashMap();
                if (!splittedOrder) break block68;
                CountingFilterOutputStream out = null;
                int counter = 1;
                for (List list : paymentsList) {
                    ArrayList<List<SEPAPaymentData>> logicalFileList;
                    File file = AbstractBankOrder.createOrderFile(bankUser.getBank().getUniqueKey(), orderType, null);
                    logicalFileList = new ArrayList<List<SEPAPaymentData>>();
                    ArrayList<SEPAPaymentData> logicalFileItem = new ArrayList<SEPAPaymentData>();
                    ArrayList<OpenPayment> openPayments = new ArrayList<OpenPayment>();
                    for (BankOrderPayment data : list) {
                        logicalFileItem.add((SEPAPaymentData)data.getPaymentData());
                        openPayments.add(data.getOpenPayment());
                    }
                    logicalFileList.add(logicalFileItem);
                    try {
                        out = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(file));
                        GeneralSEPAWriter.write(version, isCredit, msgId + "-" + counter++, initiatingParty, logicalFileList, out);
                    }
                    catch (Throwable throwable) {
                        SystemUtils.close(out);
                        throw throwable;
                    }
                    SystemUtils.close(out);
                    BankOrderType bankOrderType = bankOrderCallback.createBankOrder(bankUser.getBank(), pmtType, orderType, file, out.getWritten());
                    ((AbstractBankOrder)bankOrderType).setCountPayments(openPayments.size());
                    result.put(bankOrderType, openPayments);
                }
                break block69;
            }
            ArrayList<List<SEPAPaymentData>> bankOrderPaymentDataList = new ArrayList<List<SEPAPaymentData>>();
            ArrayList<OpenPayment> openPaymentsList = new ArrayList<OpenPayment>();
            for (List list : paymentsList) {
                if (!list.isEmpty()) {
                    bankOrderPaymentDataList.add(new ArrayList());
                }
                for (BankOrderPayment data : list) {
                    ((List)bankOrderPaymentDataList.get(bankOrderPaymentDataList.size() - 1)).add((SEPAPaymentData)data.getPaymentData());
                    openPaymentsList.add(data.getOpenPayment());
                }
            }
            File orderFile = AbstractBankOrder.createOrderFile(bankUser.getBank().getUniqueKey(), orderType, null);
            AutoCloseable autoCloseable = null;
            try {
                countingFilterOutputStream = new CountingFilterOutputStream(EncryptData.getInstance().openOutputStream(orderFile));
                GeneralSEPAWriter.write(version, isCredit, msgId, initiatingParty, bankOrderPaymentDataList, countingFilterOutputStream);
            }
            catch (Throwable throwable) {
                SystemUtils.close(autoCloseable);
                throw throwable;
            }
            SystemUtils.close(countingFilterOutputStream);
            BankOrderType bankOrderType = bankOrderCallback.createBankOrder(bankUser.getBank(), pmtType, orderType, orderFile, countingFilterOutputStream.getWritten());
            ((AbstractBankOrder)bankOrderType).setCountPayments(openPaymentsList.size());
            result.put(bankOrderType, openPaymentsList);
        }
        return result;
    }

    public static boolean bicsAreMissing(String originatorBic, String recipientBic) {
        return SepaApi.bicIsMissing(originatorBic) || SepaApi.bicIsMissing(recipientBic);
    }

    public static boolean bicIsMissing(String bic) {
        return bic == null || bic.trim().length() < 8;
    }

    public static GeneralSEPAWriter.Version checkVersion(GeneralSEPAWriter.Version version, boolean isUrgent, boolean isIbanOnly, boolean hasModifiedMandates) {
        if (hasModifiedMandates) {
            return SepaApi.getVersionForMandateAmendments();
        }
        if (isUrgent && OLD_SEPA_VERSIONS.contains((Object)version)) {
            return GeneralSEPAWriter.DEFAULT_VERSION;
        }
        if (isIbanOnly) {
            if (OLD_DK_VERSIONS.contains((Object)version)) {
                return GeneralSEPAWriter.DEFAULT_VERSION;
            }
            if (GeneralSEPAWriter.Version.V24Iso == version) {
                return GeneralSEPAWriter.Version.V25Iso;
            }
        }
        return version;
    }

    public static GeneralSEPAWriter.Version getVersionForForeignCurrencyOrInstantPayment(GeneralSEPAWriter.Version version) {
        if (GeneralSEPAWriter.Version.V30Ch.equals((Object)version)) {
            return GeneralSEPAWriter.Version.V30Ch;
        }
        return GeneralSEPAWriter.Version.Iso00100109;
    }

    public static GeneralSEPAWriter.Version getVersionForForeignPayments(GeneralSEPAWriter.Version version) {
        return GeneralSEPAWriter.Version.Iso00100109;
    }

    public static GeneralSEPAWriter.Version getVersionForMandateAmendments() {
        return GeneralSEPAWriter.Version.V30;
    }

    public static GeneralSEPAWriter.Version getVersionForInstantPaymentsWithExecutionTime() {
        return GeneralSEPAWriter.Version.Iso00100109;
    }

    public static PaymentType[] getRecipientTypes(PaymentTransferType.PmtType pmtType, boolean isCredit) {
        if (pmtType != null) {
            switch (pmtType) {
                case SWISS_ESR_TRANSFER: {
                    return SWISS_ESR_RECIPIENT_TYPES;
                }
                case SWISS_ES1_TRANSFER: {
                    return SWISS_ES1_RECIPIENT_TYPES;
                }
                case SWISS_ES2_TRANSFER: {
                    return SWISS_ES2_RECIPIENT_TYPES;
                }
                case AUSTRIAN_TAX_PAYMENT: 
                case AUSTRIAN_URGENT_TAX_PAYMENT: {
                    return AUSTRIAN_TAX_OFFICE_RECIPIENT_TYPES;
                }
                case AUSTRIAN_POSTBAR_PAYMENT: {
                    return AUSTRIAN_POSTBAR_RECIPIENT_TYPES;
                }
                case SEPA_FOREIGN_TRANSFER: 
                case SEPA_URGENT_FOREIGN_TRANSFER: {
                    return FOREIGN_RECIPIENT_TYPES;
                }
                case SEPA_FOREIGN_CHEQUE: {
                    return CHEQUE_RECIPIENT_TYPES;
                }
            }
        }
        if (isCredit) {
            return CREDIT_RECIPIENT_TYPES;
        }
        return null;
    }

    public static PaymentTransferType.PmtType getPmtType(SEPAPaymentData paymentData) {
        return SepaApi.getPmtType(paymentData, null, null);
    }

    public static PaymentTransferType.PmtType getPmtType(SEPAPaymentData paymentData, String bankCountryCode) {
        return SepaApi.getPmtType(paymentData, null, bankCountryCode);
    }

    public static PaymentTransferType.PmtType getPmtType(SEPAPaymentData paymentData, PaymentTransferType.PmtType defaultType) {
        return SepaApi.getPmtType(paymentData, defaultType, null);
    }

    public static PaymentTransferType.PmtType getPmtType(SEPAPaymentData paymentData, PaymentTransferType.PmtType defaultType, String bankCountryCode) {
        String recipientIban;
        boolean isAustrianBank = "AT".equals(bankCountryCode);
        String debitType = paymentData.getDebitType();
        if (SEPALocalInstrument.CORE.name().equals(debitType)) {
            return PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT;
        }
        if (SEPALocalInstrument.B2B.name().equals(debitType)) {
            return PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT;
        }
        if (SEPALocalInstrument.COR1.name().equals(debitType)) {
            return PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT;
        }
        if (paymentData.isChequePayment()) {
            if (PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)defaultType) || isAustrianBank) {
                return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE;
            }
            return PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE;
        }
        if (paymentData.isESRPayment()) {
            return PaymentTransferType.PmtType.SWISS_ESR_TRANSFER;
        }
        if (paymentData.isES1Payment()) {
            return PaymentTransferType.PmtType.SWISS_ES1_TRANSFER;
        }
        if (paymentData.isES2Payment()) {
            return PaymentTransferType.PmtType.SWISS_ES2_TRANSFER;
        }
        if (paymentData.isSwissDomesticTransfer()) {
            return PaymentTransferType.PmtType.SWISS_DOMESTIC_TRANSFER_3;
        }
        Currency currency = paymentData.getCurrency();
        String serviceLevel = StringUtils.checkNullAndTrim(paymentData.getServiceLevel());
        if (paymentData.isForeignPayment()) {
            if (PaymentTransferType.PmtType.AUSTRIAN_FOREIGN.equals((Object)defaultType)) {
                return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN;
            }
            if (PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER.equals((Object)defaultType)) {
                return PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER;
            }
            if (paymentData.isUrgentPayment() && (currency == null || EUR.equals(currency.getCurrencyCode()))) {
                if (SEPAUtil.isSalaryPayment(paymentData.getPaymentCategory(), paymentData.getPurposeCode())) {
                    return PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER;
                }
                return PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER;
            }
            if (SEPAServiceLevel.URGP.name().equals(serviceLevel)) {
                return PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER;
            }
            if (isAustrianBank) {
                return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN;
            }
            return PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER;
        }
        if ((serviceLevel.length() == 0 || SEPAServiceLevel.SEPA.name().equals(serviceLevel)) && currency != null && !EUR.equals(currency.getCurrencyCode())) {
            return PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER;
        }
        if (SepaApi.isAustrianTaxOfficePayment(paymentData)) {
            if (SEPAServiceLevel.URGP.name().equals(serviceLevel)) {
                return PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT;
            }
            return PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT;
        }
        if (SepaApi.isAustrianPostbarPayment(paymentData)) {
            return PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT;
        }
        if (paymentData.isInstantPayment()) {
            return PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER;
        }
        if (EUR.equals(currency.getCurrencyCode()) && SEPAServiceLevel.URGP.name().equals(serviceLevel)) {
            if (SEPAUtil.isSalaryPayment(paymentData.getPaymentCategory(), paymentData.getPurposeCode())) {
                return PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER;
            }
            return PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER;
        }
        boolean isSepaTransfer = SEPAServiceLevel.SEPA.name().equals(serviceLevel) ? true : (isAustrianBank && serviceLevel.length() == 0 ? (recipientIban = paymentData.getRecipientIban()) != null && !recipientIban.isEmpty() && IbanUtil.getCountryCode(recipientIban) != null && SepaCountry.isSepaCountry(IbanUtil.getCountryCode(recipientIban)) : false);
        if (isSepaTransfer) {
            if (SEPAUtil.isSalaryPayment(paymentData.getPaymentCategory(), paymentData.getPurposeCode())) {
                return PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER;
            }
            return PaymentTransferType.PmtType.SEPA_TRANSFER;
        }
        if (SEPAServiceLevel.URGP.name().equals(serviceLevel)) {
            return PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER;
        }
        if (isAustrianBank) {
            return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN;
        }
        return PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER;
    }

    public static boolean isAustrianTaxOfficePayment(SEPAPaymentData paymentData) {
        return "TAXS".equals(paymentData.getPurposeCode()) && (paymentData.getPurpose() == null || paymentData.getPurpose().isEmpty() || AustrianFeeMessageHandler.isValidPattern(paymentData.getPurpose()));
    }

    public static boolean isAustrianUrgentTaxOfficePaymentAllowed(Account account) {
        if (account != null) {
            return SepaApi.isAustrianUrgentTaxOfficePaymentAllowed(account.getIban());
        }
        return true;
    }

    public static boolean isAustrianUrgentTaxOfficePaymentAllowed(String iban) {
        if (iban != null && iban.startsWith("AT")) {
            return !StringUtils.isContainedInArray(IbanUtil.getBankCode(iban), bankCodesWithoutUrgentTaxOfficePaymentSupport);
        }
        return true;
    }

    public static boolean isAustrianPostbarPayment(SEPAPaymentData paymentData) {
        return "CPPP".equals(paymentData.getPaymentCategory()) && PostbarPurpose.isPostbarPurpose(paymentData.getPurpose());
    }

    public static boolean isCreditOrderType(String orderType) {
        RestrictedServiceType rst;
        if (BTFTranslator.isBTFString(orderType) && (rst = BTFTranslator.convertFrom(orderType)) != null && rst.getMsgName() != null) {
            return PaymentTransferType.FormatType.pain001.toString().equals(rst.getMsgName().getValue().replace(".", ""));
        }
        return StringUtils.isContainedInArray(orderType, CREDIT_ORDER_TYPES_AND_FILE_TYPES);
    }

    public static boolean isPain001OrPain008PmtType(PaymentTransferType.PmtType pmtType) {
        if (pmtType != null) {
            return SepaApi.isCreditPmtType(pmtType) || SepaApi.isDebitPmtType(pmtType);
        }
        return false;
    }

    public static boolean isCreditPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.FormatType.pain001.equals((Object)pmtType.getFormatType());
    }

    @Deprecated
    public static String getCreditOrderType(BankSettings bank, boolean isExpressPayment, String currencyCode) {
        if (isExpressPayment) {
            return CCU;
        }
        if (bank.isSwissBank()) {
            return XE2;
        }
        if (!EUR.equals(currencyCode)) {
            return XCT;
        }
        return CCT;
    }

    public static String getInstantCreditPaymentOrderType(BankSettings bank) {
        return CIP;
    }

    public static boolean isInstantCreditPaymentType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)pmtType);
    }

    public static boolean isForeignPayment(PaymentTransferType.PmtType pmtType) {
        return PMT_TYPES_FOREIGN_PAYMENTS.contains((Object)pmtType);
    }

    public static boolean isChequePayment(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE.equals((Object)pmtType) || PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)pmtType);
    }

    public static boolean isInstantCreditPaymentOrderType(String orderType) {
        return StringUtils.isContainedInArray(orderType, INSTANT_CREDIT_ORDER_TYPES);
    }

    public static boolean isDebitOrderType(String orderType) {
        RestrictedServiceType rst;
        if (BTFTranslator.isBTFString(orderType) && (rst = BTFTranslator.convertFrom(orderType)) != null && rst.getMsgName() != null) {
            return PaymentTransferType.FormatType.pain008.toString().equals(rst.getMsgName().getValue().replace(".", ""));
        }
        return StringUtils.isContainedInArray(orderType, DEBIT_ORDER_TYPES_AND_FILE_TYPES);
    }

    public static boolean isDebitPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.FormatType.pain008.equals((Object)pmtType.getFormatType());
    }

    public static boolean isCoreDirectDebit(String orderTypeOrBTF) {
        return CDD.equals(orderTypeOrBTF) || CDD_BTF.equals(orderTypeOrBTF);
    }

    public static boolean isCoreDirectDebit(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT.equals((Object)pmtType) || PaymentTransferType.PmtType.SWISS_SEPA_CORE_DIRECT_DEBIT.equals((Object)pmtType);
    }

    public static boolean isUrgent(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER.equals((Object)pmtType) || PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT.equals((Object)pmtType) || PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT.equals((Object)pmtType);
    }

    @Deprecated
    public static boolean isUrgent(String orderType) {
        return StringUtils.isContainedInArray(orderType, URGENT_CREDIT_ORDER_TYPES);
    }

    public static boolean isSEPAExpressPayment(String orderType) {
        return StringUtils.isContainedInArray(orderType, URGENT_CREDIT_ORDER_TYPES);
    }

    public static boolean isSalaryPaymentType(PaymentTransferType.PmtType pmtType) {
        switch (pmtType) {
            case SEPA_CONFIDENTAL_TRANSFER: 
            case SEPA_URGENT_CONFIDENTAL_TRANSFER: {
                return true;
            }
        }
        return false;
    }

    public static String getPaymentReferenceOld(SEPAPaymentData paymentData, int sequenceNumber) {
        if (paymentData != null && paymentData.getEndToEndId() != null && paymentData.getEndToEndId().length() > 4) {
            int firstSep = paymentData.getEndToEndId().indexOf("-");
            int secondSep = paymentData.getEndToEndId().lastIndexOf("-");
            if (firstSep > 0 && secondSep > firstSep + 1 && paymentData.getEndToEndId().length() > secondSep + 1) {
                return paymentData.getEndToEndId();
            }
        }
        return paymentData.getMessageId() + "/" + sequenceNumber;
    }

    public static String getPaymentReference(SEPAPaymentData paymentData, int sequenceNumber) {
        String endToEndId = paymentData.getEndToEndId();
        if (endToEndId != null && endToEndId.length() > 0) {
            return endToEndId;
        }
        return paymentData.getMessageId() + "/" + sequenceNumber;
    }

    public static void doExtendedFileCheck(List<SEPAPaymentData> sepaPayments, Locale locale) throws KnownFormatException {
        if (sepaPayments.size() > 0) {
            boolean ibanOnlyAllowed;
            ArrayList<String> errors = new ArrayList<String>();
            boolean isCredit = sepaPayments.get(0).isCredit();
            if (SEPAServiceLevel.URGP.name().equals(sepaPayments.get(0).getServiceLevel()) && !(ibanOnlyAllowed = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, null).getBoolean(PreferenceConstants.URGENT_PAYMENT_ALLOWS_IBAN_ONLY))) {
                for (SEPAPaymentData p : sepaPayments) {
                    String errorMessage;
                    if (!SepaApi.isBicPresent(p.getRecipientBic())) {
                        errorMessage = SepaApiMessages.getString(locale, "extendedfilecheck.recipientBicIsMandatoryForCCU", p.getRecipient(), p.getRecipientIban());
                        errors.add(errorMessage);
                    }
                    if (SepaApi.isBicPresent(p.getOriginatorBic())) continue;
                    errorMessage = SepaApiMessages.getString(locale, "extendedfilecheck.originatorBicIsMandatoryForCCU", p.getOriginator(), p.getOriginatorIban());
                    errors.add(errorMessage);
                }
            }
            if (!isCredit) {
                for (SEPAPaymentData p : sepaPayments) {
                    String mandateReference;
                    AddressData addressData;
                    String countryCode;
                    String recipientAccountNumber = p.getRecipientIban();
                    if (IbanUtil.checkIban(recipientAccountNumber) && SepaCountry.isDebtorAddressMandatory(countryCode = IbanUtil.getCountryCode(recipientAccountNumber)) && (addressData = p.getRecipientAddressData()) == null) {
                        String countryName = CountriesLoader.getInstance(locale).getCountryName(countryCode);
                        String errorMessage = SepaApiMessages.getString(locale, "extendedfilecheck.payerAddressMandatory", p.getRecipient(), p.getRecipientIban(), countryName != null ? countryName : countryCode);
                        errors.add(errorMessage);
                    }
                    if (SEPAUtil.checkMandateReference(mandateReference = p.getMandateId())) continue;
                    String errorMessage = SepaApiMessages.getString(locale, "extendedfilecheck.invalidMandateReference", p.getRecipient(), mandateReference);
                    errors.add(errorMessage);
                }
            }
            GeneralMessages generalMessages = GeneralMessages.getInstance(locale);
            for (SEPAPaymentData p : sepaPayments) {
                String[] admissiblePurposeCodes;
                String purposeCode;
                String errorMessage;
                String invalidChar;
                PaymentTransferType.PmtType pmtType = SepaApi.getPmtType(p);
                SepaApi.checkForInvalidCharacters(p.getOriginator(), isCredit ? generalMessages.ORIGINATOR : generalMessages.PAYEE, false, pmtType, errors, locale);
                SepaApi.checkForInvalidCharacters(p.getUltimateOriginator(), isCredit ? generalMessages.ULTIMATE_ORIGINATOR : generalMessages.ULTIMATE_PAYEE, true, pmtType, errors, locale);
                SepaApi.checkForInvalidCharacters(p.getRecipient(), isCredit ? generalMessages.RECIPIENT : generalMessages.PAYER, false, pmtType, errors, locale);
                SepaApi.checkForInvalidCharacters(p.getUltimateRecipient(), isCredit ? generalMessages.ULTIMATE_RECIPIENT : generalMessages.ULTIMATE_PAYER, true, pmtType, errors, locale);
                SepaApi.checkForInvalidCharacters(p.getPurpose(), generalMessages.PURPOSE, true, pmtType, errors, locale);
                SepaApi.checkForInvalidCharacters(p.getOriginatorAddressData(), BankingApiMessages.getString(locale, isCredit ? "Affiliation.originator" : "Affiliation.payee", new Object[0]), pmtType, errors, locale);
                SepaApi.checkForInvalidCharacters(p.getRecipientAddressData(), BankingApiMessages.getString(locale, isCredit ? "Affiliation.recipient" : "Affiliation.payer", new Object[0]), pmtType, errors, locale);
                SepaApi.checkForInvalidCharacters(p.getRecipientBankAddressData(), BankingApiMessages.getString(locale, "Affiliation.recipientBank", new Object[0]), pmtType, errors, locale);
                if (p.getRegReportings() != null) {
                    for (RegReporting reporting : p.getRegReportings()) {
                        SepaApi.checkForInvalidCharacters(reporting, pmtType, errors, locale);
                    }
                }
                if ((invalidChar = PaymentUtils.containsNonSepaChar(p.getEndToEndId())) != null) {
                    errorMessage = SepaApiMessages.getString(locale, "extendedfilecheck.fieldContainsInvalidCharacter", generalMessages.END_TO_END_REFERENCE, p.getEndToEndId(), invalidChar);
                    errors.add(errorMessage);
                }
                if (BigDecimal.ZERO.compareTo(p.getAmount()) >= 0) {
                    errorMessage = SepaApiMessages.getString(locale, "extendedfilecheck.amountInvalid", PaymentUtils.formatAmount(p.getAmount(), p.getCurrency(), locale), PaymentUtils.formatAmount(BigDecimal.ZERO, p.getCurrency(), locale));
                    errors.add(errorMessage);
                }
                if ((purposeCode = p.getPurposeCode()) == null || purposeCode.isEmpty() || SepaApi.isAustrianTaxOfficePayment(p) || Arrays.asList(admissiblePurposeCodes = p.isUrgentPayment() ? SEPAPurposeCode.getUrgentPaymentPurposeCodes(true) : SEPAPurposeCode.getPurposeCodes(true)).contains(purposeCode)) continue;
                String errorMessage2 = SepaApiMessages.getString(locale, "extendedfilecheck.purposeCodeInvalid", p.getPurposeCode());
                errors.add(errorMessage2);
            }
            if (!errors.isEmpty()) {
                throw new KnownFormatException(String.join((CharSequence)"\n", errors));
            }
        }
    }

    private static void checkForInvalidCharacters(String s, String fieldName, boolean canBeEmpty, PaymentTransferType.PmtType pmtType, List<String> errors, Locale locale) {
        if (canBeEmpty && (s == null || s.length() == 0)) {
            return;
        }
        String invalidChar = pmtType == PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER || pmtType == PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER ? PaymentUtils.containsNonSepaForeignChar(s) : PaymentUtils.containsNonSepaAndDtausChar(s);
        if (invalidChar != null) {
            String errorMessage = SepaApiMessages.getString(locale, "extendedfilecheck.fieldContainsInvalidCharacter", fieldName, s, invalidChar);
            errors.add(errorMessage);
        }
    }

    private static void checkForInvalidCharacters(AddressData addressData, String affiliation, PaymentTransferType.PmtType pmtType, List<String> errors, Locale locale) {
        affiliation = " " + (String)affiliation;
        if (addressData == null) {
            return;
        }
        SepaApi.checkForInvalidCharacters(addressData.getStreetName(), BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getSubDepartment(), BankingApiMessages.getString(locale, "GeneralMessages.subDepartement", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getBuildingName(), BankingApiMessages.getString(locale, "GeneralMessages.buildingName", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getBuildingNumber(), BankingApiMessages.getString(locale, "GeneralMessages.buildingNumber", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getCountrySubDivision(), BankingApiMessages.getString(locale, "GeneralMessages.subCountry", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getDepartment(), BankingApiMessages.getString(locale, "GeneralMessages.departement", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getDistrictName(), BankingApiMessages.getString(locale, "GeneralMessages.districtName", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getFloor(), BankingApiMessages.getString(locale, "GeneralMessages.floor", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getPostBox(), BankingApiMessages.getString(locale, "GeneralMessages.postBox", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getPostCode(), BankingApiMessages.getString(locale, "GeneralMessages.postCode", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getRoom(), BankingApiMessages.getString(locale, "GeneralMessages.room", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getTownLocationName(), BankingApiMessages.getString(locale, "GeneralMessages.townLocationName", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        SepaApi.checkForInvalidCharacters(addressData.getTownName(), BankingApiMessages.getString(locale, "GeneralMessages.town", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        for (String line : addressData.getAddressLines()) {
            SepaApi.checkForInvalidCharacters(line, BankingApiMessages.getString(locale, "GeneralMessages.callbackOrders.furtherInfos", new Object[0]) + (String)affiliation, true, pmtType, errors, locale);
        }
    }

    private static void checkForInvalidCharacters(RegReporting reporting, PaymentTransferType.PmtType pmtType, List<String> errors, Locale locale) {
        if (reporting == null) {
            return;
        }
        String affiliation = " " + BankingApiMessages.getString(locale, "Affiliation.regReporting", new Object[0]);
        SepaApi.checkForInvalidCharacters(reporting.getAuthorityName(), BankingApiMessages.getString(locale, "GeneralMessages.authorityName", new Object[0]) + affiliation, true, pmtType, errors, locale);
        for (RegReportingDetail detail : reporting.getDetails()) {
            SepaApi.checkForInvalidCharacters(detail.getCode(), BankingApiMessages.getString(locale, "GeneralMessages.code", new Object[0]) + affiliation, true, pmtType, errors, locale);
            SepaApi.checkForInvalidCharacters(detail.getType(), BankingApiMessages.getString(locale, "GeneralMessages.type", new Object[0]) + affiliation, true, pmtType, errors, locale);
            for (String inf : detail.getInfs()) {
                SepaApi.checkForInvalidCharacters(inf, BankingApiMessages.getString(locale, "GeneralMessages.additionalInformation", new Object[0]) + affiliation, true, pmtType, errors, locale);
            }
        }
    }

    public static boolean isOriginatorAddressMandatory(String originatorIban, String recipientIban) {
        String originatorCountryCode = IbanUtil.getCountryCode(originatorIban);
        String recipientCountryCode = IbanUtil.getCountryCode(recipientIban);
        if (originatorCountryCode != null && recipientCountryCode != null && !originatorCountryCode.equals(recipientCountryCode)) {
            return SepaCountry.isOriginatorAddressMandatory(originatorCountryCode) || SepaCountry.isOriginatorAddressMandatory(recipientCountryCode);
        }
        return false;
    }

    public static boolean isOriginatorAddressMandatoryForCheque(ChequeDeliveryCode chequeDeliveryCode) {
        return chequeDeliveryCode != null && (chequeDeliveryCode.equals((Object)ChequeDeliveryCode.MLDB) || chequeDeliveryCode.equals((Object)ChequeDeliveryCode.CRDB) || chequeDeliveryCode.equals((Object)ChequeDeliveryCode.RGDB));
    }

    public static void checkOriginatorAddresses(List<SEPAPaymentData> sepaPayments, Locale locale) throws KnownFormatException {
        for (SEPAPaymentData p : sepaPayments) {
            if (!p.isCredit() || !SepaApi.isOriginatorAddressMandatory(p.getOriginatorIban(), p.getRecipientIban()) || !p.getServiceLevel().equals("SEPA") || p.getOriginatorAddressData() != null) continue;
            String countryCode = IbanUtil.getCountryCode(p.getRecipientIban());
            String countryName = CountriesLoader.getInstance(locale).getCountryName(countryCode);
            String messageKey = "extendedfilecheck.originatorAddressMandatory";
            throw new KnownFormatException(SepaApiMessages.getString(locale, messageKey, countryName != null ? countryName : countryCode));
        }
    }

    private static boolean isBicPresent(String bic) {
        if (bic != null) {
            String s = bic.trim();
            return s.length() != 0 && !"NOTPROVIDED".equals(s);
        }
        return false;
    }

    public static void checkForBOM(InputStream in, Locale locale) throws KnownFormatException, IOException {
        byte[] bom = new byte[3];
        in.read(bom);
        in.close();
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            throw new KnownFormatException(SepaApiMessages.getString("extendedfilecheck.bom", locale));
        }
    }

    public static void checkForInvalidCreditorIds(List<SEPAPaymentData> sepaPayments, Locale locale) throws KnownFormatException {
        if (sepaPayments.size() > 0 && !sepaPayments.get(0).isCredit()) {
            for (SEPAPaymentData p : sepaPayments) {
                if (SEPAUtil.checkCreditorId(p.getCreditorId())) continue;
                throw new KnownFormatException(SepaApiMessages.getString(locale, "extendedfilecheck.invalidCreditorId", p.getOriginator(), p.getCreditorId()));
            }
        }
    }

    public static void checkForNonSepaCountries(List<SEPAPaymentData> sepaPayments, Locale locale) throws KnownFormatException {
        for (SEPAPaymentData p : sepaPayments) {
            String recipientAccountNumber;
            if (!SEPAServiceLevel.SEPA.name().equals(p.getServiceLevel()) || !IbanUtil.checkIban(recipientAccountNumber = p.getRecipientIban()) || SepaCountry.isSepaCountry(IbanUtil.getCountryCode(recipientAccountNumber))) continue;
            throw new KnownFormatException(BankingApiMessages.getString(locale, "GeneralMessages.noSepaCountry", p.getRecipientIban(), IbanUtil.getCountryCode(p.getRecipientIban())));
        }
    }

    public static void checkForNonEurCurrencies(List<SEPAPaymentData> sepaPayments, Locale locale) throws KnownFormatException {
        for (SEPAPaymentData p : sepaPayments) {
            if (EUR.equals(p.getCurrency().getCurrencyCode())) continue;
            String messageKey = p.isCredit() ? "extendedfilecheck.nonEurCurrencyInCredit" : "extendedfilecheck.nonEurCurrencyInDebit";
            throw new KnownFormatException(SepaApiMessages.getString(locale, messageKey, p.getRecipient(), p.getCurrency().getCurrencyCode()));
        }
    }

    private static String getFileType(PaymentProperties paymentProperties, String orderType) {
        if (paymentProperties == null) {
            return null;
        }
        if ((SEPA_2_x_CREDIT_FILE_TYPE.equals(orderType) || SEPA_3_x_CREDIT_FILE_TYPE.equals(orderType)) && paymentProperties.getSepaCreditFileType() != null) {
            return paymentProperties.getSepaCreditFileType();
        }
        if (CORE_DEBIT_FILE_TYPE.equals(orderType) && paymentProperties.getSepaCoreDebitFileType() != null) {
            return paymentProperties.getSepaCoreDebitFileType();
        }
        if (B2B_DEBIT_FILE_TYPE.equals(orderType) && paymentProperties.getSepaB2bDebitFileType() != null) {
            return paymentProperties.getSepaB2bDebitFileType();
        }
        return orderType;
    }

    private SepaApi() {
    }

    public static List<SEPAPaymentData> getPaymentData(boolean isDebit, InputStream in) throws SAXException, IOException {
        ArrayList<SEPAPaymentData> payments = new ArrayList<SEPAPaymentData>();
        int logicalFileNumber = 0;
        for (SEPALogicalFile logicalFile : SepaApi.getLogicalFiles(isDebit, in)) {
            ++logicalFileNumber;
            int paymentNumber = 0;
            for (SEPAPaymentData payment : logicalFile.getTransactions()) {
                payment.setLogicalFile(logicalFileNumber);
                payment.setPaymentNumber(++paymentNumber);
                payment.setPmtInfId(logicalFile.getPmtInfId());
                payments.add(payment);
            }
        }
        return payments;
    }

    private static List<SEPALogicalFile> getLogicalFiles(boolean isDebit, InputStream in) throws IOException, SAXException {
        if (isDebit) {
            return GeneralSEPAExtractor.getLogicalFilesFromDebit(in);
        }
        return GeneralSEPAExtractor.getLogicalFilesFromCCT(in);
    }

    static {
        bankCodesWithoutUrgentTaxOfficePaymentSupport = new String[]{"14000", "60000", "14200", "14900"};
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 1999);
        cal.set(2, 0);
        cal.set(5, 1);
        NO_EXECUTION_DATE = cal.getTime();
    }

    public static interface MessageIdGenerator {
        public String generate(BankUser var1, String var2);
    }
}

