/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.transfer.api.SendFileAutoDetect;
import de.businesslogics.banking.transfer.api.SendFileAutoDetectException;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.SEPALogicalFile;
import de.businesslogics.format.sepa.SEPAPaymentData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.xml.sax.SAXException;

@Deprecated
public class SendFileAutoDetectImpl
implements SendFileAutoDetect {
    private GeneralSEPAExtractor.SepaHandlerKey sepaHandlerKey;

    @Override
    public SendFileAutoDetect.Result detect(File f, User user) throws SendFileAutoDetectException {
        List<BankSettings> banksList = this.getBanks(f, user);
        if (banksList.isEmpty()) {
            throw new NoBankFoundException();
        }
        return new SendFileAutoDetect.Result(banksList, this.sepaHandlerKey.name());
    }

    private List<BankSettings> getBanks(File file, User user) throws SendFileAutoDetectException {
        ArrayList<BankSettings> fileBanks = new ArrayList<BankSettings>();
        Set<String> ibans = this.getIBANs(file);
        if (ibans == null || ibans.isEmpty()) {
            throw new NoSepaPaymentDataFoundException();
        }
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            if (!BankUtils.isReady(bankUser)) continue;
            List<Account> accounts = Account.findAccountsForBank(bankUser.getBank());
            HashSet<String> i2 = new HashSet<String>();
            for (Account account : accounts) {
                if (account.getIban() == null || Account.Type.CASH_MANAGEMENT.equals((Object)account.getType())) continue;
                i2.add(account.getIban());
            }
            if (!i2.containsAll(ibans)) continue;
            fileBanks.add(bankUser.getBank());
        }
        return fileBanks;
    }

    private Set<String> getIBANs(File file) throws SendFileAutoDetectException {
        Set<String> set;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            set = this.getIBANsFromLogicalFileList(GeneralSEPAExtractor.getLogicalFiles(in));
        }
        catch (IOException | SAXException e) {
            try {
                throw new GeneralException((Throwable)e);
            }
            catch (Throwable throwable) {
                Util.closeStream(in);
                throw throwable;
            }
        }
        Util.closeStream(in);
        return set;
    }

    private Set<String> getIBANsFromLogicalFileList(List<SEPALogicalFile> logicalFileList) throws DifferentOrderTypeException {
        HashSet<String> ibans = new HashSet<String>();
        List<SEPAPaymentData> trxs = null;
        this.sepaHandlerKey = GeneralSEPAExtractor.findHandlerKey(logicalFileList);
        if (this.sepaHandlerKey == null) {
            throw new DifferentOrderTypeException();
        }
        for (SEPALogicalFile lgFile : logicalFileList) {
            trxs = lgFile.getTransactions();
            for (SEPAPaymentData sepaData : trxs) {
                ibans.add(sepaData.getOriginatorIban());
            }
        }
        return ibans;
    }

    private final class NoBankFoundException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = 1236014028225229638L;

        private NoBankFoundException() {
        }

        @Override
        public String getMessage(Locale locale) {
            return SepaApiMessages.getString(locale, "sendFileAutoDetect.noBankCouldBeFound", new Object[0]);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }
    }

    private final class NoSepaPaymentDataFoundException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = -4976667795999396387L;

        private NoSepaPaymentDataFoundException() {
        }

        @Override
        public String getMessage(Locale locale) {
            return SepaApiMessages.getString(locale, "sendFileAutoDetect.noSepaPaymentDataFound", new Object[0]);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }
    }

    private final class GeneralException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = -8719472773391215019L;

        public GeneralException(Throwable cause) {
            super(cause);
        }

        @Override
        public String getMessage(Locale locale) {
            if (this.getCause() != null) {
                return this.getCause().getMessage();
            }
            return super.getMessage();
        }
    }

    private final class DifferentOrderTypeException
    extends SendFileAutoDetectException {
        private static final long serialVersionUID = 2465038316320613071L;

        private DifferentOrderTypeException() {
        }

        @Override
        public String getMessage(Locale locale) {
            return SepaApiMessages.getString(locale, "sendFileAutoDetect.differentOrderTypesFound", new Object[0]);
        }

        @Override
        public String getMessage() {
            return this.getMessage(Locale.getDefault());
        }
    }
}

