/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.format.sepa.at.PostbarPurpose;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;

public final class PostbarRecipientData
extends RecipientData {
    private String address1;
    private String address2;
    private String plz;
    private boolean forward;
    private boolean inPerson;
    private PostbarPurpose.PayOffMode payOffMode;
    private String smsNumber;
    private String postPlz;

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.AUSTRIAN_POSTBAR;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        this.address1 = properties.getProperty(PropertiesKeys.ADDRESS1.getKey());
        this.address2 = properties.getProperty(PropertiesKeys.ADDRESS2.getKey());
        this.plz = properties.getProperty(PropertiesKeys.PLZ.getKey());
        String forwardProperty = properties.getProperty(PropertiesKeys.FORWARD.getKey());
        this.forward = forwardProperty == null || !forwardProperty.equals("false");
        String inPersonProperty = properties.getProperty(PropertiesKeys.IN_PERSON.getKey());
        this.inPerson = inPersonProperty == null || !inPersonProperty.equals("false");
        String payOffProperty = properties.getProperty(PropertiesKeys.PAY_OFF_MODE.getKey());
        this.payOffMode = payOffProperty != null ? PostbarPurpose.PayOffMode.valueOf(payOffProperty) : PostbarPurpose.PayOffMode.PayOff;
        this.smsNumber = properties.getProperty(PropertiesKeys.SMS_NUMBER.getKey());
        this.postPlz = properties.getProperty(PropertiesKeys.POST_PLZ.getKey());
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        this.setProperty(properties, PropertiesKeys.ADDRESS1, this.address1);
        this.setProperty(properties, PropertiesKeys.ADDRESS2, this.address2);
        this.setProperty(properties, PropertiesKeys.PLZ, this.plz);
        this.setProperty(properties, PropertiesKeys.FORWARD, Boolean.toString(this.forward));
        this.setProperty(properties, PropertiesKeys.IN_PERSON, Boolean.toString(this.inPerson));
        this.setProperty(properties, PropertiesKeys.PAY_OFF_MODE, this.payOffMode.name());
        this.setProperty(properties, PropertiesKeys.SMS_NUMBER, this.smsNumber);
        this.setProperty(properties, PropertiesKeys.POST_PLZ, this.postPlz);
        this.setRecipientInfoProperties(properties);
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            PostbarRecipientData original = new PostbarRecipientData();
            original.setPaymentRecipient(originalVo);
            if (StringUtils.valuesDiffer(this.address1, original.getAddress1())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.address2, original.getAddress2())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.plz, original.getPlz())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean hasChangeWithoutForEyes(PaymentRecipient originalVo) {
        if (super.hasChangeWithoutForEyes(originalVo)) {
            return true;
        }
        try {
            PostbarRecipientData original = new PostbarRecipientData();
            original.setPaymentRecipient(originalVo);
            if (this.forward != original.isForward()) {
                return true;
            }
            if (this.inPerson != original.isInPerson()) {
                return true;
            }
            if (this.payOffMode != null && !this.payOffMode.equals((Object)original.getPayOffMode())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.smsNumber, original.getSmsNumber())) {
                return true;
            }
            if (StringUtils.valuesDiffer(this.postPlz, original.getPostPlz())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
        if (withHeader) {
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.address", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.address", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.postCode", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.noforward", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.inPerson", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payoffMode", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payoffMode.PayOffSms", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.payOffPostPlz", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), false, columnSeparator, lineSeparator);
            PostbarRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.cashInstructionReference", new Object[0]), true, columnSeparator, lineSeparator);
        }
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getDisplayName(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getName(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getAddress1(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getAddress2(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getPlz(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, Boolean.toString(!this.isForward()), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, Boolean.toString(this.isInPerson()), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getPayOffMode().name(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, "'+43" + this.getSmsNumber(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getPostPlz(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getPurpose(), false, columnSeparator, lineSeparator);
        PostbarRecipientData.writeCsvFieldToWriter(writer, this.getReference(), true, columnSeparator, lineSeparator);
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getPlz() {
        return this.plz;
    }

    public void setPlz(String plz) {
        this.plz = plz;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public boolean isInPerson() {
        return this.inPerson;
    }

    public void setInPerson(boolean inPerson) {
        this.inPerson = inPerson;
    }

    public PostbarPurpose.PayOffMode getPayOffMode() {
        return this.payOffMode;
    }

    public void setPayOffMode(PostbarPurpose.PayOffMode payOffMode) {
        this.payOffMode = payOffMode;
    }

    public String getSmsNumber() {
        return this.smsNumber;
    }

    public void setSmsNumber(String smsNumber) {
        this.smsNumber = smsNumber;
    }

    public String getPostPlz() {
        return this.postPlz;
    }

    public void setPostPlz(String postPlz) {
        this.postPlz = postPlz;
    }

    public boolean addressIsEqual(String address1, String address2, String plz) {
        return !StringUtils.valuesDiffer(this.address1, address1) && !StringUtils.valuesDiffer(this.address2, address2) && !StringUtils.valuesDiffer(this.plz, plz);
    }

    public boolean otherDataHaveChanged(boolean forward, boolean inPerson, PostbarPurpose.PayOffMode payOffMode, String smsNumber, String postPlz, String purpose, String reference) {
        boolean hasChanged = false;
        if (forward != this.forward) {
            this.forward = forward;
            hasChanged = true;
        }
        if (inPerson != this.inPerson) {
            this.inPerson = inPerson;
            hasChanged = true;
        }
        if (payOffMode != null && payOffMode.equals((Object)this.payOffMode)) {
            this.payOffMode = payOffMode;
            hasChanged = true;
        }
        if (StringUtils.valuesDiffer(this.smsNumber, smsNumber)) {
            this.smsNumber = smsNumber;
            hasChanged = true;
        }
        if (StringUtils.valuesDiffer(this.postPlz, postPlz)) {
            this.postPlz = postPlz;
            hasChanged = true;
        }
        if (StringUtils.valuesDiffer(this.getPurpose(), purpose)) {
            this.setPurpose(purpose);
            hasChanged = true;
        }
        if (StringUtils.valuesDiffer(this.getReference(), reference)) {
            this.setReference(reference);
            hasChanged = true;
        }
        return hasChanged;
    }

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        ADDRESS1("address1"),
        ADDRESS2("address2"),
        PLZ("plz"),
        FORWARD("forward"),
        IN_PERSON("inPerson"),
        PAY_OFF_MODE("payOffMode"),
        SMS_NUMBER("smsNumber"),
        POST_PLZ("postPlz");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

