/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.api.DatabaseConnection;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.banking.sepa.api.SepaOriginatorData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.Update;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public final class MandateMigratorApi {
    private final User user;
    private final Locale locale;
    private final BLLogger logger;

    public MandateMigratorApi(User user, Locale locale, BLLogger logger) {
        this.user = user;
        this.locale = locale;
        this.logger = logger;
    }

    public void run(IProgressMonitorWrapper monitor, boolean useMandates) {
        monitor.beginTask(SepaApiMessages.getString(this.locale, "mandatemigrator.taskname", new Object[0]), 100);
        if (useMandates) {
            Update<PaymentRecipient> update = DBType.ORACLE.equals((Object)DatabaseConnection.getInstance().getDbType()) ? DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET payment_type=6 WHERE payment_type=2 AND sepa_mandate_id IS NOT NULL") : DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET payment_type=6 WHERE payment_type=2 AND sepa_mandate_id IS NOT NULL AND sepa_mandate_id <> ''");
            int countMandates = update.execute();
            monitor.worked(50);
            this.logger.logInfo("Created " + countMandates + " mandates by changing payment type to mandate.");
            if (countMandates > 0) {
                boolean useFourEyes = false;
                List<PaymentOriginator> originators = PaymentOriginator.findSEPAOriginators(Tenant.getAllTenants());
                if (originators != null && originators.size() > 0) {
                    SepaOriginatorData uniqueCreditor = this.getUniqueCreditor(originators);
                    if (uniqueCreditor != null) {
                        for (PaymentRecipient vo : PaymentRecipient.findRecipientsForPaymentType(PaymentType.MANDATE, Tenant.getAllTenants())) {
                            SepaMandateData mandate = new SepaMandateData();
                            try {
                                mandate.setPaymentRecipient(vo);
                                mandate.setCreditor(uniqueCreditor.getName());
                                mandate.setCreditorId(uniqueCreditor.getCreditorId());
                                mandate.save(this.user, useFourEyes);
                            }
                            catch (IOException e) {
                                this.logger.logError("Failed to update SEPA mandate!", e);
                            }
                        }
                    } else {
                        String uniqueCreditorId = this.getUniqueCreditorId(originators);
                        if (uniqueCreditorId != null) {
                            for (PaymentRecipient vo : PaymentRecipient.findRecipientsForPaymentType(PaymentType.MANDATE, Tenant.getAllTenants())) {
                                SepaMandateData mandate = new SepaMandateData();
                                try {
                                    mandate.setPaymentRecipient(vo);
                                    mandate.setCreditorId(uniqueCreditorId);
                                    mandate.save(this.user, useFourEyes);
                                }
                                catch (IOException e) {
                                    this.logger.logError("Failed to update SEPA mandate!", e);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            Update<PaymentRecipient> update = DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET payment_type=2 WHERE payment_type=6");
            int countMandates = update.execute();
            monitor.worked(50);
            this.logger.logInfo("Update " + countMandates + " mandates. Reset payment type to SEPA!");
        }
        monitor.worked(50);
    }

    private SepaOriginatorData getUniqueCreditor(List<PaymentOriginator> originators) {
        SepaOriginatorData uniqueCreditor = null;
        for (PaymentOriginator originator : originators) {
            SepaOriginatorData sepaOriginator = new SepaOriginatorData();
            try {
                sepaOriginator.setPaymentOriginator(originator);
                if (sepaOriginator.getCreditorId() == null || !SEPAUtil.checkCreditorId(sepaOriginator.getCreditorId())) continue;
                if (uniqueCreditor != null) {
                    this.logger.logInfo("MandateMigrator found 2 differend creditors: " + sepaOriginator.getName() + ", " + uniqueCreditor.getName() + " -> Creditor has to be set manually on the mandates.");
                    return null;
                }
                uniqueCreditor = sepaOriginator;
            }
            catch (IOException e) {
                this.logger.logWarning("Failed to load SEPA originator!", e);
            }
        }
        return uniqueCreditor;
    }

    private String getUniqueCreditorId(List<PaymentOriginator> originators) {
        String uniqueCreditorId = null;
        for (PaymentOriginator originator : originators) {
            SepaOriginatorData sepaOriginator = new SepaOriginatorData();
            try {
                sepaOriginator.setPaymentOriginator(originator);
                if (sepaOriginator.getCreditorId() == null || !SEPAUtil.checkCreditorId(sepaOriginator.getCreditorId())) continue;
                if (uniqueCreditorId != null && !uniqueCreditorId.equals(sepaOriginator.getCreditorId())) {
                    this.logger.logInfo("MandateMigrator found 2 differend creditorIds: " + sepaOriginator.getCreditorId() + ", " + uniqueCreditorId + " -> CreditorId has to be set manually on the mandates.");
                    return null;
                }
                uniqueCreditorId = sepaOriginator.getCreditorId();
            }
            catch (IOException e) {
                this.logger.logWarning("Failed to load SEPA originator!", e);
            }
        }
        return uniqueCreditorId;
    }
}

