/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.dta.api.DtazvRecipientData;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.util.StringUtils;
import java.io.IOException;

public final class ConvertToOtherRecipientType {
    public static PaymentRecipient convertDtazvToSepaRecipient(PaymentRecipient paymentRecipient) throws IOException {
        PaymentRecipient newPay = new PaymentRecipient();
        newPay.setPaymentType(PaymentType.SEPA);
        newPay.setTenant(paymentRecipient.getTenant());
        newPay.setDisplayName(paymentRecipient.getDisplayName());
        newPay.setName(paymentRecipient.getName());
        newPay.setAccountNumber(paymentRecipient.getAccountNumber());
        newPay.setBankCode(paymentRecipient.getBankCode());
        newPay.setPurpose(paymentRecipient.getPurpose());
        SepaRecipientData sepaRecipient = new SepaRecipientData();
        sepaRecipient.setPaymentRecipient(newPay);
        return newPay;
    }

    public static PaymentRecipient convertDtazvToSepaForeignRecipient(PaymentRecipient paymentRecipient) throws IOException {
        DtazvRecipientData r = new DtazvRecipientData();
        r.setPaymentRecipient(paymentRecipient);
        PaymentRecipient newPay = new PaymentRecipient();
        newPay.setPaymentType(PaymentType.SEPA_FOREIGN);
        newPay.setTenant(paymentRecipient.getTenant());
        newPay.setDisplayName(paymentRecipient.getDisplayName());
        newPay.setName(ConvertToOtherRecipientType.getName(r.getName(), r.getName2()));
        newPay.setAccountNumber(paymentRecipient.getAccountNumber());
        newPay.setBankCode(paymentRecipient.getBankCode());
        newPay.setPurpose(ConvertToOtherRecipientType.getPurpose(r.getPurpose1(), r.getPurpose2(), r.getPurpose3(), r.getPurpose4()));
        SepaForeignRecipientData sepaRecipient = new SepaForeignRecipientData();
        sepaRecipient.setPaymentRecipient(newPay);
        AddressData address = ConvertToOtherRecipientType.getAddressDataFromDTAZV(r);
        AddressData bankAddress = ConvertToOtherRecipientType.getBankAddressDataFromDTAZV(r);
        sepaRecipient.setBankName(ConvertToOtherRecipientType.getName(r.getBankName(), r.getBankName2()));
        sepaRecipient.setBankAddress(bankAddress);
        sepaRecipient.setAddress(address);
        sepaRecipient.buildRecipientInfo();
        return newPay;
    }

    private static String getPurpose(String p1, String p2, String p3, String p4) {
        String puspose1 = StringUtils.checkNullAndTrim(p1);
        String puspose2 = StringUtils.checkNullAndTrim(p2);
        String puspose3 = StringUtils.checkNullAndTrim(p3);
        String puspose4 = StringUtils.checkNullAndTrim(p4);
        int length = puspose1.length() + puspose2.length() + puspose3.length() + puspose4.length();
        if (length == 140) {
            return puspose1 + puspose2 + puspose3 + puspose4;
        }
        StringBuilder sb = new StringBuilder(puspose1);
        if (puspose2.length() > 0) {
            sb.append(' ');
            sb.append(puspose2);
        }
        if (puspose3.length() > 0) {
            sb.append(' ');
            sb.append(puspose3);
        }
        if (puspose4.length() > 0) {
            sb.append(' ');
            sb.append(puspose4);
        }
        if (sb.length() > 140) {
            return sb.toString().substring(0, 140);
        }
        return sb.toString();
    }

    private static String getName(String n1, String n2) {
        String name1 = StringUtils.checkNullAndTrim(n1);
        String name2 = StringUtils.checkNullAndTrim(n2);
        int length = name1.length() + name2.length();
        if (length == 70) {
            return name1 + name2;
        }
        StringBuilder sb = new StringBuilder(name1);
        if (name2.length() > 0) {
            sb.append(' ');
            sb.append(name2);
        }
        if (sb.length() > 70) {
            return sb.toString().substring(0, 70);
        }
        return sb.toString();
    }

    private static AddressData getAddressDataFromDTAZV(DtazvRecipientData r) {
        return ConvertToOtherRecipientType.getAddressData(r.getStreet(), r.getTown(), r.getCountry());
    }

    private static AddressData getBankAddressDataFromDTAZV(DtazvRecipientData r) {
        return ConvertToOtherRecipientType.getAddressData(r.getBankStreet(), r.getBankTown(), r.getBankCountry());
    }

    private static AddressData getAddressData(String s, String t, String c) {
        String street = StringUtils.checkNullAndTrim(s);
        String town = StringUtils.checkNullAndTrim(t);
        String country = StringUtils.checkNullAndTrim(c);
        AddressData address = null;
        if (street.length() > 0) {
            address = new AddressData();
            address.setStreetName(street);
        }
        if (town.length() > 0) {
            if (address == null) {
                address = new AddressData();
            }
            address.setTownName(town);
        }
        if (country.length() > 0) {
            if (address == null) {
                address = new AddressData();
            }
            address.setCountry(country);
        }
        return address;
    }
}

