/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AddressPropertyHandler;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;

public final class ChequeRecipientData
extends RecipientData {
    private static final String ADDRESS_LINE_SEPARATOR = "|";
    private AddressData address;
    private String feeType;

    private void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    @Override
    public void loadFromMultiwebProperties(Properties properties) {
    }

    @Override
    public PaymentType getPaymentType() {
        return PaymentType.CHEQUE;
    }

    @Override
    protected void loadRecipientInfo() throws IOException {
        Properties properties = this.loadRecipientInfoProperties();
        this.address = AddressPropertyHandler.getAddressData(properties);
        this.feeType = properties.getProperty(PropertiesKeys.FEE_TYPE.getKey());
    }

    @Override
    protected void buildRecipientInfo() throws IOException {
        Properties properties = new Properties();
        AddressPropertyHandler.setAddressData(this.address, properties);
        this.setProperty(properties, PropertiesKeys.FEE_TYPE, this.feeType);
        this.setRecipientInfoProperties(properties);
    }

    public AddressData getAddress() {
        return this.address;
    }

    public void setAddress(AddressData address) {
        this.address = address;
    }

    public String getFeeType() {
        if (this.feeType == null) {
            return "";
        }
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public void addAddress(AddressData newAddress) {
        if (newAddress != null) {
            if (this.address == null) {
                this.address = newAddress;
            } else {
                boolean unstructured;
                boolean bl = unstructured = newAddress.getAddressLines().size() > 0;
                if (unstructured) {
                    this.address.getAddressLines().clear();
                    this.address.getAddressLines().addAll(newAddress.getAddressLines());
                } else {
                    this.address.setDepartment(newAddress.getDepartment());
                    this.address.setSubDepartment(newAddress.getSubDepartment());
                    this.address.setStreetName(newAddress.getStreetName());
                    this.address.setBuildingNumber(newAddress.getBuildingNumber());
                    this.address.setBuildingName(newAddress.getBuildingName());
                    this.address.setFloor(newAddress.getFloor());
                    this.address.setPostCode(newAddress.getPostCode());
                    this.address.setTownName(newAddress.getTownName());
                    this.address.setCountrySubDivision(newAddress.getCountrySubDivision());
                }
            }
        }
    }

    @Override
    protected boolean hasFourEyesChange(PaymentRecipient originalVo) {
        if (this.hasGeneralChanges(originalVo)) {
            return true;
        }
        try {
            ChequeRecipientData original = new ChequeRecipientData();
            original.setPaymentRecipient(originalVo);
            if (StringUtils.valuesDiffer(this.feeType, original.getFeeType())) {
                return true;
            }
            if (!AddressData.areEqual(this.address, original.getAddress())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void csvExport(Writer writer, User user, Locale locale, char columnSeparator, boolean withHeader, String lineSeparator) throws IOException {
        if (withHeader) {
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.name", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.address", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.departement", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.subDepartement", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.buildingNumber", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.buildingName", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.floor", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.town", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.postCode", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.subCountry", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.country", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.feeType", new Object[0]), false, columnSeparator, lineSeparator);
            ChequeRecipientData.writeCsvFieldToWriter(writer, BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), true, columnSeparator, lineSeparator);
        }
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getDisplayName(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getName(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddressAsString(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getDepartment(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getSubDepartment(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getStreetName(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getBuildingNumber(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getBuildingName(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getFloor(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getTownName(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getPostCode(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getAddress().getCountrySubDivision(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getCountry(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getFeeType(), false, columnSeparator, lineSeparator);
        ChequeRecipientData.writeCsvFieldToWriter(writer, this.getPurpose(), true, columnSeparator, lineSeparator);
    }

    public String getAddressAsString() {
        if (this.address != null) {
            StringBuilder sb = new StringBuilder();
            boolean isFirstString = true;
            for (String str : this.address.getAddressLines()) {
                if (str == null || str.trim().length() <= 0) continue;
                if (isFirstString) {
                    isFirstString = false;
                } else {
                    sb.append(ADDRESS_LINE_SEPARATOR);
                }
                sb.append(str.trim());
            }
            return sb.toString();
        }
        return "";
    }

    private String getCountry() {
        if (this.address != null) {
            return this.address.getCountry();
        }
        return null;
    }

    private static enum PropertiesKeys {
        FEE_TYPE("feeType");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

