/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.sepa;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.PreferenceBundleHandler;
import java.util.Locale;
import java.util.ResourceBundle;

public enum PreferenceConstants implements DatabasePreferenceConstant
{
    ALLOW_INVALID_CREDITOR_ID("AllowInvalidCreditorId", String.valueOf(false), true, false),
    DISPLAY_PAYMENT_CATEGORIES("DisplayPaymentCategories", String.valueOf(true), true, false),
    DISPLAY_PAYMENT_TYPES("DisplayPaymentTypes", String.valueOf(true), true, false),
    USE_MANDATE_ADMISTRATION("UseMandateAdministration", String.valueOf(true), true, false),
    MANDATE_ADMISTRATION_FIRSTRUN("MandateAdministrationFirstRun", String.valueOf(true), false, false),
    DISPLAY_DIALOG_TO_DETERMINE_IBAN("DisplayDialogToDetermineIban", String.valueOf(true), true, false),
    EXTENDED_FILE_CHECK("ExtendedFileCheck", String.valueOf(true), true, false),
    SCL_CHECK("SclCheck", String.valueOf(true), true, false),
    ALLOW_FOREIGN_CURRENCIES("AllowForeignCurrencies", String.valueOf(false), false, false),
    ALLOW_NON_SEPA_COUNTRIES("AllowNonSepaCountries", String.valueOf(false), false, false),
    ALLOW_ONLY_ISO11649_CREDTIOR_REFERENCES("AllowOnlyISO11649CreditorReferences", String.valueOf(false), true, false),
    SAVE_ACCOUNT_CURRENCY("SaveAccountCurrency", String.valueOf(true), false, true),
    SAVE_MANDATE("SaveMandate", String.valueOf(true), true, false),
    DISPLAY_PAYMENT_AS_SINGLE_BOOKING("DisplayPmtAsSingleBooking", String.valueOf(false), true, false),
    ALLOW_BOM("allowBOM", String.valueOf(false), true, false),
    USE_NEW_CONVERTER("UseNewConverter", String.valueOf(true), false, false),
    ADD_TIMESTAMP_TO_MSGID("MsgIdStamp", String.valueOf(true), false, false),
    BATCH_BOOKING_TAG_MANDATORY("BatchBookingTagMandatory", String.valueOf(true), false, false),
    URGENT_PAYMENT_ALLOWS_IBAN_ONLY("UrgentPaymentAllowsIbanOnly", String.valueOf(true), false, false),
    ALLOW_UK_TRANSFER_WITHOUT_ORIGINATOR_ADDRESS("AllowUKTransferWithoutOriginatorAddress", String.valueOf(false), true, false),
    ALLOW_CH_TRANSFER_WITHOUT_ORIGINATOR_ADDRESS("AllowCHTransferWithoutOriginatorAddress", String.valueOf(false), true, false),
    ALLOW_CH_TRANSFER_WITHOUT_RECIPIENT_ADDRESS("AllowCHTransferWithoutRecipientAddress", String.valueOf(false), true, false),
    DISPLAY_ULTIMATE_ORIGINATOR("DisplayUltimateOriginator", String.valueOf(true), true, false),
    DISPLAY_ULTIMATE_RECIPIENT("DisplayUltimateRecipient", String.valueOf(true), true, false),
    DISPLAY_ULTIMATE_PAYEE("DisplayUltimatePayee", String.valueOf(true), true, false),
    DISPLAY_ULTIMATE_PAYER("DisplayUltimatePayer", String.valueOf(true), true, false),
    DISPLAY_PRIORITY("DisplayPriority", String.valueOf(true), true, false),
    DISPLAY_REFERENCE("DisplayReference", String.valueOf(true), true, false),
    ALLOW_CATEGORY_AND_PURPOSE("AllowCategoryAndPurpose", String.valueOf(false), false, false),
    USE_STRUCTURED_PURPOSE_FOR_CATEGORY("UseStructuredPurposeForCategory", String.valueOf(true), false, false),
    FEE_TYPE_MANDATORY("FeeTypeMandatory", String.valueOf(true), false, false),
    SERVICE_LEVEL_MANDATORY("ServiceLevelMandatory", String.valueOf(true), false, false);

    private static final PreferenceBundleHandler BUNDLE_HANDLER;
    private final String id;
    private String defaultValue;
    private final boolean userSpecific;
    private final boolean onlyAdminOrTenantAdmin;

    private PreferenceConstants(String id, String defaultValue, boolean userSpecific, boolean onlyAdminOrTenantAdmin) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.userSpecific = userSpecific;
        this.onlyAdminOrTenantAdmin = onlyAdminOrTenantAdmin;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    @Override
    public DatabasePreferenceConstant.DataType getType() {
        return DatabasePreferenceConstant.DataType.BOOLEAN;
    }

    @Override
    public boolean isOnlyConfigurableByAdmin() {
        return false;
    }

    @Override
    public boolean isOnlyConfigurableByAdminOrTenantAdmin() {
        return this.onlyAdminOrTenantAdmin;
    }

    @Override
    public String getLabel(Locale locale) {
        return BUNDLE_HANDLER.getString(this.id, locale);
    }

    @Override
    public String[][] getSelectableOptions(Locale locale) {
        return null;
    }

    static {
        BUNDLE_HANDLER = new PreferenceBundleHandler(){

            @Override
            protected ResourceBundle loadBundle(Locale locale) {
                return ResourceBundle.getBundle("de.businesslogics.banking.sepa.PreferenceConstants", locale);
            }
        };
    }
}

