/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.preferences;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.PreferenceBundleHandler;
import java.util.Locale;
import java.util.ResourceBundle;

public enum PreferenceConstants implements DatabasePreferenceConstant
{
    DS_OVERVIEW_ON_STARTUP("dsOverview", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DS_QUICK_SIGN("dsQuickSign", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DS_SHOW_SIGNATURES("dsShowSignatures", String.valueOf(false), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DS_SHOW_FILENAME("dsShowFilename", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DS_USE_TREE("dsUseTree", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DS_MAX_HVD_IN_OVERVIEW("dsMaxHVDInOverview", String.valueOf(10), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    LOG_DS("LogDs", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    MANUELL_PROXY("proxy", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    MANUELL_PROXY_HOST("proxyHost", "", false, DatabasePreferenceConstant.DataType.STRING, false, false),
    MANUELL_PROXY_PORT("proxyPort", String.valueOf(80), false, DatabasePreferenceConstant.DataType.INTEGER, false, false),
    PDF_PROGRAM("pdfProgram", "", true, DatabasePreferenceConstant.DataType.FILE, false, false),
    OPEN_PROGRAM("openProgram", "", true, DatabasePreferenceConstant.DataType.FILE, false, false),
    REMEMBER_PROXY_PASSWORD("rememberProxyPassword", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DISPLAY_SMARTCARD_OPTION("displaySmartcardOption", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DISPLAY_EXPORT_MASTERDATA_OPTION("displayExportMasterdataOptions", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DISPLAY_EXPORT_MASTERDATA_ONLY_IPHONE("displayExportMasterdataOnlyIphone", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    MOBILE_APP_NAME("mobileAppName", "BL Banking", false, DatabasePreferenceConstant.DataType.STRING, false, false),
    PROPOSE_KEY_DIR("proposeKeyDir", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    ENCRYPT_DATA("EncyptData", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    EBICS_TRACES("ebicsTraces", String.valueOf(false), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    NEW_BANK_WIZARD("newBankWizard", "GERMANY", false, DatabasePreferenceConstant.DataType.STRING, false, false),
    DS_EXTENDED_HVU("extendedHVU", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DS_DISPLAY_DETAILS("dsDisplayDetails", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    DS_DISPLAY_NEW_ORDERS_HINT("dsDisplayNewOrdersHint", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DS_DISPLAY_ACCOUNT_NAMES("dsDisplayAccountNames", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DS_ALLOW_DELETE_HISTORIC("dsAllowDeleteHistoric", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DS_CLEAN_UP("dsCleanUp", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DS_CLEAN_SIGNED("dsCleanSigned", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DS_CLEAN_REJECTED("dsCleanRejected", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DS_CLEAN_SIGNED_AGE("dsCleanSignedAge", String.valueOf(5), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    DS_CLEAN_REJECTED_AGE("dsCleanRejectedAge", String.valueOf(5), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    DS_CLEAN_SIGNED_UNIT("dsCleanSignedUnit", String.valueOf(3), false, DatabasePreferenceConstant.DataType.ENUM_COMBO, true, false),
    DS_CLEAN_REJECTED_UNIT("dsCleanRejectedUnit", String.valueOf(3), false, DatabasePreferenceConstant.DataType.ENUM_COMBO, true, false),
    DISPLAY_SALARIES("displaySalaries", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    IMPORT_SALARIES("importSalaries", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    PRINT_AMOUNTS_OF_SALARY_PAYMENTS("printAmountsOfSalaryPayments", String.valueOf(false), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    SALARY_PERMISSIONS("salaryPermissions", String.valueOf(1), true, DatabasePreferenceConstant.DataType.ENUM_RADIO, true, true),
    CONFIRM_RECIPIENT_PERMISSION("confirmRecipientPermission", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_VIEW_ACCOUNT_STATEMENTS("allowViewAccountStatements", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_FETCH_FILES("allowFetchFiles", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_SEND_FILES("allowSendFiles", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_VEU("allowVEU", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_PAYMENT_RECORDING("allowPaymentRecording", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_AWV_RECORDING("allowAWVRecording", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_FOLDER_FILES("allowFolderFiles", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_SETTINGS("allowSettings", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_BANKS_AND_ACCOUNTS("allowBanksAndAccounts", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    LOG_PERFORMANCE("LogPerformance", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    SCARD_MIGRATION("SmartCardMigrationWizard", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    REFRESH_HTD("refreshHTD", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    SEND_REPORT_MAX_FILE_SIZE_FOR_DETAILS("sendReportMaxFileSizeForDetails", String.valueOf(0x100000L), false, DatabasePreferenceConstant.DataType.LONG, false, false),
    MIGRATE_TO_NEW_CM("migrateToNewCM", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    FREE_SPACE_CHECK("freeSpaceCheck", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    PRINT_PAGE_NUMBERS("printPageNumbers", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    PRINT_DATE_TIME("printDateTime", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    PRINT_USER_NAME("printUserName", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    PRINT_LOGO("printLogo", String.valueOf(false), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    PASSWORD_MIN_LENGTH("PasswordMinLength", String.valueOf(8), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    PASSWORD_NEED_LETTER("PasswordNeedLetter", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    PASSWORD_NEED_LOWER("PasswordNeedLower", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    PASSWORD_NEED_UPPER("PasswordNeedUpper", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    PASSWORD_NEED_NUMBER("PasswordNeedNumber", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    PASSWORD_NEED_SPECIAL("PasswordNeedSpecial", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    PASSWORD_CHANGE_IN_DAYS("PasswordChangeInDays", String.valueOf(0), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    PASSWORD_CHECK_HISTORY("PasswordCheckHistory", String.valueOf(0), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    PASSWORD_USER_LOCKED("PasswordUserLocked", String.valueOf(5), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    USE_SEPARATE_PASSWORDS("UseSeparatePasswords", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    CHECK_KEYDIR_ON_LOGIN("CheckKeydirOnLogin", String.valueOf(true), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    CHECK_EBICS_VERSIONS("CheckEbicsVersions", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    CHECK_KEY_LENGTHS("CheckKeyLengths", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    ALLOW_SYNCHRONISATION("allowSynchronisation", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ACCOUNT_RENAME_BY_ADMIN_ONLY("accountRenameByAdminOnly", "false", false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    TRUST_MANAGER_ASK_USER("trustManagerAskUser", "true", false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    PASSWORD_OTP_DELETE("PasswortOTPDelete", "true", false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    USE_2FA_FOR_SIGING("2FAforSigning", "true", true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DELETE_KEYS_ON_LOCK("PasswordDeleteKeys", "false", false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    ALLOW_H005("allowH005", "true", false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DISPLAY_ORDERS_AS_TEXT("displayOrdersAsText", "true", true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    DISPLAY_INTERNAL_INFO("displayInternalInfo", "false", false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    ALLOW_STATE_UPDATE("allowStateUpdate", "false", true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    ALLOW_ONLY_QRCODE_SYNC("allowOnlyQRCode", "true", false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    DISPLAY_BANKS_IN_OTHER_PERSPECTIVES("displayBanksInOtherPerspectives", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    MAX_ACCOUNTS_IN_USER_WIZARD("maxAccountsInUserWizard", String.valueOf(500), false, DatabasePreferenceConstant.DataType.INTEGER, true, false),
    ALLOW_USER_CREATION("allowUserCreation", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    ALLOW_TENANT_CREATION("allowTenantCreation", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    ALLOW_DELETE_STATMENTS("allowDeleteStatements", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    ALLOW_EDIT_BANK_SETTINGS("allowEditBankSettings", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    DS_PRINT_DETAILS_WITH_PAGE_BREAK("dsPrintDetailsWithPageBreak", String.valueOf(false), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    CHECK_KEY_EXPIRATION_DATE("CheckKeyExpirationDate", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false),
    INTERVAL_KEY_EXPIRATION_DATE("IntervalKeyExpirationDate", String.valueOf(3), true, DatabasePreferenceConstant.DataType.INTEGER, false, false),
    ALLOW_ADOPT_BANK_USER("allowAdoptBankUser", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, false),
    REQUIRE_2FA_FOR_LOGIN("require2FAforLogin", String.valueOf(false), false, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    STARTPAGE_BUTTONS("startPageButtons", "127", true, DatabasePreferenceConstant.DataType.BOOLEAN_GROUP, false, false),
    ALLOW_NOTIFICATIONS("allowNotifications", String.valueOf(true), true, DatabasePreferenceConstant.DataType.BOOLEAN, true, true),
    SESSION_TIMEOUT("sessionTimeout", String.valueOf(0), false, DatabasePreferenceConstant.DataType.LONG, true, true),
    HIDE_VOP_HINT("hideVopHint", String.valueOf(false), true, DatabasePreferenceConstant.DataType.BOOLEAN, false, false);

    public static final PreferenceBundleHandler BUNDLE_HANDLER;
    private final String id;
    private String defaultValue;
    private final boolean userSpecific;
    private final DatabasePreferenceConstant.DataType dataType;
    private final boolean onlyAdmin;
    private final boolean onlyAdminOrTenantAdmin;

    private PreferenceConstants(String id, String defaultValue, boolean userSpecific, DatabasePreferenceConstant.DataType dataType, boolean onlyAdmin, boolean onlyAdminOrTenantAdmin) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.userSpecific = userSpecific;
        this.dataType = dataType;
        this.onlyAdmin = onlyAdmin;
        this.onlyAdminOrTenantAdmin = onlyAdminOrTenantAdmin;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    @Override
    public DatabasePreferenceConstant.DataType getType() {
        return this.dataType;
    }

    @Override
    public boolean isOnlyConfigurableByAdmin() {
        return this.onlyAdmin;
    }

    @Override
    public boolean isOnlyConfigurableByAdminOrTenantAdmin() {
        return this.onlyAdminOrTenantAdmin;
    }

    @Override
    public String getLabel(Locale locale) {
        return BUNDLE_HANDLER.getString(this.id, locale);
    }

    @Override
    public String[][] getSelectableOptions(Locale locale) {
        if (this == DS_CLEAN_REJECTED_UNIT || this == DS_CLEAN_SIGNED_UNIT) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.days", new Object[0]), "0"}, {BankingApiMessages.getString(locale, "GeneralMessages.weeks", new Object[0]), "1"}, {BankingApiMessages.getString(locale, "GeneralMessages.months", new Object[0]), "2"}, {BankingApiMessages.getString(locale, "GeneralMessages.years", new Object[0]), "3"}};
        }
        if (this == SALARY_PERMISSIONS) {
            return new String[][]{{BUNDLE_HANDLER.getString("salaryPermissions.all", locale), SALARY_PERMISSION.FULL.toString()}, {BUNDLE_HANDLER.getString("salaryPermissions.partially", locale), SALARY_PERMISSION.PARTIAL.toString()}, {BUNDLE_HANDLER.getString("salaryPermissions.partiallyNoDetail", locale), SALARY_PERMISSION.PARTIAL_NO_DETAILS.toString()}, {BUNDLE_HANDLER.getString("salaryPermissions.none", locale), SALARY_PERMISSION.NO.toString()}};
        }
        if (this == STARTPAGE_BUTTONS) {
            return new String[][]{{BUNDLE_HANDLER.getString("startbutton.eds", locale), BUTTONS_ON_START_PAGE.EDS.getValueAsString()}, {BUNDLE_HANDLER.getString("startbutton.openPayments", locale), BUTTONS_ON_START_PAGE.OPEN_PAYMETS.getValueAsString()}, {BUNDLE_HANDLER.getString("startbutton.cm", locale), BUTTONS_ON_START_PAGE.CM.getValueAsString()}, {BUNDLE_HANDLER.getString("startbutton.banks", locale), BUTTONS_ON_START_PAGE.BANKS.getValueAsString()}, {BUNDLE_HANDLER.getString("startbutton.tenants", locale), BUTTONS_ON_START_PAGE.TENANTS.getValueAsString()}, {BUNDLE_HANDLER.getString("startbutton.send", locale), BUTTONS_ON_START_PAGE.SEND_FILE.getValueAsString()}, {BUNDLE_HANDLER.getString("startbutton.fetch", locale), BUTTONS_ON_START_PAGE.FETCH_FILE.getValueAsString()}};
        }
        return null;
    }

    static {
        BUNDLE_HANDLER = new PreferenceBundleHandler(){

            @Override
            protected ResourceBundle loadBundle(Locale locale) {
                return ResourceBundle.getBundle("de.businesslogics.banking.preferences.PreferenceConstants", locale);
            }
        };
    }

    public static enum SALARY_PERMISSION {
        FULL,
        PARTIAL,
        NO,
        PARTIAL_NO_DETAILS;


        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "1";
                }
                case 2: {
                    return "2";
                }
                case 3: {
                    return "3";
                }
            }
            return null;
        }
    }

    public static enum BUTTONS_ON_START_PAGE {
        EDS(1),
        OPEN_PAYMETS(2),
        CM(4),
        BANKS(8),
        TENANTS(16),
        SEND_FILE(32),
        FETCH_FILE(64);

        private final int value;

        private BUTTONS_ON_START_PAGE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getValueAsString() {
            return String.valueOf(this.value);
        }
    }
}

