/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.preferences;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.PreferenceBundleHandler;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import java.util.Locale;
import java.util.ResourceBundle;

public enum CmPreferenceConstants implements DatabasePreferenceConstant
{
    AUTOMATIC_STA_FETCH("AutomatichSTA", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    AUTOMATIC_VMK_FETCH("AutomaticVMK", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    AUTOMATIC_BKA_FETCH("AutomaticBKA", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    AUTOMATIC_DTI_FETCH("AutomaticDTI", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    REFRESH_WITH_STA_FETCH("RefreshWithStaFetch", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    REFRESH_WITH_VMK_FETCH("RefreshWithVmkFetch", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    REFRESH_WITH_BKA_FETCH("RefreshWithBkaFetch", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    REFRESH_WITH_DTI_FETCH("RefreshWithDtiFetch", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    FETCH_CREDIT_ADVICE_WHEN_NOTIFIED("fetchCreditAdviceWhenNotified", "ASK", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    DELETE_OLD_ADVICES("DeleteOldAdvices", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, true),
    SPLIT_MT940_PURPOSE_INTO_SEPA_TAGS("SplitMt940PurposeIntoSepaTags", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, true),
    ASK_FOR_INITIAL_HISTORY("askForInitialHistory", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, false, false, false),
    HISTORY_TIME_RANGE("historyTimeRange", "20", DatabasePreferenceConstant.DataType.ENUM_COMBO, false, false, true),
    PRINT_PAGE_INFORMATIONS("printPageInformations", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    REPEAT_STATEMENT_INFORMATIONS("repeatStatementInformations", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    NEW_PAGE_ON_PRINT("newPageOnPrint", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_ONE_BOOKING_PER_PAGE("printOneBookingPerPage", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    INSERT_SEPARATOR_BETWEEN_STATEMENTS("insertSeparatorBetweenStatements", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    BALANCES_WITH_ADVICE_INFO("balancesWithAdviceInfo", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    RELATE_FREE_LIQUIDITY_TO_VALUE_BALANCE("relateFreeLiquidityToValueBalance", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_COLUMNS_WITH_VALUE_BALANCES("displayColumnsWithValueBalances", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_COLUMNS_WITH_CREDIT_DEBIT_SUMS("displayColumnsWithCreditDebitSums", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_COLUMNS_WITH_CREDIT_LIMIT("balancesWithCreditLimit", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_COLUMN_STANDARD_ACCOUNT_NAME("displayColumnCMAccountName", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_COLUMN_BANK_ACCOUNT_NAME("displayColumnBankAccountName", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_COLUMN_ACCOUNT_OWNER("displayColumnAccountOwner", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_FULL_PURPOSE("displayFullPurpose", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    VERSION_PREFERENCE_PAGE("versionPreferencePage", String.valueOf(0), DatabasePreferenceConstant.DataType.INTEGER, false, false, false),
    MERGE_SHEETS_IN_STATEMENT_CONVERSION("mergeSheetsInStatementConversion", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    CONVERSION_USE_POSITIVE_DEBITS("conversionUsePositiveDebits", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SHOW_CONVERSIONS("showConversions", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    SHOW_AUTOMATIC_EXPORT("showAutomaticExport", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    SHOW_DTI_VIEW("showDTIView", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    SHOW_BALANCE_LIST_ON_START_PAGE("showBalanceListOnStartpage", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    ENRICH_DTI_INFORMATIONS("enrichDTIInformations", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DTI_MT940_MATCHING_WITH_AMOUNT("dtiMt940MatchingWithAmount", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, true),
    CONVERT_EBCDIC_TO_ASCII("convertEbcdicToAscii", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    TOLERANCE_DTI_MT940_MATCHING("toleranceDtiMt940Matching", String.valueOf(1), DatabasePreferenceConstant.DataType.INTEGER, false, false, true),
    IMPORT_DIR("ImportDir", "", DatabasePreferenceConstant.DataType.FILE, false, false, false),
    DISPLAY_ONLY_SINGLE_BOOKINGS("displayOnlySingleBookings", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_ALL_HTD_ACCOUNTS("displayAllHTDAccounts", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS("displayOnlyAccountsWithPermissions", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    ADD_CHECK_BOXES_TO_ACCOUNT_VIEW("addCheckBoxesToAccounView", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    ADD_CHECK_BOXES_TO_DTI_VIEW("addCheckBoxesToDtiView", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    HIDE_AUTOMATIC_EXPORTS("hideAutomaticExports", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    PRINT_NEW_FETCHED_STATEMENTS("PrintNewFetchedStatements", "ASK", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    PRINT_NEW_IMPORTED_STATEMENTS("PrintNewImportedStatements", "ASK", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    PRINT_NEW_FETCHED_ADVICES("PrintNewFetchedAdvices", "ASK", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    PRINT_NEW_IMPORTED_ADVICES("PrintNewImportedAdvices", "ASK", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    PRINT_NEW_FETCHED_DTI_FILES("PrintNewFetchedDtiFiles", "ASK", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    PRINT_NEW_IMPORTED_DTI_FILES("PrintNewImportedDtiFiles", "ASK", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    PRINT_NEW_DTI_AS_OVERVIEW("PrintNewDtiAsOverview", "false", DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_ALL_BOOKING_DETAILS("PrintAllBookingDetails", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_SINGLE_BOOKINGS("PrintSingleBookings", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    EXPORT_SINGLE_BOOKINGS("exportSingleBookings", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    EXPORT_SINGLE_BOOKINGS_FROM_OTHER_STATEMENTS("exportSingleBookingsFromOtherStatements", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    PRINT_SEPARATELY_PER_BANK("PrintSeparatelyPerBank", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_BOOKING_SORTING("PrintBookingSorting", CmBooking.BookingSorting.UNMODIFIED.name(), DatabasePreferenceConstant.DataType.ENUM_COMBO, true, false, false),
    PRINT_TOTAL_AMOUNT("PrintTotalAmount", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_TOTAL_AMOUNT_PER_STATEMENT("PrintTotalAmountPerStatement", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_ADDITIONAL_STATEMENT_INFO("PrintAdditionalStatementInfo", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_ALTERNATING_BACKGROUND("PrintAlternatingBackground", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PRINT_OVERVIEW_TITLE("PrintOverviewTitle", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    PRINT_ACCOUNT_OWNER("printAccountOwner", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    CLEAN_AUTOMATIC("cleanAutomatic", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_STATEMENTS("cleanStatements", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_ADVICES("cleanAdvices", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_DTI_FILES("cleanDtiFiles", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_BKA_STATEMENTS("cleanBkaStatements", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_STATEMENTS_AGE("cleanStatementsAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_ADVICES_AGE("cleanFetchAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_DTI_FILES_AGE("cleanDtiFilesAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_BKA_STATEMENTS_AGE("cleanBkaStatementsAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    CLEAN_STATEMENTS_UNIT("cleanStamentsUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_ADVICES_UNIT("cleanAdvicesUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_DTI_FILES_UNIT("cleanDtiFilesUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_BKA_STATEMENTS_UNIT("cleanBkaStatementsUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_EMPTY_DIRECTORIES("cleanEmptyDirectories", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    CLEAN_EXPORTED_FILES("cleanExportedFiles", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CLEAN_EXPORTED_FILES_UNIT("cleanExportedFilesUnit", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_COMBO, false, true, false),
    CLEAN_EXPORTED_FILES_AGE("cleanExportedFilesAge", String.valueOf(5), DatabasePreferenceConstant.DataType.INTEGER, false, true, false),
    AUTOMATIC_EXPORT_INFO_HIDE("automaticExportInfoHide", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    AUTOMATIC_IMPORT_PROBLEM_HIDE("automaticImportProblemHide", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    DB_MIGRATION_DONE("dbMigrationDone", null, DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    SHOW_CM_FOLDER("showCmFolder", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    AUTOMATIC_EXPORT_LANGUAGE("automaticExportLanguage", "default", DatabasePreferenceConstant.DataType.ENUM_COMBO, true, false, false),
    STATEMENTVIEW_PERIOD_FILTER("statementPeriodFilter", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    STATEMENTVIEW_PERIOD_START("statementPeriodStart", String.valueOf(-1), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    STATEMENTVIEW_PERIOD_END("statementPeriodEnd", String.valueOf(-1), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    DTIVIEW_PERIOD_FILTER("dtiPeriodFilter", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DTIVIEW_PERIOD_START("dtiPeriodStart", String.valueOf(-1), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    DTIVIEW_PERIOD_END("dtiPeriodEnd", String.valueOf(-1), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    PRINT_ACCOUNT_OVERVIEW_GROUPING("PrintAccountOverviewGrouping", "NONE", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    PRINT_BOOKING_OVERVIEW_GROUPING("PrintBookingOverviewGrouping", String.valueOf(2), DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    BKA_FETCH_INFO_HIDE("bkaFetchInfoHide", "prompt", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    BKA_EXPORT_DIRECTORY("BkaExportDirectory", null, DatabasePreferenceConstant.DataType.STRING, false, true, false),
    BKI_EXPORT_DIRECTORY("BkiExportDirectory", null, DatabasePreferenceConstant.DataType.STRING, false, true, false),
    C54_EXPORT_DIRECTORY("C54ExportDirectory", null, DatabasePreferenceConstant.DataType.STRING, false, true, false),
    CLEANUP_DATE_TYPE("cleanupDateType", String.valueOf(3), DatabasePreferenceConstant.DataType.ENUM_RADIO, false, true, false),
    ALLOW_ACCOUNT_RENAMING_FOR_NONADMINS("renameAccountsForNonAdmins", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, true),
    HIGHLIGHT_NEW_STATEMENTS("highlightNewStatements", "AUTO", DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    CONNECT_PAYMENTS_WITH_BOOKING("connectPaymentsWithBooking", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    CREATE_VIRTUAL_STATEMENTS("createVirtualStatements", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    DISPLAY_VIRTUAL_STATEMENTS("displayVirtualStatements", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    CM_LOGGER("CmLogger", null, DatabasePreferenceConstant.DataType.STRING, false, false, false);

    private static final PreferenceBundleHandler BUNDLE_HANDLER;
    private final String id;
    private String defaultValue;
    private final DatabasePreferenceConstant.DataType type;
    private final boolean userSpecific;
    private final boolean onlyAdmin;
    private final boolean onlyAdminOrTenantAdmin;

    private CmPreferenceConstants(String id, String defaultValue, DatabasePreferenceConstant.DataType type, boolean userSpecific, boolean onlyAdmin, boolean onlyAdminOrTenantAdmin) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.type = type;
        this.userSpecific = userSpecific;
        this.onlyAdmin = onlyAdmin;
        this.onlyAdminOrTenantAdmin = onlyAdminOrTenantAdmin;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    @Override
    public DatabasePreferenceConstant.DataType getType() {
        return this.type;
    }

    @Override
    public boolean isOnlyConfigurableByAdmin() {
        return this.onlyAdmin;
    }

    @Override
    public boolean isOnlyConfigurableByAdminOrTenantAdmin() {
        return this.onlyAdminOrTenantAdmin;
    }

    @Override
    public String getLabel(Locale locale) {
        return BUNDLE_HANDLER.getString(this.id, locale);
    }

    @Override
    public String[][] getSelectableOptions(Locale locale) {
        if (this == ASK_FOR_INITIAL_HISTORY) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.yes", new Object[0]), "always"}, {BankingApiMessages.getString(locale, "GeneralMessages.no", new Object[0]), "never"}, {BankingApiMessages.getString(locale, "GeneralMessages.alwaysAsk", new Object[0]), "prompt"}};
        }
        if (this == HISTORY_TIME_RANGE) {
            return new String[][]{{BUNDLE_HANDLER.getString("history.sevenDays", locale), "7"}, {BUNDLE_HANDLER.getString("history.twoWeeks", locale), "14"}, {BUNDLE_HANDLER.getString("history.twentyDays", locale), "20"}, {BUNDLE_HANDLER.getString("history.fourWeeks", locale), "28"}, {BUNDLE_HANDLER.getString("history.nintyDays", locale), "90"}, {BUNDLE_HANDLER.getString("history.sixMonth", locale), "180"}, {BUNDLE_HANDLER.getString("history.twelveMonth", locale), "365"}};
        }
        if (this == PRINT_NEW_FETCHED_STATEMENTS || this == PRINT_NEW_IMPORTED_STATEMENTS || this == PRINT_NEW_FETCHED_ADVICES || this == PRINT_NEW_IMPORTED_ADVICES || this == PRINT_NEW_FETCHED_DTI_FILES || this == PRINT_NEW_IMPORTED_DTI_FILES || this == FETCH_CREDIT_ADVICE_WHEN_NOTIFIED) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.yes", new Object[0]), "YES"}, {BankingApiMessages.getString(locale, "GeneralMessages.no", new Object[0]), "NO"}, {BankingApiMessages.getString(locale, "GeneralMessages.alwaysAsk", new Object[0]), "ASK"}};
        }
        if (this == AUTOMATIC_EXPORT_INFO_HIDE || this == AUTOMATIC_IMPORT_PROBLEM_HIDE) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.yes", new Object[0]), "always"}, {BankingApiMessages.getString(locale, "GeneralMessages.no", new Object[0]), "never"}, {BankingApiMessages.getString(locale, "GeneralMessages.alwaysAsk", new Object[0]), "prompt"}};
        }
        if (this == PRINT_BOOKING_SORTING) {
            return new String[][]{{BUNDLE_HANDLER.getString("sorting.unmodified", locale), CmBooking.BookingSorting.UNMODIFIED.name()}, {BUNDLE_HANDLER.getString("sorting.credit_debit_valuedate_amount", locale), CmBooking.BookingSorting.CREDIT_DEBIT_VALUEDATE_AMOUNT.name()}, {BUNDLE_HANDLER.getString("sorting.debit_credit_valuedate_amount", locale), CmBooking.BookingSorting.DEBIT_CREDIT_VALUEDATE_AMOUNT.name()}, {BUNDLE_HANDLER.getString("sorting.credit_debit_amount", locale), CmBooking.BookingSorting.CREDIT_DEBIT_AMOUNT.name()}, {BUNDLE_HANDLER.getString("sorting.debit_credit_amount", locale), CmBooking.BookingSorting.DEBIT_CREDIT_AMOUNT.name()}};
        }
        if (this == CLEAN_STATEMENTS_UNIT || this == CLEAN_ADVICES_UNIT || this == CLEAN_DTI_FILES_UNIT || this == CLEAN_BKA_STATEMENTS_UNIT || this == CLEAN_EXPORTED_FILES_UNIT) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.days", new Object[0]), "0"}, {BankingApiMessages.getString(locale, "GeneralMessages.weeks", new Object[0]), "1"}, {BankingApiMessages.getString(locale, "GeneralMessages.months", new Object[0]), "2"}, {BankingApiMessages.getString(locale, "GeneralMessages.years", new Object[0]), "3"}};
        }
        if (this == CLEANUP_DATE_TYPE) {
            return new String[][]{{BUNDLE_HANDLER.getString("cleanupDateType.statementDate", locale), CmStatement.CleanupDateType.STATEMENT_DATE.name()}, {BUNDLE_HANDLER.getString("cleanupDateType.newestBookingDate", locale), CmStatement.CleanupDateType.BOOKING_DATE.name()}, {BUNDLE_HANDLER.getString("cleanupDateType.newestValueDate", locale), CmStatement.CleanupDateType.VALUE_DATE.name()}};
        }
        if (this == AUTOMATIC_EXPORT_LANGUAGE) {
            return new String[][]{{BUNDLE_HANDLER.getString("language.default", locale), "default"}, {BUNDLE_HANDLER.getString("language.de", locale), "de"}, {BUNDLE_HANDLER.getString("language.en", locale), "en"}, {BUNDLE_HANDLER.getString("language.fr", locale), "fr"}, {BUNDLE_HANDLER.getString("language.es", locale), "es"}, {BUNDLE_HANDLER.getString("language.pt", locale), "pt"}, {BUNDLE_HANDLER.getString("language.pl", locale), "pl"}, {BUNDLE_HANDLER.getString("language.nl", locale), "nl"}};
        }
        if (this == PRINT_ACCOUNT_OVERVIEW_GROUPING) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.none", new Object[0]), "NONE"}, {BUNDLE_HANDLER.getString("grouping.byBanks", locale), "BY_BANKS"}, {BUNDLE_HANDLER.getString("grouping.byCurrencies", locale), "BY_CURRENCIES"}};
        }
        if (this == PRINT_BOOKING_OVERVIEW_GROUPING) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.none", new Object[0]), "NONE"}, {BUNDLE_HANDLER.getString("grouping.byAccounts", locale), "BY_ACCOUNTS"}};
        }
        if (this == HIGHLIGHT_NEW_STATEMENTS) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.bank.state.deactivated", new Object[0]), "NONE"}, {BUNDLE_HANDLER.getString("highlightNewStatements.checkAutomatically", locale), "AUTO"}, {BUNDLE_HANDLER.getString("highlightNewStatements.checkManually", locale), "MANUAL"}};
        }
        return null;
    }

    static {
        BUNDLE_HANDLER = new PreferenceBundleHandler(){

            @Override
            protected ResourceBundle loadBundle(Locale locale) {
                return ResourceBundle.getBundle("de.businesslogics.banking.preferences.CmPreferenceConstants", locale);
            }
        };
    }
}

