/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.core;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.PreferenceBundleHandler;
import de.businesslogics.banking.api.SignedPaymentsUtil;
import java.util.Locale;
import java.util.ResourceBundle;

public enum PreferenceConstants implements DatabasePreferenceConstant
{
    ALLOW_INVALID_BANK_CONNECTION("allowInvalidBankConnection", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    ALLOW_WRONG_CHECK_DIGIT("allowWrongCheckDigit", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    CURRENCY_URL("currencyURL", "https://www.blbanking.de/license/exchangeRate", DatabasePreferenceConstant.DataType.STRING, false, false, false),
    PERIODIC_PREFIX_IN_WORKING_DAYS("periodicPrefixInDays", String.valueOf(6), DatabasePreferenceConstant.DataType.INTEGER, false, false, true),
    DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION("displayOnlyPaymentsWithPermission", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    CHECK_PERMISSION_FOR_PAYMENT_RECORDING("checkPermissionForPaymentRecording", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, true),
    SHOW_ALL_SIGNED_PAYMENTS("onlyAllSignedPayments", String.valueOf(SignedPaymentsUtil.createSignedPaymentsDefault()), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    SEND_PAYMENTS_SEPARATELY("sendPaymentsSeparately", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SHOW_ACCOUNT_NAME_WITH_IBAN("showAccountNameWithIban", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PAYMENTS_SHOW_IBAN_COLUMN("paymentsShowIbanColumn", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SHOW_RECIPIENT_WITH_ACCOUNT_NUMBER("paymentsShowAccNumberInRecipientColumn", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    ANOTHER_PAYMENT_DIALOG("AnotherPaymentDialog", AnotherPaymentDialog.ASK.name(), DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    DISPLAY_SAVE_RECIPIENT_BUTTON("displaySaveRecipientButton", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    SAVE_RECIPIENT("saveRecipient", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    SAVE_RECIPIENT_WITH_PURPOSE("saveRecipientWithPurpose", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    NEW_PAGE_ON_PRINT("newPageOnPrint", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    GROUP_PAYMENTS_IN_OVERVIEW("groupPaymentsInOverview", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    OVERWRITE_RECIPIENT_DATA("overwriteRecipientData", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    DISPLAY_RECIPIENTS_WITH_ACCOUNT_NUMBER("displayRecipientsWithAccountNumber", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    INITIALIZATION_OF_ACC_AND_ORIG("initializationOfAccAndOrig", InitializationOfAccAndOrig.WITH_PREVIOUS_VALUES.name(), DatabasePreferenceConstant.DataType.ENUM_RADIO, true, false, false),
    ALLOW_ORIGINATOR_RECORDING("allowOriginatorRecording", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, false),
    ALLOW_RECIPIENT_RECORDING("allowRecipientRecording", RecipientRecoding.ALLOWED.name(), DatabasePreferenceConstant.DataType.ENUM_RADIO, false, true, false),
    ALLOW_UNKNOWN_ACCOUNTS("allowUnknownAccounts", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    MAX_ENTRIES_FOR_RECIPIENT_POPUP("maxEntriesForRecipientPopup", String.valueOf(200), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    LIMIT_FOR_ACCOUNT_SELECTOR("limitForAccountSelector", String.valueOf(1), DatabasePreferenceConstant.DataType.INTEGER, true, false, false),
    DISABLE_CURRENCY_UPDATE("disableCurrencyUpdate", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    SHOW_PAYMENT_FOLDER("showPaymentFolder", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    FETCH_RECIPIENT_ACCOUNTS("dteFetchRecipientAccounts", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    DISPLAY_COLUMNS_WITH_ACCOUNT_NUMBERS("displayColumnsWithAccountNumbers", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, true, false, false),
    PAYMENTS_MIGRATION_DONE("paymentsMigrationDone", null, DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    CHECK_ADDRESSES_DK("checkAdressesDK", String.valueOf(true), DatabasePreferenceConstant.DataType.BOOLEAN, false, false, false),
    CHECK_LIMIT("checkLimit", String.valueOf(false), DatabasePreferenceConstant.DataType.BOOLEAN, false, true, true);

    private static final PreferenceBundleHandler BUNDLE_HANDLER;
    private final String id;
    private String defaultValue;
    private final boolean userSpecific;
    private final DatabasePreferenceConstant.DataType type;
    private final boolean onlyAdmin;
    private final boolean onlyAdminOrTenantAdmin;

    private PreferenceConstants(String id, String defaultValue, DatabasePreferenceConstant.DataType type, boolean userSpecific, boolean onlyAdmin, boolean onlyAdminOrTenantAdmin) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.type = type;
        this.userSpecific = userSpecific;
        this.onlyAdmin = onlyAdmin;
        this.onlyAdminOrTenantAdmin = onlyAdminOrTenantAdmin;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    @Override
    public DatabasePreferenceConstant.DataType getType() {
        return this.type;
    }

    @Override
    public boolean isOnlyConfigurableByAdmin() {
        return this.onlyAdmin;
    }

    @Override
    public boolean isOnlyConfigurableByAdminOrTenantAdmin() {
        return this.onlyAdminOrTenantAdmin;
    }

    @Override
    public String getLabel(Locale locale) {
        return BUNDLE_HANDLER.getString(this.id, locale);
    }

    @Override
    public String[][] getSelectableOptions(Locale locale) {
        if (this == ANOTHER_PAYMENT_DIALOG) {
            return new String[][]{{BankingApiMessages.getString(locale, "GeneralMessages.alwaysAsk", new Object[0]), AnotherPaymentDialog.ASK.name()}, {BankingApiMessages.getString(locale, "GeneralMessages.yes", new Object[0]), AnotherPaymentDialog.YES.name()}, {BankingApiMessages.getString(locale, "GeneralMessages.no", new Object[0]), AnotherPaymentDialog.NO.name()}};
        }
        if (this == INITIALIZATION_OF_ACC_AND_ORIG) {
            return new String[][]{{BUNDLE_HANDLER.getString("initializationOfAccAndOrig.withPreviousValues", locale), InitializationOfAccAndOrig.WITH_PREVIOUS_VALUES.name()}, {BUNDLE_HANDLER.getString("initializationOfAccAndOrig.withFixedValues", locale), InitializationOfAccAndOrig.WITH_FIXED_VALUES.name()}, {BankingApiMessages.getString(locale, "GeneralMessages.none", new Object[0]), InitializationOfAccAndOrig.NONE.name()}};
        }
        if (this == ALLOW_RECIPIENT_RECORDING) {
            return new String[][]{{BUNDLE_HANDLER.getString("recipientRecording.allowed", locale), RecipientRecoding.ALLOWED.name()}, {BUNDLE_HANDLER.getString("recipientRecording.allowedInFourEyesPrinciple", locale), RecipientRecoding.FOUR_EYES.name()}, {BUNDLE_HANDLER.getString("recipientRecording.notAllowed", locale), RecipientRecoding.DENIED.name()}};
        }
        return null;
    }

    static {
        BUNDLE_HANDLER = new PreferenceBundleHandler(){

            @Override
            protected ResourceBundle loadBundle(Locale locale) {
                return ResourceBundle.getBundle("de.businesslogics.banking.payments.core.PreferenceConstants", locale);
            }
        };
    }

    public static enum AnotherPaymentDialog {
        ASK,
        YES,
        NO;

    }

    public static enum InitializationOfAccAndOrig {
        WITH_PREVIOUS_VALUES,
        WITH_FIXED_VALUES,
        NONE;

    }

    public static enum RecipientRecoding {
        ALLOWED,
        FOUR_EYES,
        DENIED;

    }
}

