/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.CsvColumnSeparator;
import de.businesslogics.format.csv.XLSUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public final class TableFileReader {
    private final CsvColumnSeparator separator;
    private final Charset charset;
    private List<String[]> data;
    private int maxColumns;

    public TableFileReader(CsvColumnSeparator separator, Charset charset, int minColumns) {
        this.separator = separator;
        this.charset = charset;
        this.maxColumns = minColumns;
    }

    public void readFile(File file) throws Exception {
        if (XLSUtil.isXLS(file)) {
            this.readXslFile(file, -1);
        } else {
            this.readCsvFile(file);
        }
    }

    public void readXslFile(File file, int sheetIndex) throws Exception {
        if (sheetIndex < 0) {
            Workbook workbook = XLSUtil.createWorkbook(file);
            block0: for (int sheetNumber = 0; sheetNumber < workbook.getNumberOfSheets(); ++sheetNumber) {
                Sheet sheet = workbook.getSheetAt(sheetNumber);
                for (int rowNumber = 0; rowNumber < sheet.getLastRowNum(); ++rowNumber) {
                    Row row = sheet.getRow(rowNumber);
                    if (row == null || row.getLastCellNum() <= row.getFirstCellNum()) continue;
                    sheetIndex = sheetNumber;
                    continue block0;
                }
            }
            if (sheetIndex < 0) {
                throw new IOException("Failed to open empty XLS file!");
            }
        }
        this.data = null;
        for (String[] line : XLSUtil.getLinesFromXLS(file, sheetIndex)) {
            if (line == null || line.length == 0) continue;
            if (this.data == null) {
                this.data = new ArrayList<String[]>();
            }
            this.data.add(line);
            this.maxColumns = Math.max(this.maxColumns, line.length);
        }
    }

    public void readCsvFile(File file) throws IOException {
        this.data = null;
        try (Scanner scanner = new Scanner(file, this.charset.name());){
            this.readCsvFile(scanner);
        }
    }

    public void readCsvFile(InputStream inputStream) {
        this.data = null;
        try (Scanner scanner = new Scanner(inputStream);){
            this.readCsvFile(scanner);
        }
    }

    public void readCsvFile(Scanner scanner) {
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            ArrayList<String> fields = new ArrayList<String>();
            int linePos = 0;
            boolean inQuotes = false;
            for (int i = 0; i < line.length(); ++i) {
                if (line.charAt(i) == '\"') {
                    inQuotes = !inQuotes;
                    continue;
                }
                if (inQuotes || line.charAt(i) != this.separator.getSeparator()) continue;
                fields.add(this.getCsvField(line, linePos, i));
                linePos = i + 1;
            }
            fields.add(this.getCsvField(line, linePos, line.length()));
            if (this.data == null) {
                this.data = new ArrayList<String[]>();
            }
            if (fields.isEmpty()) continue;
            this.data.add(fields.toArray(new String[fields.size()]));
            this.maxColumns = Math.max(this.maxColumns, fields.size());
        }
    }

    public String[] getHeadLine() {
        if (this.data == null || this.data.isEmpty()) {
            return new String[0];
        }
        return this.fixArraySize(this.data.get(0), this.maxColumns);
    }

    public String[][] getTableContent(boolean hasHeadLine) {
        if (this.data == null || this.data.isEmpty() || hasHeadLine && this.data.size() == 1) {
            return new String[0][0];
        }
        int startPos = hasHeadLine ? 1 : 0;
        String[][] result = new String[this.data.size() - startPos][];
        for (int i = 0; i < this.data.size() - startPos; ++i) {
            result[i] = this.fixArraySize(this.data.get(i + startPos), this.maxColumns);
        }
        return result;
    }

    private String getCsvField(String line, int startPos, int endPos) {
        String result = startPos < endPos - 1 && line.charAt(startPos) == '\"' && line.charAt(endPos - 1) == '\"' ? line.substring(startPos + 1, endPos - 1) : line.substring(startPos, endPos);
        return result.replace("\"\"", "\"");
    }

    private String[] fixArraySize(String[] array, int length) {
        String[] result = new String[length];
        int pos = 0;
        if (array != null && array.length < length) {
            System.arraycopy(array, 0, result, 0, array.length);
            pos = array.length;
        } else if (array != null) {
            System.arraycopy(array, 0, result, 0, length);
            pos = length;
        }
        while (pos < length) {
            result[pos++] = "";
        }
        return result;
    }
}

