/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AbstractTableOverviewPrinter;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public abstract class SignedPaymentsTableOverviewPrinter
extends AbstractTableOverviewPrinter<SignedPayment> {
    public SignedPaymentsTableOverviewPrinter(User user, Locale locale, BLLogger logger) {
        super(user, locale, logger, Util.printLogo(user));
    }

    public SignedPaymentsTableOverviewPrinter(User user, Locale locale, BLLogger logger, boolean printLogo) {
        super(user, locale, logger, printLogo);
    }

    @Override
    protected final Map<String, Map<String, List<SignedPayment>>> groupPayments(List<SignedPayment> payments) {
        TreeMap<String, Map<String, List<SignedPayment>>> result = new TreeMap<String, Map<String, List<SignedPayment>>>();
        for (SignedPayment signedPayment : payments) {
            ArrayList<SignedPayment> paymentList;
            String sendKey = signedPayment.getSend().getBank().getDisplayName() + ' ' + signedPayment.getSend().getOriginalSendType() + ' ' + signedPayment.getSend().getOrderNumber();
            TreeMap<String, ArrayList<SignedPayment>> sendMap = (TreeMap<String, ArrayList<SignedPayment>>)result.get(sendKey);
            if (sendMap == null) {
                sendMap = new TreeMap<String, ArrayList<SignedPayment>>();
                result.put(sendKey, sendMap);
            }
            String name = "";
            if (signedPayment.getAccount() != null) {
                name = signedPayment.getAccount().getName();
            }
            if ((paymentList = (ArrayList<SignedPayment>)sendMap.get(name)) == null) {
                paymentList = new ArrayList<SignedPayment>();
                sendMap.put(name, paymentList);
            }
            paymentList.add(signedPayment);
        }
        return result;
    }

    @Override
    protected int[] getTableColumnsWidths(boolean withOrderTypeColumn) {
        if (withOrderTypeColumn) {
            return new int[]{13, 12, 12, 12, 9, 15, 7, 8};
        }
        return new int[]{15, 15, 10, 17, 7, 12};
    }

    @Override
    protected void printTableHeader(BLTable table, boolean withOrderTypeColumn) throws PDFException {
        if (withOrderTypeColumn) {
            table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]), FONT);
            table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.order", new Object[0]), FONT);
            table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.state", new Object[0]), FONT);
        }
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.recipient", new Object[0]), FONT);
        if (!withOrderTypeColumn) {
            table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]), FONT);
        }
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.refNumberPayment", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.purpose", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.date", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]), FONT);
    }

    @Override
    protected void printPayment(BLTable table, SignedPayment payment, boolean withOrderTypeColumn) throws PDFException {
        if (withOrderTypeColumn) {
            table.addCell(this.getPaymentAccountRepresentation(payment), FONT);
            table.addCell(this.getPaymentOrderType(payment), FONT);
            table.addCell(this.getOrderState(payment), FONT);
        }
        table.addCell(payment.getRecipient(), FONT);
        if (!withOrderTypeColumn) {
            table.addCell(this.getRecipientAccountRepresentation(payment), FONT);
        }
        table.addCell(payment.getReference(), FONT);
        table.addCell(payment.getPurpose(), FONT);
        if (payment.getExecutionDate() != null) {
            table.addCell(DateFormat.getDateInstance(2, this.locale).format(payment.getExecutionDate()), FONT);
        } else {
            table.addCell("", FONT);
        }
        if (this.displaySalaries || !this.isSalaryPayment(payment)) {
            table.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
            table.addCell(PaymentUtils.formatAmount(payment.getAmount(), Currency.getInstance(payment.getAmountCurrency()), this.locale), FONT);
            table.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        } else {
            table.addCell("", FONT);
        }
    }

    @Override
    protected String getDocumentTitle() {
        return BankingApiMessages.getString(this.locale, "GeneralMessages.signedPayments", new Object[0]);
    }

    @Override
    protected String getTempFilePrefix() {
        return BankingApiMessages.getString(this.locale, "GeneralMessages.signedPayments", new Object[0]);
    }

    @Override
    protected String getPaymentBankName(SignedPayment payment) {
        return payment.getSend().getBank().getDisplayName();
    }

    @Override
    protected String getPaymentAccountRepresentation(SignedPayment payment) {
        if (payment.getAccount() != null) {
            StringBuilder sb = new StringBuilder(payment.getAccount().getName());
            if (this.usePrefAccountNameAndIban && payment.getAccount().getIban() != null && !payment.getAccount().getIban().isEmpty()) {
                sb.append("(").append(payment.getAccount().getIban()).append(")");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    protected BigDecimal getPaymentAmount(SignedPayment payment) {
        return this.getPaymentAmount(payment.getAmount(), payment.isSalaryPayment());
    }

    @Override
    protected Currency getPaymentAmountCurrency(SignedPayment payment) {
        return Currency.getInstance(payment.getAmountCurrency());
    }

    @Override
    protected boolean isSalaryPayment(SignedPayment payment) {
        return payment.isSalaryPayment();
    }
}

