/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public abstract class SignedPaymentsTableCsvExport
extends AbstractCsvExport<SignedPayment> {
    private final Locale locale;
    private final boolean displaySalaryAmounts;
    private final boolean ibanColumn;

    public SignedPaymentsTableCsvExport(Locale locale, boolean displaySalaryAmounts) {
        this(locale, displaySalaryAmounts, false);
    }

    public SignedPaymentsTableCsvExport(Locale locale, boolean displaySalaryAmounts, boolean ibanColumn) {
        this.locale = locale;
        this.displaySalaryAmounts = displaySalaryAmounts;
        this.ibanColumn = ibanColumn;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]));
        if (this.ibanColumn) {
            this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.iban", new Object[0]));
        }
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.state", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.order", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.refNumberPayment", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.recipient", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.currency", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.purpose", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.executionDate", new Object[0]));
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, SignedPayment payment) throws IOException {
        if (payment.getAccount() != null) {
            this.addCell(writer, payment.getAccount().getName());
            if (this.ibanColumn) {
                this.addCell(writer, payment.getAccount().getIban());
            }
        } else {
            this.addCell(writer, "");
            if (this.ibanColumn) {
                this.addCell(writer, "");
            }
        }
        this.addCell(writer, this.getState(payment));
        this.addCell(writer, payment.getSend().getOrderNumber());
        this.addCell(writer, payment.getReference());
        this.addCell(writer, payment.getRecipient());
        if (this.displaySalaryAmounts || !payment.isSalaryPayment()) {
            Currency currency = Currency.getInstance(payment.getAmountCurrency());
            this.addCell(writer, PaymentUtils.formatAmount(payment.getAmount(), null, currency.getDefaultFractionDigits(), this.locale), true);
            this.addCell(writer, currency.getCurrencyCode());
        } else {
            this.addCell(writer, null);
            this.addCell(writer, null);
        }
        this.addCell(writer, payment.getPurpose());
        if (payment.getExecutionDate() != null) {
            this.addCell(writer, Util.getFormattedExecutionTime(payment.getExecutionDate(), this.locale));
        } else {
            this.addCell(writer, null);
        }
        return true;
    }

    protected abstract String getState(SignedPayment var1);
}

