/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.util.DateUtils;
import java.util.Calendar;
import java.util.Date;

public final class ScheduleHandler {
    private final PeriodicPayment periodicPayment;

    public ScheduleHandler(PeriodicPayment periodicPayment) {
        this.periodicPayment = periodicPayment;
    }

    public PeriodicPayment getPeriodicPayment() {
        return this.periodicPayment;
    }

    public void calculateLastExecutionDate(int numberOfExecutions) {
        if (this.periodicPayment.getFirstExecutionDate() == null || this.periodicPayment.getExecutionInterval() == null || numberOfExecutions == 0) {
            this.periodicPayment.setLastExecutionDate(null);
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.periodicPayment.getFirstExecutionDate());
        this.calculateMultiple(cal, this.periodicPayment.getExecutionInterval(), numberOfExecutions - 1);
        this.periodicPayment.setLastExecutionDate(new java.sql.Date(cal.getTimeInMillis()));
    }

    public void calculateFirstExecutionDate(int numberOfExecutions) {
        Calendar cal = Calendar.getInstance();
        if (!(this.periodicPayment.getFirstExecutionDate() != null && DateUtils.getCurrentDateWithoutTimeStamp().after(this.periodicPayment.getFirstExecutionDate()) || this.periodicPayment.getLastExecutionDate() != null)) {
            cal.setTime(this.periodicPayment.getFirstExecutionDate());
            this.calculateMultiple(cal, this.periodicPayment.getExecutionInterval(), 0);
        } else if (this.periodicPayment.getLastExecutionDate() != null) {
            cal.setTime(this.periodicPayment.getLastExecutionDate());
            this.calculateMultiple(cal, this.periodicPayment.getExecutionInterval(), 1 - numberOfExecutions);
        } else {
            return;
        }
        this.periodicPayment.setFirstExecutionDate(new java.sql.Date(cal.getTimeInMillis()));
    }

    public void calculateNextExecutionDate(Date advanceDate) {
        if (this.periodicPayment.getFirstExecutionDate() == null || this.periodicPayment.getExecutionInterval() == null) {
            this.periodicPayment.setNextExecutionDate(null);
            return;
        }
        if (advanceDate.before(this.periodicPayment.getFirstExecutionDate())) {
            this.periodicPayment.setNextExecutionDate(this.periodicPayment.getFirstExecutionDate());
            return;
        }
        if (this.periodicPayment.getLastExecutionDate() != null && advanceDate.after(this.periodicPayment.getLastExecutionDate())) {
            this.periodicPayment.setNextExecutionDate(null);
            return;
        }
        Calendar cal = Calendar.getInstance();
        if (this.periodicPayment.getNextExecutionDate() != null) {
            cal.setTime(this.periodicPayment.getNextExecutionDate());
        } else if (this.periodicPayment.getPreviousExecutionDate() != null) {
            cal.setTime(this.periodicPayment.getPreviousExecutionDate());
        } else {
            cal.setTime(this.periodicPayment.getFirstExecutionDate());
        }
        this.calculateMultiple(cal, this.periodicPayment.getExecutionInterval(), 1);
        if (this.periodicPayment.getLastExecutionDate() != null && this.periodicPayment.getLastExecutionDate().before(cal.getTime())) {
            this.periodicPayment.setNextExecutionDate(null);
        } else {
            this.periodicPayment.setNextExecutionDate(new java.sql.Date(cal.getTimeInMillis()));
        }
    }

    public int determineNumberOfExecutions() {
        if (this.periodicPayment.getFirstExecutionDate() == null || this.periodicPayment.getLastExecutionDate() == null) {
            return 0;
        }
        int numberOfExecutions = 1;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.periodicPayment.getFirstExecutionDate());
        while (cal.getTime().before(this.periodicPayment.getLastExecutionDate())) {
            cal.setTime(this.periodicPayment.getFirstExecutionDate());
            this.calculateMultiple(cal, this.periodicPayment.getExecutionInterval(), numberOfExecutions);
            ++numberOfExecutions;
        }
        return numberOfExecutions;
    }

    private void calculateMultiple(Calendar cal, PeriodicPayment.ExecutionInterval executionInterval, int numberOfRepeats) {
        if (executionInterval == PeriodicPayment.ExecutionInterval.MONTHLY) {
            int dayOfMonth = cal.get(5);
            cal.add(2, numberOfRepeats);
            this.checkDayOfMonth(cal, dayOfMonth);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.TWO_MONTHS) {
            int dayOfMonth = cal.get(5);
            cal.add(2, numberOfRepeats * 2);
            this.checkDayOfMonth(cal, dayOfMonth);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.THREE_MONTHS) {
            int dayOfMonth = cal.get(5);
            cal.add(2, numberOfRepeats * 3);
            this.checkDayOfMonth(cal, dayOfMonth);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.SIX_MONTHS) {
            int dayOfMonth = cal.get(5);
            cal.add(2, numberOfRepeats * 6);
            this.checkDayOfMonth(cal, dayOfMonth);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.YEAR) {
            int dayOfMonth = cal.get(5);
            cal.add(1, numberOfRepeats);
            this.checkDayOfMonth(cal, dayOfMonth);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.MONTH_ULTIMO) {
            cal.add(2, numberOfRepeats);
            DateUtils.getMonthUltimoTargetDay(cal);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.QUARTER_ULTIMO) {
            cal.add(2, numberOfRepeats * 3);
            DateUtils.getQuarterUltimoTargetDay(cal);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.YEAR_ULTIMO) {
            cal.add(1, numberOfRepeats);
            DateUtils.getYearsUltimoTargetDay(cal);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.WEEKLY) {
            cal.add(5, numberOfRepeats * 7);
        } else if (executionInterval == PeriodicPayment.ExecutionInterval.TWO_WEEKS) {
            cal.add(5, numberOfRepeats * 14);
        } else {
            return;
        }
    }

    private Calendar checkDayOfMonth(Calendar cal, int dayOfMonth) {
        if (cal.get(5) < dayOfMonth) {
            int originalMonth = cal.get(2);
            cal.set(5, dayOfMonth);
            while (cal.get(2) != originalMonth) {
                cal.add(5, -1);
            }
        }
        return cal;
    }
}

