/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.format.AddressData;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;

public abstract class RecipientData {
    private static final String ADDRESS_LINE_SEPARATOR = "|";
    private boolean bypassFourEyes = false;
    private boolean savePermanently = true;
    private PaymentRecipient paymentRecipient;

    public final void setBypassFourEyes(boolean bypassFourEyes) {
        this.bypassFourEyes = bypassFourEyes;
    }

    public final void setSavePermanently(boolean savePermanently) {
        this.savePermanently = savePermanently;
    }

    public static String getUniqueDisplayName(String name, PaymentType paymentType, Tenant tenant) {
        PaymentRecipient paymentRecipient;
        Object displayName = name;
        int nextId = 1;
        do {
            if ((paymentRecipient = PaymentRecipient.findNonHistoricRecipientByDisplayName(paymentType, (String)displayName, tenant)) == null) {
                return displayName;
            }
            displayName = name + "." + nextId++;
        } while (paymentRecipient != null);
        return null;
    }

    protected static String getAddressAsString(AddressData data) {
        if (data != null) {
            StringBuilder sb = new StringBuilder();
            boolean isFirstString = true;
            for (String str : data.getAddressLines()) {
                if (str == null || str.trim().length() <= 0) continue;
                if (isFirstString) {
                    isFirstString = false;
                } else {
                    sb.append(ADDRESS_LINE_SEPARATOR);
                }
                sb.append(str.trim());
            }
            return sb.toString();
        }
        return "";
    }

    protected static void writeCsvFieldToWriter(Writer writer, String csvField, boolean lastField, char columnSeparator, String lineSeparator) throws IOException {
        RecipientData.writeCsvFieldToWriter(writer, csvField, false, lastField, columnSeparator, lineSeparator);
    }

    protected static void writeCsvFieldToWriter(Writer writer, String csvField, boolean isNumber, boolean lastField, char columnSeparator, String lineSeparator) throws IOException {
        if (csvField != null) {
            writer.write(AbstractCsvExport.correctInputForCSV(csvField, isNumber));
        }
        if (lastField) {
            writer.write(lineSeparator);
        } else {
            writer.write(columnSeparator);
        }
    }

    public final void setPaymentRecipient(PaymentRecipient paymentRecipient) throws IOException {
        this.paymentRecipient = paymentRecipient;
        this.loadRecipientInfo();
    }

    public final PaymentRecipient getPaymentRecipient() {
        return this.paymentRecipient;
    }

    public final void setDisplayName(String displayName) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setDisplayName(displayName);
        }
    }

    public final String getDisplayName() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getDisplayName();
        }
        return null;
    }

    public final void setName(String name) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setName(name);
        }
    }

    public final String getName() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getName();
        }
        return null;
    }

    public final void setTenant(Tenant tenant) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setTenant(tenant);
        }
    }

    public final Tenant getTenant() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getTenant();
        }
        return null;
    }

    public final void setAccountNumber(String accountNumber) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setAccountNumber(accountNumber);
        }
    }

    public final String getAccountNumber() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getAccountNumber();
        }
        return null;
    }

    public final void setBankCode(String bankCode) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setBankCode(bankCode);
        }
    }

    public final String getBankCode() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getBankCode();
        }
        return null;
    }

    public final void setBankName(String bankName) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setBankName(bankName);
        }
    }

    public final String getBankName() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getBankName();
        }
        return null;
    }

    public final void setPurpose(String purpose) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setPurpose(purpose);
        }
    }

    public final String getPurpose() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getPurpose();
        }
        return null;
    }

    public final void setReference(String reference) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setReference(reference);
        }
    }

    public final String getReference() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getReference();
        }
        return null;
    }

    public final void setVopAdditionalInfo(String additionalInfo) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setVopAdditionalInfo(additionalInfo);
        }
    }

    public final String getVopAdditionalInfo() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getVopAdditionalInfo();
        }
        return null;
    }

    public final void setVopName(String name) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setVopName(name);
        }
    }

    public final String getVopName() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getVopName();
        }
        return null;
    }

    public final void setVopReason(String reason) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setVopReason(reason);
        }
    }

    public final String getVopReason() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getVopReason();
        }
        return null;
    }

    public final void setVopResult(String result) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setVopResult(result);
        }
    }

    public final String getVopResult() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getVopResult();
        }
        return null;
    }

    public final void setVopDate(Timestamp date) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setVopDate(date);
        }
    }

    public final Timestamp getVopDate() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getVopDate();
        }
        return null;
    }

    public final void setLastUsage(Timestamp date) {
        if (this.paymentRecipient != null) {
            this.paymentRecipient.setLastUsage(date);
        }
    }

    public final Timestamp getLastUsage() {
        if (this.paymentRecipient != null) {
            return this.paymentRecipient.getLastUsage();
        }
        return null;
    }

    public final void save(User user, boolean useFourEyes) throws IOException {
        if (this.paymentRecipient == null) {
            return;
        }
        this.buildRecipientInfo();
        if (this.bypassFourEyes) {
            useFourEyes = false;
        }
        if (this.savePermanently) {
            PaymentRecipient originalVo = this.paymentRecipient.findOriginalRecipient();
            if (originalVo != null) {
                boolean hasFourEyesChange = this.hasFourEyesChange(originalVo);
                if (hasFourEyesChange || this.hasChangeWithoutForEyes(originalVo)) {
                    this.paymentRecipient.setHasFourEyesChange(hasFourEyesChange);
                    this.paymentRecipient.save(user, useFourEyes);
                }
            } else {
                this.paymentRecipient.save(user, useFourEyes);
            }
        }
    }

    protected abstract boolean hasFourEyesChange(PaymentRecipient var1);

    protected boolean hasChangeWithoutForEyes(PaymentRecipient originalVo) {
        return StringUtils.valuesDiffer(this.paymentRecipient.getPurpose(), originalVo.getPurpose()) || StringUtils.valuesDiffer(this.paymentRecipient.getReference(), originalVo.getReference()) || !Objects.equals(this.paymentRecipient.getLastUsage(), originalVo.getLastUsage());
    }

    protected boolean hasGeneralChanges(PaymentRecipient originalVo) {
        return StringUtils.valuesDiffer(this.paymentRecipient.getDisplayName(), originalVo.getDisplayName()) || StringUtils.valuesDiffer(this.paymentRecipient.getName(), originalVo.getName()) || !this.paymentRecipient.getTenant().getId().equals(originalVo.getTenant().getId()) || StringUtils.valuesDiffer(this.paymentRecipient.getAccountNumber(), originalVo.getAccountNumber()) || StringUtils.valuesDiffer(this.paymentRecipient.getBankCode(), originalVo.getBankCode());
    }

    protected final Properties loadRecipientInfoProperties() throws IOException {
        Properties properties = new Properties();
        if (this.paymentRecipient != null && this.paymentRecipient.getRecipientInfo() != null) {
            properties.load(new StringReader(this.paymentRecipient.getRecipientInfo()));
        }
        return properties;
    }

    protected final void setRecipientInfoProperties(Properties properties) throws IOException {
        StringWriter propsWriter = new StringWriter();
        properties.store(propsWriter, null);
        this.paymentRecipient.setRecipientInfo(propsWriter.toString());
    }

    public abstract void loadFromMultiwebProperties(Properties var1);

    public abstract PaymentType getPaymentType();

    protected abstract void loadRecipientInfo() throws IOException;

    protected abstract void buildRecipientInfo() throws IOException;

    public abstract void csvExport(Writer var1, User var2, Locale var3, char var4, boolean var5, String var6) throws IOException;

    protected static enum MultiwebPropertiesKeys {
        NAME,
        ACCOUNTNO,
        BANKCODE,
        PURPOSE,
        IBAN,
        BIC,
        STREET,
        CITY,
        COUNTRY_CODE,
        BANK_NAME,
        BANK_STREET,
        BANK_CITY,
        BANK_COUNTRY_CODE,
        FEE_TYPE;

    }
}

