/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AbstractTableOverviewPrinter;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public abstract class PeriodicPaymentsTableOverviewPrinter
extends AbstractTableOverviewPrinter<PeriodicPayment> {
    public PeriodicPaymentsTableOverviewPrinter(User user, Locale locale, BLLogger logger) {
        super(user, locale, logger, Util.printLogo(user));
    }

    public PeriodicPaymentsTableOverviewPrinter(User user, Locale locale, BLLogger logger, boolean printLogo) {
        super(user, locale, logger, printLogo);
    }

    @Override
    protected final Map<String, Map<String, List<PeriodicPayment>>> groupPayments(List<PeriodicPayment> payments) {
        HashMap<String, Map<String, List<PeriodicPayment>>> splitMap = new HashMap<String, Map<String, List<PeriodicPayment>>>();
        for (PeriodicPayment payment : payments) {
            String account;
            ArrayList<PeriodicPayment> paymentsList;
            String orderType = this.getPaymentOrderType(payment);
            TreeMap<String, ArrayList<PeriodicPayment>> orderTypeMap = (TreeMap<String, ArrayList<PeriodicPayment>>)splitMap.get(orderType);
            if (orderTypeMap == null) {
                orderTypeMap = new TreeMap<String, ArrayList<PeriodicPayment>>();
                splitMap.put(orderType, orderTypeMap);
            }
            if ((paymentsList = (ArrayList<PeriodicPayment>)orderTypeMap.get(account = this.getPaymentAccountRepresentation(payment))) == null) {
                paymentsList = new ArrayList<PeriodicPayment>();
                orderTypeMap.put(account, paymentsList);
            }
            paymentsList.add(payment);
        }
        return splitMap;
    }

    @Override
    protected final int[] getTableColumnsWidths(boolean withOrderTypeColumn) {
        if (withOrderTypeColumn) {
            return new int[]{16, 16, 7, 16, 7, 7, 10};
        }
        return new int[]{16, 16, 16, 7, 7, 10};
    }

    @Override
    protected final void printTableHeader(BLTable table, boolean withOrderTypeColumn) throws PDFException {
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.recipient", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]), FONT);
        if (withOrderTypeColumn) {
            table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.orderType", new Object[0]), FONT);
        }
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.purpose", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.previousExecutionDate", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.nextExecutionDate", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]), FONT);
    }

    @Override
    protected final void printPayment(BLTable table, PeriodicPayment payment, boolean withOrderTypeColumn) throws PDFException {
        table.addCell(payment.getRecipient(), FONT);
        table.addCell(this.getRecipientAccountRepresentation(payment), FONT);
        if (withOrderTypeColumn) {
            table.addCell(this.getPaymentOrderType(payment), FONT);
        }
        table.addCell(payment.getPurpose(), FONT);
        if (payment.getPreviousExecutionDate() != null) {
            table.addCell(DateFormat.getDateInstance(2, this.locale).format(payment.getPreviousExecutionDate()), FONT);
        } else {
            table.addCell("", FONT);
        }
        if (payment.getNextExecutionDate() != null) {
            table.addCell(DateFormat.getDateInstance(2, this.locale).format(payment.getNextExecutionDate()), FONT);
        } else {
            table.addCell("", FONT);
        }
        if (this.displaySalaries || !this.isSalaryPayment(payment)) {
            table.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
            table.addCell(PaymentUtils.formatAmount(payment.getAmount(), Currency.getInstance(payment.getAmountCurrency()), this.locale), FONT);
            table.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        } else {
            table.addCell("");
        }
    }

    @Override
    protected final String getDocumentTitle() {
        return BankingApiMessages.getString(this.locale, "GeneralMessages.periodicPayments", new Object[0]);
    }

    @Override
    protected final String getTempFilePrefix() {
        return BankingApiMessages.getString(this.locale, "GeneralMessages.periodicPayments", new Object[0]);
    }

    @Override
    protected final String getPaymentOrderType(PeriodicPayment payment) {
        return payment.getOrderTypeOrFileType();
    }

    @Override
    protected final String getPaymentBankName(PeriodicPayment payment) {
        return payment.getBank().getDisplayName();
    }

    @Override
    protected final String getPaymentAccountRepresentation(PeriodicPayment payment) {
        if (payment.getAccount() != null) {
            StringBuilder sb = new StringBuilder(payment.getAccount().getName());
            if (this.usePrefAccountNameAndIban && payment.getAccount().getIban() != null && !payment.getAccount().getIban().isEmpty()) {
                sb.append("(").append(payment.getAccount().getIban()).append(")");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    protected BigDecimal getPaymentAmount(PeriodicPayment payment) {
        return this.getPaymentAmount(payment.getAmount(), this.isSalaryPayment(payment));
    }

    @Override
    protected final Currency getPaymentAmountCurrency(PeriodicPayment payment) {
        return Currency.getInstance(payment.getAmountCurrency());
    }
}

