/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;

public abstract class PeriodicPaymentTableCsvExport
extends AbstractCsvExport<PeriodicPayment> {
    protected final Locale locale;
    protected final boolean displaySalaryAmounts;
    private final boolean ibanColumn;

    public PeriodicPaymentTableCsvExport(Locale locale, boolean displaySalaryAmounts) {
        this(locale, displaySalaryAmounts, false);
    }

    public PeriodicPaymentTableCsvExport(Locale locale, boolean displaySalaryAmounts, boolean ibanColumn) {
        this.locale = locale;
        this.displaySalaryAmounts = displaySalaryAmounts;
        this.ibanColumn = ibanColumn;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]));
        if (this.ibanColumn) {
            this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.iban", new Object[0]));
        }
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.paymentType", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.recipient", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.currency", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.purpose", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.previousExecutionDate", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.nextExecutionDate", new Object[0]));
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, PeriodicPayment payment) throws IOException {
        if (payment.getAccount() != null) {
            this.addCell(writer, payment.getAccount().getName());
            if (this.ibanColumn) {
                this.addCell(writer, payment.getAccount().getIban());
            }
        } else {
            this.addCell(writer, "");
            if (this.ibanColumn) {
                this.addCell(writer, "");
            }
        }
        StringBuilder orderType = new StringBuilder(payment.getOrderTypeOrFileType());
        String orderTypeDescription = this.getPaymentTypeDescription(payment);
        if (orderTypeDescription != null && orderTypeDescription.length() > 0) {
            orderType.append(" (").append(orderTypeDescription).append(')');
        }
        this.addCell(writer, orderType.toString());
        this.addCell(writer, payment.getRecipient());
        if (this.displaySalaryAmounts || !this.isSalaryPayment(payment)) {
            Currency currency = Currency.getInstance(payment.getAmountCurrency());
            this.addCell(writer, PaymentUtils.formatAmount(payment.getAmount(), null, currency.getDefaultFractionDigits(), this.locale), true);
            this.addCell(writer, currency.getCurrencyCode());
        } else {
            this.addCell(writer, null);
            this.addCell(writer, null);
        }
        this.addCell(writer, payment.getPurpose());
        DateFormat dateFormat = DateFormat.getDateInstance(2, this.locale);
        if (payment.getPreviousExecutionDate() != null) {
            this.addCell(writer, dateFormat.format(payment.getPreviousExecutionDate()));
        } else {
            this.addCell(writer, null);
        }
        if (payment.getNextExecutionDate() != null) {
            this.addCell(writer, dateFormat.format(payment.getNextExecutionDate()));
        } else {
            this.addCell(writer, null);
        }
        return true;
    }

    protected abstract String getPaymentTypeDescription(PeriodicPayment var1);

    protected abstract boolean isSalaryPayment(PeriodicPayment var1);
}

