/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.io.Streams;
import de.businesslogics.util.BLLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class PeriodicPaymentImport<PaymentType> {
    private static final Pattern PAYMENT_FILE_PATTERN = Pattern.compile("[A-Za-z0-9]+\\.([A-Za-z0-9_]+)(?<!\\.SCHEDULE|\\.PURPOSE)$");
    private final BLLogger logger;

    public PeriodicPaymentImport(BLLogger logger) {
        this.logger = logger;
    }

    public int importFromZipFile(File file) throws IOException {
        HashMap importPayments = new HashMap();
        ZipFile zipImportFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipEntries = zipImportFile.entries();
        while (zipEntries.hasMoreElements()) {
            PaymentTransferType.PmtType pmtType;
            ZipEntry currentZipEntry = zipEntries.nextElement();
            Matcher paymentFilenameMatcher = PAYMENT_FILE_PATTERN.matcher(currentZipEntry.getName());
            if (!paymentFilenameMatcher.matches() || (pmtType = this.getPaymentType(paymentFilenameMatcher.group(1))) != null && this.importPeriodicPayment(pmtType, zipImportFile, currentZipEntry, importPayments)) continue;
            return -1;
        }
        return this.storePayments(importPayments);
    }

    protected abstract PaymentType loadPaymentFromStream(InputStream var1, PaymentTransferType.PmtType var2) throws IOException;

    protected abstract int storePayments(Map<PeriodicPayment, PaymentType> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importPeriodicPayment(PaymentTransferType.PmtType pmtType, ZipFile importZipFile, ZipEntry paymentFileEntry, Map<PeriodicPayment, PaymentType> importPayments) throws IOException {
        PaymentType payment;
        ZipEntry scheduleFileEntry = importZipFile.getEntry(paymentFileEntry.getName() + ".SCHEDULE");
        if (scheduleFileEntry == null) {
            this.logger.logError("No schedule file found for payment " + paymentFileEntry.getName() + " in file " + importZipFile.getName() + "!");
            return false;
        }
        InputStream paymentFileInputStream = importZipFile.getInputStream(paymentFileEntry);
        try {
            payment = this.loadPaymentFromStream(paymentFileInputStream, pmtType);
        }
        finally {
            Util.closeStream(paymentFileInputStream);
        }
        if (payment == null) {
            return false;
        }
        PeriodicPayment periodicPayment = new PeriodicPayment();
        if (!this.readSchedule(periodicPayment, importZipFile.getInputStream(scheduleFileEntry))) {
            this.logger.logError("Failed to read schedule information for payment " + paymentFileEntry.getName() + " from file " + importZipFile.getName() + "!");
            return false;
        }
        ZipEntry purposeFileEntry = importZipFile.getEntry(paymentFileEntry.getName() + ".PURPOSE");
        if (purposeFileEntry != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Streams.copy(importZipFile.getInputStream(purposeFileEntry), baos, true);
            if (baos.size() > 0) {
                periodicPayment.setGenericPurpose(baos.toString("UTF-8"));
            }
        }
        importPayments.put(periodicPayment, payment);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readSchedule(PeriodicPayment periodicPayment, InputStream scheduleInputStream) throws IOException {
        java.util.Date date;
        ArrayList<String> scheduleInfo = new ArrayList<String>(5);
        try (Scanner scheduleScanner = new Scanner(scheduleInputStream);){
            scheduleScanner.useDelimiter("\\|");
            while (scheduleScanner.hasNext()) {
                scheduleInfo.add(scheduleScanner.next());
            }
        }
        if (scheduleInfo.isEmpty()) {
            return false;
        }
        periodicPayment.setExecutionInterval(PeriodicPayment.ExecutionInterval.valueByCode((String)scheduleInfo.get(0)));
        if (periodicPayment.getExecutionInterval() == null) {
            this.logger.logError("Unknown execution interval: " + (String)scheduleInfo.get(0));
            return false;
        }
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
        if (scheduleInfo.size() > 1 && ((String)scheduleInfo.get(1)).length() > 0) {
            try {
                date = yyyyMMdd.parse((String)scheduleInfo.get(1));
                periodicPayment.setFirstExecutionDate(new Date(date.getTime()));
            }
            catch (ParseException e) {
                this.logger.logWarning("Failed to parse first exeuction date " + (String)scheduleInfo.get(1));
            }
        }
        if (scheduleInfo.size() > 2 && ((String)scheduleInfo.get(2)).length() > 0) {
            try {
                date = yyyyMMdd.parse((String)scheduleInfo.get(2));
                periodicPayment.setLastExecutionDate(new Date(date.getTime()));
            }
            catch (ParseException e) {
                this.logger.logError("Failed to parse last exeuction date " + (String)scheduleInfo.get(2));
            }
        }
        if (scheduleInfo.size() > 3 && ((String)scheduleInfo.get(3)).length() > 0) {
            try {
                date = yyyyMMdd.parse((String)scheduleInfo.get(3));
                periodicPayment.setPreviousExecutionDate(new Date(date.getTime()));
            }
            catch (ParseException e) {
                this.logger.logError("Failed to parse previous exeuction date " + (String)scheduleInfo.get(3));
            }
        }
        if (scheduleInfo.size() > 4 && ((String)scheduleInfo.get(4)).length() > 0) {
            try {
                date = yyyyMMdd.parse((String)scheduleInfo.get(4));
                periodicPayment.setNextExecutionDate(new Date(date.getTime()));
            }
            catch (ParseException e) {
                this.logger.logError("Failed to parse next exeuction date " + (String)scheduleInfo.get(4));
            }
        }
        return true;
    }

    private PaymentTransferType.PmtType getPaymentType(String orderOrPmtType) {
        PaymentTransferType.PmtType result = null;
        try {
            result = PaymentTransferType.PmtType.valueOf(orderOrPmtType);
        }
        catch (IllegalArgumentException e) {
            switch (orderOrPmtType) {
                case "CCT": {
                    result = PaymentTransferType.PmtType.SEPA_TRANSFER;
                    break;
                }
                case "CCU": {
                    result = PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER;
                    break;
                }
                case "CIP": {
                    result = PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER;
                    break;
                }
                case "XCT": {
                    result = PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER;
                    break;
                }
                case "AXZ": {
                    result = PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER;
                    break;
                }
                case "XXC": {
                    result = PaymentTransferType.PmtType.SEPA_VIRTUAL_ACCOUNT_TRANSFER;
                    break;
                }
                case "CDD": {
                    result = PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT;
                    break;
                }
                case "CD1": {
                    result = PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT;
                    break;
                }
                case "CDB": {
                    result = PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT;
                    break;
                }
                case "AZV": {
                    result = PaymentTransferType.PmtType.DTAZV_TRANSFER;
                    break;
                }
                case "RFT": {
                    result = PaymentTransferType.PmtType.MT101_TRANSFER;
                    break;
                }
                case "XE2": {
                    result = PaymentTransferType.PmtType.SWISS_ESR_TRANSFER;
                    break;
                }
                case "XDT": {
                    result = PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_EUR;
                    break;
                }
                case "XWT": {
                    result = PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_NON_EUR;
                    break;
                }
                case "XTG": {
                    result = PaymentTransferType.PmtType.BBK_HBV_TARGET2_TRANSFER;
                    break;
                }
                case "XG2": {
                    result = PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_SWIFT_TRANSFER;
                    break;
                }
                case "XG1": {
                    result = PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_DTA_TRANSFER;
                    break;
                }
                case "XGK": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_DTA_TRANSFER;
                    break;
                }
                case "XLK": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_DTA_DIRECT_DEBIT;
                    break;
                }
                case "XGS": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_STEP2_TRANSFER;
                    break;
                }
                case "XCG": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_TRANSFER;
                    break;
                }
                case "XCL": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_DIRECT_DEBIT;
                    break;
                }
                case "XCS": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_PACKED_STEP2_TRANSFER;
                }
            }
        }
        return result;
    }
}

